##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Protocols
#
# Started on Thursday, 17th of February, 2000 around 11.15pm
#
# Version 0.04 - 21st of March, 2000
# - (12.38pm) Changed ACS_BULLET to ACS_DEGREE
# -  ( ---- ) Added irc__on_lusers
# -  ( ---- ) Fixed .o. thing on server messies
# -  (1.08pm) -- MARK --
# -  ( ---- ) Added irc__on_notice
# -  (1.40pm) Added irc__on_cversion
# -  ( ---- ) Fixed irc__on_cversion
# -  (2.06pm) Added irc__on_topic
# -  ( ---- ) Fixed irc__on_topic
# -  ( ---- ) Fixed join/part message colours
# -  (2.18pm) Really fixed irc__on_topic
# -  ( ---- ) Fixed wrong character on self-actions
# -  (3.58pm) Added irc__on_quit
# -  (4.00pm) Added reason to quit/part message
# -  (4.05pm) Kinda got the reasons to work
# -  (4.20pm) Added irc__notice
# - (10.28pm) Started whois stuffz
# - (10.32pm) Added irc__on_whoisuser
# - (10.34pm) Added irc__whois
#
# Version 0.03 - 20th of March, 2000
# - (11.01pm) Finished more of irc__on_caction from earlier
# - ( ----- ) Added irc__privmsg
# - ( ----- ) Added irc__action and got it working!
# - ( ----- ) Added irc__on_motd
#
# Version 0.02 - 5th of March, 2000
# - (11.14pm) Changed incoming message format and private message format
# - (earlier) Fixed IRC timeouts, even tho I have further work to do on em.
#
# Version 0.01 - 17th of February, 2000
# - (11.15pm) Initial Development
# - ( ----- ) Added several IRC onevents

# IRC Bits!

sub irc__on_connect {
  my $self = shift;

#  AddLine("Connected to IRC!", Lang(24));
}

sub irc__on_motd {
  my ($self, $event) = @_;

  @args = $event->args;
  shift @args;
  AddLine("@args", "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
}

sub irc__on_whoisuser {
  my ($self, $event) = @_;

  $tmpnick = ($event->args)[1];
  $tmphost = ($event->args)[2] . "\@" . ($event->args)[3];
  $tmpname = ($event->args)[5];

  @args = $event->args;

  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%$tmpnick `8(`7$tmphost`8) ()");
  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%i`7rcname  : $tmpname");
}

sub irc__on_whoisserver {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%s`7erver   : @args");
}

sub irc__on_whoisoperator {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%o`7perator : @args");
}

sub irc__on_whoischanop {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%c`7hanop   : @args");
}

sub irc__on_whoisidle {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%i`7dle     : @args");
}

sub irc__on_whoischannels {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%c`7hannels : @args");
}

sub irc__on_endofwhois {
  my ($self, $event) = @_;

  AddLine("`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%e`7nd of WHOIS");
}

sub irc__whois {
  my ($self, $to) = @_;

  $self->whois($to);
}

sub irc__on_lusers {
  my ($self, $event) = @_;

  @args = $event->args;
  shift @args;

  AddLine("@args", "`!" . chr(183) . "`%" . chr(ACS_DEGREE) . "`!" . chr(183) . " `7");
}

sub irc__on_msg {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  AddLine($event->args, "`8[`#$tmpnick`8(`5$tmphost`8)]`7 ");
}

sub irc__on_notice {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  AddLine($event->args, "`8-`#$tmpnick`8(`5$tmphost`8)-`7 ");
}

sub irc__notice {
  my ($self, $to, $data) = @_;

  $self->notice($to, $data);
}

sub irc__on_public {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;

  AddLine($event->args, "`9<`7$tmpnick`9>`7 ");
}

sub irc__privmsg {
  my ($self, $to, $data) = @_;

  $self->privmsg($to, $data);
}

sub irc__on_caction {
  my ($self, $event) = @_;
  @args = $event->args;

  $tmpnick = $event->nick;
  shift @args;

  AddLine("@args", "`8" . chr(ACS_S1) . " `\$$tmpnick `7");
}

sub irc__action {
  my ($self, $to, $data) = @_;

  $self->ctcp("ACTION", $to, $data);
}

sub irc__on_cversion {
  my ($self, $event) = @_;

  $self->ctcp_reply($event->nick, "VERSION AndyChat v$Version - Build $Build");
}

sub irc__on_topic {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  $window[$thiswin]->{topic} = "@args";
  ReTitle("[" . $window[$thiswin]->{channel} . "] " . $window[$thiswin]->{topic});
  refresh();
}

sub irc__on_names {
  my ($self, $event) = @_;

  my (@irconlist, $ircchannel) = ($event->args);

  ($ircchannel, @irconlist) = splice @irconlist, 2;
  @irconlist = split(/ /, $irconlist[0]);
  $irconusers = @irconlist;

  for ($ioni = 0; $ioni < $irconusers; $ioni++)
  {
#    AddUser($thiswin, $ioni + 1, $irconlist[$ioni]);
    if (substr($irconlist[$ioni], 0, 1) eq "+")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($thiswin, 1, $irconlist[$ioni]))
      {
        AddUser($thiswin, $irconlist[$ioni]);
      }
      $usr[$thiswin]->[FindUser($thiswin, 1, $irconlist[$ioni])]->{voice} = 1;
      RedrawNicks;
    }
    elsif (substr($irconlist[$ioni], 0, 1) eq "@")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($thiswin, 1, $irconlist[$ioni]))
      {
        AddUser($thiswin, $irconlist[$ioni]);
      }
      $usr[$thiswin]->[FindUser($thiswin, 1, $irconlist[$ioni])]->{op} = 1;
      RedrawNicks;
    }
    else
    {
      if (not FindUser($thiswin, 1, $irconlist[$ioni]))
      {
        AddUser($thiswin, $irconlist[$ioni]);
      }
    }
  }

}

sub irc__on_join {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  if (not FindUser($thiswin, 1, $tmpnick))
  {
    AddUser($thiswin, $tmpnick);
  }

  AddLine("`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `!$tmpnick `8[`3$tmphost`8] `7has joined $tmpchannel");
#  AddLine("*** $tmpnick ($tmphost) has joined channel $tmpchannel", Lang(24));
}

sub irc__on_part {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

  shift @args;
#  shift @args;

  DelUser($thiswin, $tmpnick);

  AddLine("`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7$tmpnick `8[`7$tmphost`8] `7has left $tmpchannel `8[`7@args`8]");
#  AddLine("*** $tmpnick ($tmphost) has left channel $tmpchannel", Lang(24));
}

sub irc__on_quit {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

#  shift @args;
#  shift @args;

  DelUser($thiswin, $tmpnick);

  AddLine("`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7SignOff `%$tmpnick`7: $tmpchannel `8(`7@args`8)");
}
