sub gotoxy {
  my ($w1, $w2) = @_;

  move($w2, $w1);
}

sub wherex {
  getyx($mainwin, $w1, $w2);

  return $w2;
}

sub wherey {
  getyx($mainwin, $w1, $w2);

  return $w1;
}

sub textcolor {
  my ($w1) = @_;

  init_pair(1, COLOR_BLUE, COLOR_BLACK);
  init_pair(2, COLOR_GREEN, COLOR_BLACK);
  init_pair(3, COLOR_CYAN, COLOR_BLACK);
  init_pair(4, COLOR_RED, COLOR_BLACK);
  init_pair(5, COLOR_MAGENTA, COLOR_BLACK);
  init_pair(6, COLOR_YELLOW, COLOR_BLACK);
  init_pair(7, COLOR_WHITE, COLOR_BLACK);
  init_pair(8, COLOR_BLACK, COLOR_BLACK);

  if (($w1 eq 0) || ($w1 eq 8))
  {
    attrset(COLOR_PAIR(8));
    if ($w1 eq 8) { attron(A_BOLD); }
  }
  elsif ($w1 > 7)
  {
    $w1 = $w1 - 8;
    attrset(COLOR_PAIR($w1));
    attron(A_BOLD);
  }
  else
  {
    attrset(COLOR_PAIR($w1));
  }
}

sub textbackground {
  my ($w1) = @_;

  init_pair(9, COLOR_WHITE, COLOR_BLUE);

  if ($w1 eq 4)
  {
    attrset(COLOR_PAIR(9));
    attron(A_BOLD);
  }
}

sub keypressed {
#  ReadMode(4);
  if (length($kbuff) > 0) { return 1; }
  if (not defined ($w1 = ReadKey(-1)))
  {
    return;
  }
  else
  {
    $kbuff = "$kbuff$w1";
    return 1;
  }
}

sub kbuf {
  $w1 = substr($kbuff, 0, 1);
  if (length($kbuff) > 1)
  {
    $kbuff = substr($kbuff, 1);
  }
  else
  {
    $kbuff = "";
  }
  return $w1;
}
