##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Protocols
#
# Started on Thursday, 17th of February, 2000 around 11.15pm
#
# 11th of April, 2000
# - (11.55pm) Fixed some bugs to do with using ` around the place
#
# 9th of April, 2000
# -  (3.50pm) Fixed CTCP PIZZA crash :P
# -  (4.36pm) Fixed undef value when doing stuff with new channels and stuffz
# -  (4.46pm) Fixed contents of {id} to avoid multiple user@host causing probs :)
# -  (4.48pm) Fix for $tmpnick . "!" . $tmphost eq $my{id}
# - (12.15am) Change so that receiving private actions are in Cyan like sending private actions
#
# 8th of April, 2000
# -  (2.01pm) No more uninit'd value when in unassigned window
# -  (2.15pm) Added RedrawChanInfo after a chanmode change +o or +v on us
# -  (2.43pm) Fixed users randomly joining wrong channel, twas a casing issue
# -  (3.08pm) Several fixes for new $pizza and NoMore* things
# -  (3.17pm) Better channel/topic protection when killwindowonpart in use
# -  (3.28pm) Better protection against dupe pizza servers (on_part/on_quit now kill stale pizzas)
# -  (4.45pm) Added whoisinserverwindow and awayinserverwindow flags for outputting away/whois replies
# -  (5.00pm) Added on_nosuchnick
# - (12.58am) on_motd/on_lusers changes for "Server Messages"
# -  (1.02am) Some fixes for on_mode stuffz
# -  (1.12am) Removed some error checking on whichcontrol :P
# -  (1.16am) Did some schtuffz to umm... the ummm... nick changing code
#
# 6th of April, 2000
# -  (1.23am) Self nick change now causes a ChanInfo bar refresh
# -  (6.00pm) Added irc__mode
# -  (6.18pm) ChanInfo line updated after /part now
# -  (6.40pm) Added $config{killwindowonpart} support
# - (10.55pm) Added $my{op} detection upon join
#
# 5th of April, 2000
# -  (3.11pm) Implemented noupdate stuffz
# -  (3.27pm) Modes +o-o and +v-v should work to a degree
# -  (3.29pm) Fixed bug relating to sorting not happening in 'other' windows
# -  (3.46pm) Added on_cping
# -  (3.49pm) Fixed on_cping (wonder if that would've crashed clients :P)
# -  (4.23pm) Changed some BitchX stuff to AndyChat stuff
# -  (4.25pm) Restored BitchX stuff, AndyChat didn't work :)
# - (11.35pm) Lots more on_mode stuffz
# - (12.04am) Better self-op/self-voice detection
# - (12.12am) User on_mode stuff half implemented, needs seperate function!
# - (12.15am) Added do_usermodechange function mentioned above
# - (12.20am) Made do_chanmodechange function aswell, for initial mode stuff
# - (12.29am) Implemented on_chanmodeis
#
# 4th of April, 2000
# -  (8.44pm) Added better on_topic support
# -  (8.57pm) on_topic support works now :)
# -  (9.57pm) Displays topic change info in room of topic change
# - (10.30pm) Started implementing on_mode
#
# 28th of March, 2000
# -  (2.21am) Added whichcontrol function thing and made AddLine changes
# -  (2.55am) Finished implementing all $thiswin changes (I think)
# -  (3.59am) Fixed ReTitle and RedrawNicks bug in on_part
# -  ( ---- ) Made DoubleQuote changes and scrapped them
# -  (4.14am) DoubleQuote'd public messies
# -  (5.08am) DoubleQuote'd a lot of stuffz :)
# -  (5.12am) Added irc__join
# -  (5.32am) Did lots of conversion for whichcontrol($self, $channel) stuff
# -  (6.11am) Fixed on_away display
# -  (6.19am) Added server workaround for no signon time
# -  (3.00pm) Started implementing foreachcontrol, global stuffz
# -  (3.14pm) foreachcontrol handler works :)  Nick changes now work properly
# -  (3.15pm) Implemented foreachcontrol to on_quit, gotta love this :)
# -  (3.41pm) Channel specific server messies now end up in correct window
# -  (5.12pm) Clears topic (no more [#bla] Joining... with rooms with no topic)
#
# 25th of March, 2000
# -  (1.05pm) Added better irc__on_disconnect parsing
# -  (1.46pm) Added irc__on_whoisvworld
# -  (1.48pm) Added irc__on_whoishelp
# -  (2.00pm) Better irc__on_disconnect parsing
# -  (3.45pm) Fixed typo which crashed upon topic change
#
# 24th of March, 2000
# -  (1.10am) Added irc__on_cpizza
# -  (1.44am) Completed irc__on_cpizza
# -  (1.46am) Minor fixes to irc__on_cpizza
# -  ( ---- ) Implemented irc__on_endofnames and irc__on_whoreply for stuffz
# -  (3.17am) The new irc__on_join pizza stuff works :)
# -  (3.35am) Added irc__nick
# -  (3.45am) Added irc__on_nicknameinuse
# -  (4.11am) Added CTCP display for people requesting VERSION
# -  (1.24pm) Added whois idle parsing
# -  (1.32pm) Added irc__on_awaytoggle for unaway/nowaway modes
# -  (1.40pm) Added irc__on_away
# -  (1.41pm) Added irc__away
# -  (1.49pm) irc__on_away returns correct stuffz now
# -  (1.59pm) irc__on_awaytoggle now shows the args in grey
# -  (7.49pm) irc__on_msg now adds to pagess buffer
# -  (8.19pm) And does it properly too!
# - (11.14pm) Added irc__part
# - (11.38pm) Added irc__quit
# - (11.44pm) Added irc__on_disconnect
# - (11.51pm) Parsed the quit reason properly
#
# 23rd of March, 2000
# -  (7.03pm) Added irc__ctcp
# - (10.15pm) irc__on_join now sets $usr{id} to hostmask
# - (11.37pm) irc__on_join triggers a ctcp pizza if me = pizza server
#
# 22nd of March, 2000
# -  (1.26am) Added irc__on_nick
#
# 21st of March, 2000
# - (12.38pm) Changed ACS_BULLET to ACS_DEGREE
# -  ( ---- ) Added irc__on_lusers
# -  ( ---- ) Fixed .o. thing on server messies
# -  (1.08pm) -- MARK --
# -  ( ---- ) Added irc__on_notice
# -  (1.40pm) Added irc__on_cversion
# -  ( ---- ) Fixed irc__on_cversion
# -  (2.06pm) Added irc__on_topic
# -  ( ---- ) Fixed irc__on_topic
# -  ( ---- ) Fixed join/part message colours
# -  (2.18pm) Really fixed irc__on_topic
# -  ( ---- ) Fixed wrong character on self-actions
# -  (3.58pm) Added irc__on_quit
# -  (4.00pm) Added reason to quit/part message
# -  (4.05pm) Kinda got the reasons to work
# -  (4.20pm) Added irc__notice
# - (10.28pm) Started whois stuffz
# - (10.32pm) Added irc__on_whoisuser
# - (10.34pm) Added irc__whois
#
# 20th of March, 2000
# - (11.01pm) Finished more of irc__on_caction from earlier
# - ( ----- ) Added irc__privmsg
# - ( ----- ) Added irc__action and got it working!
# - ( ----- ) Added irc__on_motd
#
# 5th of March, 2000
# - (11.14pm) Changed incoming message format and private message format
# - (earlier) Fixed IRC timeouts, even tho I have further work to do on em.
#
# 17th of February, 2000
# - (11.15pm) Initial Development
# - ( ----- ) Added several IRC onevents

sub whichcontrol {
  my ($self, $channel) = @_;

#  Error protection removed *grins*  Beware :)
#
#  if ($channel && substr($channel, 0, 1) ne "#" && substr($channel, 0, 1) ne "&")
#  {
#    $channel = "";
#  }

  if ($window[$thiswin]{control} && $self eq $window[$thiswin]{control})
  {
    if (! $channel || uc($window[$thiswin]{channel}) eq uc($channel))
    {
      $whichwin = $thiswin;
      return $thiswin;
    }
  }

  for ($ap_i = 1; $ap_i <= $windowcount; $ap_i++)
  {
    if ($window[$ap_i]{control} && $self eq $window[$ap_i]{control})
    {
      if (! $channel || uc($window[$ap_i]{channel}) eq uc($channel))
      {
        $whichwin = $ap_i;
        return $ap_i;
      }
    }
  }
  $whichwin = $thiswin;
  return $thiswin;
}

sub foreachcontrol {
  my ($self, $todo) = @_;

  for ($ap_z = 1; $ap_z <= $windowcount; $ap_z++)
  {
    if ($window[$ap_z]{control} && $self eq $window[$ap_z]{control})
    {
      &{$todo}($ap_z);
    }
  }
}

# Intermediate IRC Bits!

sub irc__inroom {
  my ($whichwin) = @_;

  if ($window[$whichwin]{channel} && uc($window[$whichwin]{channel}) eq uc($tmpchannel))
  {
    $tmpchannels++;
  }
}

# IRC Bits!

sub irc__on_connect {
  my $self = shift;

  if ($config{invisonirc})
  {
    $self->mode($my[whichcontrol($self)]{name}, "+i");
  }
#  AddLine("Connected to IRC!", Lang(24));
}

sub irc__on_motd {
  my ($self, $event) = @_;

  @args = $event->args;
  shift @args;
  $tmpchannel = @args[0];

  if (substr($tmpchannel, 0, 1) eq "#" || substr($tmpchannel, 0, 1) eq "&")
  {
    if (index($tmpchannel, " ") > 1)
    {
      $tmpchannel = substr($tmpchannel, 0, index($tmpchannel, " "));
    }
    $whichwin = whichcontrol($self, $tmpchannel);
  }
  else
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
#  AddLine($whichwin, "@args", "`@-`%o`@- `7");
  AddLine($whichwin, DoubleQuote("@args"), "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
}

sub irc__on_whoisuser {
  my ($self, $event) = @_;

  $tmpnick = ($event->args)[1];
  $tmphost = ($event->args)[2] . "\@" . ($event->args)[3];
  $tmpname = ($event->args)[5];

  @args = $event->args;

  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "`0-`%=`0- `%" . DoubleQuote($tmpnick) . " `8(`7" . DoubleQuote($tmphost) . "`8) ()");
#  AddLine($whichwin, $tmpname, "`0-`%=`0- `%i`7rcname  : ");

  AddLine($whichwin, "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%" . DoubleQuote($tmpnick) . " `8(`7" . DoubleQuote($tmphost) . "`8) ()");
  AddLine($whichwin, DoubleQuote($tmpname), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%i`7rcname  : ");
}

sub irc__on_whoisserver {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%s`7erver   : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%s`7erver   : ");
}

sub irc__on_whoisoperator {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%o`7perator : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%o`7perator : ");
}

sub irc__on_whoischanop {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%c`7hanop   : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%c`7hanop   : ");
}

sub irc__on_whoisvworld {
  my ($self, $event) = @_;

  $tmphost = ($event->args)[2];

  $tmphost = substr($tmphost, rindex($tmphost, " ") + 1);

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, $tmphost, "`0-`%=`0- `%v`7world   : ");
  AddLine($whichwin, DoubleQuote($tmphost), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%v`7world   : ");
}

sub irc__on_whoishelp {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%i`7nfo     : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%i`7nfo     : ");
}

sub irc__on_whoisidle {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  $tmpidle = @args[0];
  $tmpsignon = @args[1];

  if (index($tmpsignon, "idle") > -1)
  {
    $tmpsignon = 0;
  }
  else
  {
    $tmpsignon = @args[1];
  }

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "`0-`%=`0- `%i`7dle     : " . readablesecs($tmpidle) . " (signon: " . localtime($tmpsignon) . ")");
  AddLine($whichwin, "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%i`7dle     : " . readablesecs($tmpidle) . " (signon: " . localtime($tmpsignon) . ")");
}

sub irc__on_whoischannels {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%c`7hannels : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%c`7hannels : ");
}

sub irc__on_endofwhois {
  my ($self, $event) = @_;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, "`0-`%=`0- `%e`7nd of WHOIS");
  AddLine($whichwin, "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%e`7nd of WHOIS");
}

sub irc__whois {
  my ($self, $to) = @_;

  $self->whois($to);
}

sub irc__on_away {
  my ($self, $event) = @_;

  @args = $event->args;

  $tmpnick = @args[1];

  shift @args;
  shift @args;

  if ($config{awayinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, $tmpnick . " - @args", "`0-`%=`0- `%a`7way     : ");
  AddLine($whichwin, DoubleQuote($tmpnick) . " - " . DoubleQuote("@args"), "`0" . chr(183) . "`%" . chr(ACS_DEGREE) . "`0" . chr(183) . " `%a`7way     : ");
}

sub irc__on_nosuchnick {
  my ($self, $event) = @_;

  @args = $event->args;

  $tmpnick = @args[1];

  shift @args;
  shift @args;

  if ($config{nouserinserverwindow})
  {
    $whichwin = whichcontrol($self, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self);
  }

#  AddLine($whichwin, " - @args", "`#-`%=`#- `%$tmpnick`7");
  AddLine($whichwin, " - " . DoubleQuote("@args"), "`#" . chr(183) . "`%" . chr(ACS_DEGREE) . "`#" . chr(183) . " `%" . DoubleQuote($tmpnick) . "`7");
}

sub irc__away {
  my ($self, $data) = @_;

  $self->away($data);
}

sub irc__on_awaytoggle {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;

#  AddLine(whichcontrol($self), "@args", "`@-`%=`@- `7");
  AddLine(whichcontrol($self), DoubleQuote("@args"), "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
}

sub irc__on_nicknameinuse {
  my ($self, $event) = @_;

  $my[whichcontrol($self)]{name} = ($event->args)[0];
  $tmpnick = ($event->args)[1];

#  AddLine(whichcontrol($self), "`@-`%=`@- `%" . DoubleQuote($tmpnick) . " `7is already in use or forbidden");
  AddLine(whichcontrol($self), "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `%" . DoubleQuote($tmpnick) . " `7is already in use or forbidden");
}

sub irc__do_nickchange {
  my ($whichwin) = @_;

  if ($tmpnick eq $my[$whichwin]{name})
  {
    $my[$whichwin]{name} = $newnick;
    if ($whichwin eq $thiswin)
    {
      RedrawChanInfo();
    }
  }

  if (FindUser($whichwin, 1, $tmpnick))
  {
    RenUser($whichwin, $tmpnick, $newnick);

#    AddLine($whichwin, "`@-`%=`@- `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
    AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
  }
}

sub irc__on_nick {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
#  $tmphost = $event->host;
  $newnick = ($event->args)[0];

  foreachcontrol($self, \&irc__do_nickchange);

#  RenUser(whichcontrol($self, $tmpto), $tmpnick, $newnick);

#  AddLine(whichcontrol($self, $tmpto), "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
}

sub irc__nick {
  my ($self, $data) = @_;

  $self->nick($data);
}

sub irc__do_usermodechange {
  my ($whichwin) = @_;

  for ($ap_i = 0; $ap_i < length($tmpmodes); $ap_i++)
  {
    if (substr($tmpmodes, $ap_i, 1) eq "+")
    {
      $tf = 1;
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "-")
    {
      $tf = "";
    }
    else
    {
      if ($tf)
      {
        if ($my[$whichwin]{modes})
        {
          if (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > -1)
          {
            AddLine($whichwin, "    `\@Warning`7: `\%User mode set twice");
          }
          else
          {
            $my[$whichwin]{modes} = $my[$whichwin]{modes} . substr($tmpmodes, $ap_i, 1);
          }
        }
        else
        {
          $my[$whichwin]{modes} = substr($tmpmodes, $ap_i, 1);
        }
      }
      else
      {
        if (! $my[$whichwin]{modes} || index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < 0)
        {
          AddLine($whichwin, "    `\@Warning`7: `\%User mode undefined before defined");
        }
        else
        {
          if (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0 && index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < length($my[$whichwin]{modes}) - 1)
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 0, index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1))) .
                                    substr($my[$whichwin]{modes}, index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) + 1);
          }
          elsif (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0)
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 0, -1);
          }
          else
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 1);
          }
        }
      }
    }
  }
}

sub irc__do_chanmodechange {
  my ($whichwin) = @_;

  for ($ap_i = 0; $ap_i < length($tmpmodes); $ap_i++)
  {
    if (substr($tmpmodes, $ap_i, 1) eq "+")
    {
      $tf = 1;
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "-")
    {
      $tf = "";
    }
    # o [user]	op
    # v [user]	voice
    # b [mask]	ban

    # k [key] require [key] to join channel
    # l [num]	limit channel number to [num]

    # i	invite only
    # m	moderated, voices only
    # n	no external messages
    # p	private
    # t	topic change restricted to ops
    # s	secret
    elsif (substr($tmpmodes, $ap_i, 1) eq "o")
    {
      $tm++;
      $tmpnum = FindUser($whichwin, 1, $args[$tm]);
      if ($tmpnum)
      {
        $usr[$whichwin][$tmpnum]{op} = $tf;
        if ($usr[$whichwin][$tmpnum]{me})
        {
          $my[$whichwin]{op} = $tf;
          RedrawChanInfo();
        }
        SortUsers($whichwin);
        if ($whichwin eq $thiswin) { RedrawNicks; }
      }
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "v")
    {
      $tm++;
      $tmpnum = FindUser($whichwin, 1, $args[$tm]);
      if ($tmpnum)
      {
        $usr[$whichwin][$tmpnum]{voice} = $tf;
        if ($usr[$whichwin][$tmpnum]{me})
        {
          $my[$whichwin]{voice} = $tf;
          RedrawChanInfo();
        }
        SortUsers($whichwin);
        if ($whichwin eq $thiswin) { RedrawNicks; }
      }
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "b")
    {
    }
    else
    {
      if (substr($tmpmodes, $ap_i, 1) eq "k")
      {
        if ($tf)
        {
          $tm++;
          $window[$whichwin]{key} = $args[$tm];
        }
        else
        {
          $tm++;
          $window[$whichwin]{key} = "";
          if ($window[$whichwin]{key} && $window[$whichwin]{key} ne $args[$tm])
          {
            AddLine($whichwin, "    `\@Security Error`7: `\%Key change doesn't match previous key!  Ignoring tho :P");
          }
        }
      }
      elsif (substr($tmpmodes, $ap_i, 1) eq "l")
      {
        if ($tf)
        {
          $tm++;
          $window[$whichwin]{limit} = $args[$tm];
        }
        else
        {
          $window[$whichwin]{limit} = "";
        }
      }
      if ($tf)
      {
        if ($window[$whichwin]{modes})
        {
          if (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > -1)
          {
            AddLine($whichwin, "    `\@Warning`7: `\%Channel mode set twice");
          }
          else
          {
            $window[$whichwin]{modes} = $window[$whichwin]{modes} . substr($tmpmodes, $ap_i, 1);
          }
        }
        else
        {
          $window[$whichwin]{modes} = substr($tmpmodes, $ap_i, 1);
        }
      }
      else
      {
        if (! $window[$whichwin]{modes} || index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < 0)
        {
          AddLine($whichwin, "    `\@Warning`7: `\%Channel mode undefined before defined");
        }
        else
        {
          if (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0 && index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < length($window[$whichwin]{modes}) - 1)
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 0, index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1))) .
                                        substr($window[$whichwin]{modes}, index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) + 1);
          }
          elsif (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0)
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 0, -1);
          }
          else
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 1);
          }
        }
      }
    }
  }

  if ($tmpnick)
  {
    AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7mode`8/`3" . DoubleQuote($tmpto) . " `8[`%" . DoubleQuote("@args") . "`8] `7by `%" . DoubleQuote($tmpnick));
  }
  RedrawChanInfo;
}

sub irc__on_chanmodeis {
  my ($self, $event) = @_;

  @args = $event->args;
  $tmpto = $args[1];
  $tmpnick = "";

  shift @args;
  shift @args;

  $whichwin = whichcontrol($self, $tmpto);
  $tmpmodes = $args[0];
  $tm = 0; $tf = 1;

  irc__do_chanmodechange($whichwin);
}

sub irc__mode {
  my ($self, $to, $data) = @_;

  $self->mode($to, $data);
}

sub irc__on_mode {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;
  $argsize = @args;

  if (substr($tmpto, 0, 1) ne "#" && substr($tmpto, 0, 1) ne "&")
  {
    $tmpmodes = @args[0];
    $tm = 0; $tf = 1;

    foreachcontrol($self, \&irc__do_usermodechange);

    $whichwin = whichcontrol($self, "Server Messages");
    AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7Mode change `8[`%" . DoubleQuote("@args") . "`8] `7for user `3" . DoubleQuote($tmpto));
    if ($self eq $window[$thiswin]{control})
    {
      RedrawChanInfo();
    }
  }
  else
  {
    $whichwin = whichcontrol($self, $tmpto);
    $tmpmodes = $args[0];
    $tm = 0; $tf = 1;

    irc__do_chanmodechange($whichwin);
    if ($whichwin eq $thiswin)
    {
      RedrawChanInfo();
    }
  }
}

sub irc__on_debug {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;
  $argsize = @args;

  AddLine($thiswin, "From: $tmpnick");
  AddLine($thiswin, "  To: $tmpto");
  AddLine($thiswin, "Data: $argsize - @args");
}

sub irc__on_lusers {
  my ($self, $event) = @_;

  @args = $event->args;
  shift @args;

#  AddLine(whichcontrol($self), "@args", "`!-`%=`!- `7");
  AddLine(whichcontrol($self, "Server Messages"), DoubleQuote("@args"), "`!" . chr(183) . "`%" . chr(ACS_DEGREE) . "`!" . chr(183) . " `7");
}

sub irc__on_msg {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];

  @args = $event->args;

  if ($config{paging})
  {
    if ($pagesswaiting > 1)
    {
      $pagesswaiting--; 
      UpdateGame(6);
    }
    if ($pagesswaiting < 22)
    {
      for ($ap_i = $pagesswaiting; $ap_i <= 22; $ap_i++)
      {
        if ($ap_i > 1)
        {
          $pagess[$ap_i - 1] = $pagess[$ap_i];
        }
      }
    }
    $pagess[21] = $tmpnick . " whispers @args";
    AddLog(whichcontrol($self), $pagess[21]);
  }

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  AddLine(whichcontrol($self, $tmpto), $event->args, "`8[`#" . DoubleQuote($tmpnick) . "`8(`5" . DoubleQuote($tmphost) . "`8)]`7 ");
}

sub irc__on_notice {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  AddLine(whichcontrol($self, $tmpto), $event->args, "`8-`#" . DoubleQuote($tmpnick) . "`8(`5" . DoubleQuote($tmphost) . "`8)-`7 ");
}

sub irc__notice {
  my ($self, $to, $data) = @_;

  $self->notice($to, $data);
}

sub irc__on_public {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];

  AddLine(whichcontrol($self, $tmpto), $event->args, "`9<`7" . DoubleQuote($tmpnick) . "`9>`7 ");
}

sub irc__privmsg {
  my ($self, $to, $data) = @_;

  $self->privmsg($to, $data);
}

sub irc__on_caction {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];

  @args = $event->args;
  shift @args;

  if (substr($tmpto, 0, 1) eq "&" || substr($tmpto, 0, 1) eq "#")
  {
    AddLine(whichcontrol($self, $tmpto), "@args", "`8" . chr(ACS_S1) . " `\$" . DoubleQuote($tmpnick) . " `7");
  }
  else
  {
    AddLine(whichcontrol($self, $tmpto), "@args", "`8" . chr(ACS_S1) . " `!" . DoubleQuote($tmpnick) . " `7");
  }
}

sub irc__action {
  my ($self, $to, $data) = @_;

  $self->ctcp("ACTION", $to, $data);
}

sub irc__ctcp {
  my ($self, $to, $data) = @_;

  if (index($data, " ") > -1)
  {
    $self->ctcp(substr($data, 0, index($data, " ")), $to, substr($data, index($data, " ") + 1));
  }
  else
  {
    $self->ctcp($data, $to);
  }
}

sub irc__on_cunknown {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  AddLine(whichcontrol($self, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested unknown ctcp " . DoubleQuote("@args") . " `7from " . DoubleQuote($tmpto));
}

sub irc__on_cpizza {
  my ($self, $event) = @_;

  $tmpto = ($event->to)[0];
  $tmpnum = FindUser(whichcontrol($self, $tmpto), 1, $event->nick);

  if (substr($tmpto, 0, 1) ne "#" && substr($tmpto, 0, 1) ne "&")
  {
    # Shouldn't be here..  Yes it should :)  My bad :)  Will fix soon :)  Found @ 5.20am . 0328
    irc__on_cunknown($self, $event);
    return;
  }

  $whichwin = whichcontrol($self, $tmpto);

  if ($tmpnum)
  {
    if ($window[$whichwin]{pizzahost})
    {
      if ($window[$whichwin]{pizzahost} eq $usr[$whichwin][$tmpnum]{id})
      {
        NoMorePizzas($whichwin);
        AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
        return;
      }
      AddLine($whichwin, "Pizza Server Collision!  But we'll ignore this for now...", Lang(16));
    }
    $window[$whichwin]{pizzahost} = $usr[$whichwin][$tmpnum]{id};
    if ($window[$whichwin]{pizzas})
    {
      for ($ap_i = 1; $ap_i <= $window[$whichwin]{pizzas}; $ap_i++)
      {
        $pizza[$whichwin][$ap_i]{topping} = "";
        $pizza[$whichwin][$ap_i]{price} = 0;
      }
    }
    $window[$whichwin]{pizzas} = "";
    AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(85));
  }
  else
  {
    AddLine($whichwin, "Imaginary user tried to start a Pizza Server..", Lang(16));
  }
}

sub irc__on_cversion {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  $self->ctcp_reply($event->nick, "VERSION AndyChat v$Version - Build $Build");

  AddLine(whichcontrol($self, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested " . DoubleQuote("@args") . " `7from " . DoubleQuote($tmpto));
}

sub irc__on_cping {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  $self->ctcp_reply($event->nick, "@args");

  AddLine(whichcontrol($self, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested " . DoubleQuote("@args") . " `7from " . DoubleQuote($tmpto));
}

sub irc__on_topic {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;

#  AddLine($thiswin, "Topic: $tmpto - @args");

  if ($tmpto)
  {
    $window[whichcontrol($self, $tmpto)]->{topic} = Strrrp("@args");
    if (whichcontrol($self, $tmpto) eq $thiswin)
    {
      ReTitle("[" . $window[$thiswin]->{channel} . "] " . Strrrp(DoubleQuote($window[$thiswin]->{topic})));
      refresh();
    }
#    AddLine(whichcontrol($self, $tmpto), "`@-`%=`@- `7Topic `8(`3$tmpto`8): `7changed by `3$tmpnick`8: `7@args");
    AddLine(whichcontrol($self, $tmpto), "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7Topic `8(`3$tmpto`8): `7changed by `3$tmpnick`8: `7@args");
  }
  else
  {
    shift @args;
    $tmpto = @args[0];
    shift @args;

    $window[whichcontrol($self, $tmpto)]->{topic} = Strrrp("@args");
    if (whichcontrol($self, $tmpto) eq $thiswin)
    {
      ReTitle("[" . $window[$thiswin]->{channel} . "] " . Strrrp(DoubleQuote($window[$thiswin]->{topic})));
      refresh();
    }
  }
}

sub irc__topic {
  my ($self, $to, $data) = @_;

  $self->topic($to, $data);
}

sub irc__on_whoreply {
  my ($self, $event) = @_;

  $tmpchannel = ($event->args)[1];
  $tmpnick = ($event->args)[5];
  $tmphost = ($event->args)[2] . "\@" . ($event->args)[3];
  @args = $event->args;

  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;

  $tmpname = "@args";

  $tmpnum = FindUser(whichcontrol($self), 1, $tmpnick);
  if ($tmpnum)
  {
    $usr[$whichwin][$tmpnum]{name} = $tmpnick;
    $usr[$whichwin][$tmpnum]{id} = $tmpnick . "!" . $tmphost;
    $usr[$whichwin][$tmpnum]{fullname} = $tmpname;
  }
}

sub irc__on_endofnames {
  my ($self, $event) = @_;

  $tmpchannel = ($event->args)[1];

  $self->who($tmpchannel);
}

sub irc__on_names {
  my ($self, $event) = @_;

  my (@irconlist, $ircchannel) = ($event->args);

  ($ircchannel, @irconlist) = splice @irconlist, 2;
  @irconlist = split(/ /, $irconlist[0]);
  $irconusers = @irconlist;

  $whichwin = whichcontrol($self);

  $window[$whichwin]{noupdate} = 1;

  for ($ioni = 0; $ioni < $irconusers; $ioni++)
  {
#    AddUser($win, $ioni + 1, $irconlist[$ioni]);
    if (substr($irconlist[$ioni], 0, 1) eq "+")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
      }
      $tmpnum = FindUser($whichwin, 1, $irconlist[$ioni]);
      $usr[$whichwin]->[$tmpnum]->{voice} = 1;
      if ($usr[$whichwin][$tmpnum]{me})
      {
        $my[$whichwin]{voice} = 1;
        RedrawChanInfo();
      }
      $window[$whichwin]{noupdate}++;
    }
    elsif (substr($irconlist[$ioni], 0, 1) eq "@")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
      }
      $tmpnum = FindUser($whichwin, 1, $irconlist[$ioni]);
      $usr[$whichwin]->[$tmpnum]->{op} = 1;
      if ($usr[$whichwin][$tmpnum]{me})
      {
        $my[$whichwin]{op} = 1;
        RedrawChanInfo();
      }
      $window[$whichwin]{noupdate}++;
    }
    else
    {
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
      }
      $window[$whichwin]{noupdate}++;
    }
  }

  if ($window[$thiswin]{noupdate} > 1)
  {
    SortUsers($thiswin);
    if ($whichwin eq $thiswin)
    {
      RedrawNicks();
    }
  }
  $window[$thiswin]{noupdate} = 0;
}

sub irc__join {
  my ($self, $to) = @_;

  $self->join($to);
}

sub irc__on_join {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  $whichwin = whichcontrol($self, $tmpchannel);

  if (not FindUser($whichwin, 1, $tmpnick))
  {
    AddUser($whichwin, $tmpnick);
  }
  $tmpnum = FindUser($whichwin, 1, $tmpnick);
  $usr[$whichwin][$tmpnum]{id} = $tmpnick . "!" . $tmphost;

  if ($tmpnick eq $my[$whichwin]{name})
  {
    $my[$whichwin]{id} = $tmpnick . "!" . $tmphost;
    ReTitle("[" . $window[$whichwin]{channel} . "]");
    $usr[$whichwin][$tmpnum]{me} = 1;
    $self->mode($tmpchannel);
    RedrawChanInfo();
  }

  if ($window[$whichwin]{pizzahost} && $window[$whichwin]{pizzahost} eq $my[$whichwin]{id})
  {
    my $tmppizzas = "";
    if ($window[$whichwin]{pizzas})
    {
      for ($ap_i = 1; $ap_i <= $window[$whichwin]{pizzas}; $ap_i++)
      {
        $tmppizzas = $tmppizzas . $pizza[$whichwin][$ap_i]{price} . " " . $pizza[$whichwin][$ap_i]{topping};
        if ($ap_i < $window[$whichwin]{pizzas})
        {
          $tmppizzas = $tmppizzas . "|";
        }
      }
      $tmppizzas = " " . $tmppizzas;
    }
    irc__ctcp($window[$whichwin]{control}, $tmpnick, "PIZZA" . $tmppizzas);
  }

#  AddLine($whichwin, "`@-`%o`@- `!" . DoubleQuote($tmpnick) . " `8[`3" . DoubleQuote($tmphost) . "`8] `7has joined " . DoubleQuote($tmpchannel));
  AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `!" . DoubleQuote($tmpnick) . " `8[`3" . DoubleQuote($tmphost) . "`8] `7has joined " . DoubleQuote($tmpchannel));
#  AddLine("*** $tmpnick ($tmphost) has joined channel $tmpchannel", Lang(24));
}

sub irc__on_kick {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

  shift @args;

  $tmpfrom = @args[0];

  shift @args;

  $whichwin = whichcontrol($self, $tmpchannel);

  DelUser($whichwin, $tmpnick);

  if ($my[$whichwin]{id} && $tmpnick . "!" . $tmphost eq $my[$whichwin]{id})
  {
    if ($config{killwindowonkick} && $whichwin > 1)
    {
      ClearChatWindow($whichwin);
      if ($whichwin eq $windowcount) { $windowcount--; }
      newWindowInit($whichwin, 0);
      if ($whichwin eq $thiswin)
      {
        while (! $window[$thiswin]{protocol})
        {
          $thiswin++;
          if ($thiswin > $windowcount) { $thiswin = 1; }
        }
        RedrawNicks();
        RedrawLines();
        RedrawChanInfo();
        if ($window[$thiswin]{channel})
        {
          if ($window[$thiswin]{topic}) 
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          else
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
        }
      }
      AddLine(whichcontrol($self, "Server Messages"), "`8>`7>`%> `%You `7have been kicked off `3" . DoubleQuote($window[$thiswin]{channel}) . " `7by `3" . DoubleQuote($tmpfrom) . " `8(`7@args`8)");
    }
    else
    {
      DelUser($whichwin);
      NoMorePizzas($whichwin);
      $window[$whichwin]{channel} = "";
      if ($whichwin eq $thiswin)
      {
        RedrawNicks();
      }
      RedrawChanInfo();
#      ReTitle("");
      $window[$whichwin]{topic} = "";

      AddLine($whichwin, "`8>`7>`%> `%You `7have been kicked off `3" . DoubleQuote($window[$thiswin]{channel}) . " `7by `3" . DoubleQuote($tmpfrom) . " `8(`7@args`8)");
    }
  }
  else
  {
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $tmphost)
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    AddLine($whichwin, "`8>`7>`%> `7" . DoubleQuote($tmpnick) . " was kicked off `3" . DoubleQuote($window[$thiswin]{channel}) . " `7by `3" . DoubleQuote($tmpfrom) . " `8(`7@args`8)");
  }
}

sub irc__part {
  my ($self, $to, $data) = @_;

  $self->part($to);
}

sub irc__on_part {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

  shift @args;
#  shift @args;

  $whichwin = whichcontrol($self, $tmpchannel);

  DelUser($whichwin, $tmpnick);

  if ($my[$whichwin]{id} && $tmpnick . "!" . $tmphost eq $my[$whichwin]{id})
  {
    if ($config{killwindowonpart} && $whichwin > 1)
    {
      ClearChatWindow($whichwin);
      if ($whichwin eq $windowcount) { $windowcount--; }
      newWindowInit($whichwin, 0);
      if ($whichwin eq $thiswin)
      {
        while (! $window[$thiswin]{protocol})
        {
          $thiswin++;
          if ($thiswin > $windowcount) { $thiswin = 1; }
        }
        RedrawNicks();
        RedrawLines();
        RedrawChanInfo();
        if ($window[$thiswin]{channel})
        {
          if ($window[$thiswin]{topic}) 
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          else
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
        }
      }
    }
    else
    {
      DelUser($whichwin);
      NoMorePizzas($whichwin);
      $window[$whichwin]{channel} = "";
      if ($whichwin eq $thiswin)
      {
        RedrawNicks();
      }
      RedrawChanInfo();
#      ReTitle("");
      $window[$whichwin]{topic} = "";

      AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7" . DoubleQuote($tmpnick) . " `8[`7" . DoubleQuote($tmphost) . "`8] `7has left " . DoubleQuote($tmpchannel) . " `8[`7" . DoubleQuote("@args") . "`8]");
    }
  }
  else
  {
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $tmphost)
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7" . DoubleQuote($tmpnick) . " `8[`7" . DoubleQuote($tmphost) . "`8] `7has left " . DoubleQuote($tmpchannel) . " `8[`7" . DoubleQuote("@args") . "`8]");
  }
}

sub irc__quit {
  my ($self, $data) = @_;

  $self->quit($data);
}

sub irc__on_disconnect {
  my ($self, $event) = @_;

  $tmpnick = ($event->args)[0];

  $whichwin = whichcontrol($self);

  if (index($tmpnick, ":") > -1)
  {
    $tmpnick = substr($tmpnick, index($tmpnick, ":") + 1);
    $tmpnick = substr($tmpnick, index($tmpnick, ":") + 2);
  }

  if (index($tmpnick, "[") > -1)
  {
    $tmpreason = substr($tmpnick, index($tmpnick, "(") + 1, -1);
    $tmpnick = substr($tmpnick, 0, index($tmpnick, "["));
  }
  else
  {
    if (index($tmpnick, "(") > -1)
    {
      $tmpreason = substr($tmpnick, index($tmpnick, "(") + 1, -1);
      $tmpnick = substr($tmpnick, 0, index($tmpnick, "(") - 1);
    }
    else
    {
      $tmpreason = $tmpnick;
      $tmpnick = $my[$whichwin]{name};
    }
  }

  DelUser($whichwin);
  NoMorePizzas($whichwin);
  NoMoreMe($whichwin);

  if ($whichwin eq $thiswin)
  {
    RedrawNicks;
  }

  $window[$whichwin]{channel} = "";
  $window[$whichwin]{protocol} = 1;

  $ircconnections--;

#  AddLine($whichwin, "`@-`%=`@- `7SignOff `%" . DoubleQuote($tmpnick) . "`7: `8(`7" . DoubleQuote($tmpreason) . "`8)");
  AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7SignOff `%" . DoubleQuote($tmpnick) . "`7: `8(`7" . DoubleQuote($tmpreason) . "`8)");
}

sub irc__do_quit {
  my ($whichwin) = @_;

  my $tmpnum = FindUser($whichwin, 1, $tmpnick);

  if (FindUser($whichwin, 1, $tmpnick))
  {
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $usr[$whichwin][$tmpnum]{id})
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    DelUser($whichwin, $tmpnick);
    AddLine($whichwin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7SignOff `%" . DoubleQuote($tmpnick) . "`7: " . $window[$whichwin]{channel} . " `8(`7" . DoubleQuote("@args") . "`8)");
  }
}

sub irc__on_quit {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->host;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

#  shift @args;
#  shift @args;

  foreachcontrol($self, \&irc__do_quit);
}
