##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Common
#
# Started on Wednesday, 9th of February, 2000 around 11pm-midnight
#
# 5th of May, 2000
# -  (8.18am) ^O ne ^P (this damn bug is driving me insane!)
# - (12.51pm) ClearChatWindow with new stuff, more AddLine with new stuff,
#             LordWrite with new stuff, textcolor with new stuff
# -  (1.00pm) RedrawLines new stuff
#
# 29th of April, 2000
# -  (9.02am) Modified SortUsers
# -  (9.32am) Oh baby! :)  SortUsers now works properly!! :)
# -  (7.25pm) Added NoMoreChannel thingie
# -  (8.44pm) Finally did unshift properly, nice code speedup there :)
# -  (8.46pm) Made ClearChatWindow work too :)
# -  (9.21pm) Optimized RedrawLines to not do stupid spaces when unnecessary
# -  (9.43pm) Fixed ClearChatWindow memory leak
# - (10.15pm) Another ClearChatWindow uninit'd value fix
# - (10.36pm) Activity :P
# - (10.46pm) RedrawActivity and RedrawChanInfo cleanups for show_activity, show_ircinfo
# - (11.09pm) Optimized RedrawActivity on Unseen Messages (only happens once now)
# - (12.27am) Final attempt at fixing ^? bug
#
# 28th of April, 2000
# -  (3.22am) Fixed border breakage in RedrawChanInfo upon new window creation
# -  (7.31pm) Various extra $usr / $window hacks
# -  ( ---- ) RedrawNicks stuff for ICQ
# - (12.52am) Hacked FindUser to do UIN on nick completion :P
# - (12.54am) Hacked RedrawNicks to handle ` in nicks a bit better
# -  (1.00am) Do not include Offline people in ICQ in nick completion
# -  (1.04am) Add a space after UINs for ICQ people in nick completion
# -  (1.58am) Fixed some things regarding to RedrawNicks & lack of ICQ connections
#
# 12th of April, 2000
# -  (1.55am) Fix for RedrawChanInfo to clear status line after protocol change
# -  (8.00pm) Fixes to RealLength and Strrrp for ^O and ^?
# -  (8.01pm) LordWrite fixes as above
#
# 9th of April, 2000
# -  (3.44pm) Fixed DelUser bug(?)
# -  (4.54pm) Made DelUser sloppier, should work a lot better now, damn references
#
# 8th of April, 2000
# -  (3.00pm) Cleaning up of newWindowInit
# -  (3.02pm) Modified DrawLeft for new $pizza and $window{pizza} stuffz
# -  (3.14pm) Added NoMorePizzas, NoMoreGames and NoMoreBans subs
# -  (3.57pm) NoMoreUsers added
# -  (4.01pm) User deletes and all that stuff now happen correctly (?)
# -  (4.07pm) Fixed Retitle vs ReTitle stuffz
# -  (5.12pm) Added NoMoreMe to get rid of some 'User mode set more than once' errors
# - (12.22am) ReTitle updates for DrawLeft
# - (12.23am) Disabled ClearChatWindow changes
# -  (1.09am) Added NewMy() subby
#
# 6th of April, 2000
# -  (6.13pm) /WINDOW KILL doesn't cause an uninit'd value warning anymore
# -  (6.43pm) Added newwindow
# -  (7.23pm) Fixed logging= bug
# -  (7.24pm) Fixed invisible= bug
# -  (7.26pm) Optimised newWindowInit
# -  (7.53pm) Two minutes to break, 30 minutes to fix newWindowInit optimisations
# -  (8.35pm) Fixed ^O and ^? display bugs (thanks KaMii)
# -  (9.43pm) RedrawChanInfo only if $thiswin protocol is IRC
# -  (9.46pm) Fixed bizarre date behaviour
# -  (9.54pm) Incorporated query stuff into ChanInfo bar
# - (10.17pm) Fixed cdstoponexit= and paging= bugs
# - (10.44pm) Tried to track down Not an ARRAY reference segfault
# - (11.11pm) Tried to erradicate some ^O and ^? problems
# - (11.12pm) Fixed line draw error with RedrawChanInfo
#
# 5th of April, 2000
# -  (2.22pm) SortUsers NOW SORTS ALPHABETICALLY AT LAST!!!!!!!!!! (4 hours of work!)
# -  (2.49pm) SortUsers 'theoretically' sorts by mode
# -  (3.06pm) Added noupdate flag to $window[$thiswin] for AddUser mainly
# - (11.46pm) Added RedrawChanInfo command
# - (12.07am) Better RedrawChanInfo layout
# -  (1.03am) Fixed DelUser ?
#
# 4th of April, 2000
# - (10.00pm) More array clean-ups in newWinInit
# - (10.42pm) Started work on new SortUsers (again)
# - (11.50pm) Fixed some bugs relating to things not normally occurable
# -  (1.42am) F--- it, 2 hours is long enough, giving up on SortUsers, f---en Perl needs to learn how to sort
#
# 28th of March, 2000
# -  (1.50am) Added whichwin parameter (1st) to AddLine
# -  (3.11am) Added whichwin parameter to ClearChatLine
# -  (3.15am) Added whichwin parameter to ClearAliasWindow
# -  (3.20am) Some ClearAliasWindow optimising
# -  (3.29am) Tackled uninit'd value thing in ClearAliasWindow
# -  (3.40am) RedrawLines no longer causes Uninit'd value
# -  (3.42am) Patched some code to do with Refreshes
# -  (3.51am) Fixed ClearAliasWindow again
# -  (4.07am) ReTitle fixes (remove that >)
# -  (4.30am) Fixed LordWrite to write trailing `'s properly
# -  (5.19am) Made perhaps unnecessary uninit'd handler for DoubleQuote
# -  (4.27pm) AddLine now RedrawLines at the right time (otherwise causes stray text)
# -  (4.33pm) Made some changes to AddLine wrapping to properly add some lines
#
# 25th of March, 2000
# -  (1.07pm) Reordered FindUser a little to fix a bug
#
# 24th of March, 2000
# -  (3.16pm) LordWrite now understands Bold, Underline and inVerse
# -  (3.19pm) Cleaned up LordWrite and ClWriteln (why don't I just call LordWrite from ClWriteln???)
# -  ( ---- ) Replaced ClWriteln calls with LordWrite :)
# -  (3.54pm) Finished heavily optimizing LordWrite
# -  ( ---- ) Optimized reallength to be compatible
# -  (4.22pm) Finished optimizing Strrrp in the same way as LordWrite
# -  (4.24pm) Small fix for Strrrp to strip bold, underline, inverse codes
# -  ( ---- ) Removed ClWriteln sub altogether
# -  (5.30pm) Fixed leaking colours bug
# -  (6.30pm) Fixed underline display bug, ** THERE ARE STILL BUGS PRESENT **
# -  (6.52pm) RedrawNicks optimised a little and now truncates nicks
# -  (7.51pm) Fixed typo in UpdateGame
# -  (8.40pm) Fixed another leaking colour bug
# -  (9.06pm) After almost 8 hours of programming and numerous rewritten routines I have
#             concluded that the bug is in BitchX which I was trying to copy :)
# - (11.33pm) DelUser with only window argument kills everybody
#
# 23rd of March, 2000
# -  (5.12pm) Hacked A_BOLD setting for colours to get it right, I hope.
# -  (5.17pm) Removed the code i just added, did nothing :)
# -  (5.55pm) Tried to fix RedrawLines updating stuffz
# -  (5.58pm) Applied fix to RedrawLines instead of RedrawNicks :P
# -  (7.43pm) Topics are now truncated to fit 1 space away from time
# - (11.42pm) ClearChatWindow destructive now works again
#
# 22nd of March, 2000
# -  (1.45am) RenUser hacked to only change name
# -  (1.11pm) ClWriteln no longer refresh(s) every line
# -  (2.52pm) Made ClWriteln check that lines 'exist' to avoid errors whilst debugging
# -  (4.40pm) DoubleQuote changed nicely :)
# -  (4.42pm) Added ^V inverse stuff for IRC
# -  (4.49pm) Rewrote Strrrp based on reallength
# -  (4.54pm) Implemented chsline (stripped chline), hell, uses a lot more ram, but
#             should make things a little faster.
#
# 21st of March, 2000
# -  (1.10pm) Fixed WrapLine (didn't do anything before becuase ac_wi undefined)
# -  (1.15pm) Fixed WrapLine more :)
# -  (1.25pm) Fixed WrapLine ?
# -  (1.30pm) Maybe the bug is in AddLine :)
# -  (3.19pm) Fixed alias character echo and later border removal bugs
# -  (3.26pm) Fixed voice sorting to be all together
# -  ( ---- ) Changed things
# -  (4.20pm) Delete now checks to make sure user exists before deleting and crashing
# -  (4.22pm) Removed stupid sort on delete code
# -  (8.10pm) Fixed ^_ weirdness
# -  (8.20pm) Started work on IRC colours
# -  (8.31pm) Phase 1 changes complete
# -  (8.32pm) Fixed typo in ClWriteln
# -  (8.35pm) Patched reallength for better detection of IRC colours
# -  (8.38pm) Attempting removable of deadly loop
# -  (8.50pm) Removable of several more IRC colour bugs
# -  (8.59pm) Hacked reallength to not bugger up things
# -  (9.08pm) Added irccol routine to convert ^C IRC colours -> textcolors
# -  (9.15pm) More spacing fixes with IRC colours
# -  (9.24pm) More fixes to do with IRC colours, see LordWrite, ClWriteln, reallength
# -  (9.42pm) Patched reallength with something I left out
# -  (9.47pm) Another fix for reallength :)
# - (10.21pm) Fixed reallength :)
#
# 20th of March, 2000
# - (11.01pm) Still trying to fix AddUser + SortUsers
# - ( ----- ) Gave up on AddUser + SortUsers again
# - ( ----- ) Added more window properties: control, channel
# - ( ----- ) Added new window property: nick
# -  (2.49am) Really fixed reallength incorrectly evaluating line length of ` lines :)
# -  ( ---- ) Patched ClWriteln to handle ^B (chr(2)) properly(?)
# -  ( ---- ) Patched ClWriteln to ignore characters below 29 as reallength does
#
# 5th of March, 2000
# - (11.01pm) Fixed reallength incorrectly evaluating line length of lines with ` in it
#
# 17th of February, 2000
# -  (1.56pm) Trying to fix lang problems
# -  (2.12pm) Uninitialised variable problems fixed, new sub newWindowInit (kinda dodgy)
# -  (2.15pm) Continued porting ReadConfig
# -  (4.51pm) Finished porting ReadConfig
# -  (4.51pm) Porting complete(?)
# -  (4.55pm) Fixed bug which I must have made during porting ReadConfig
# -  (4.59pm) Fixed another bug to do with DOS text files
# -  (5.05pm) Fixed ReadConfig logging warning about undefined nonsense
# -  ( ---- ) Argh!  Case-sensitive subs!  Renamed RealLength to reallength
# -  (5.22pm) Fixed(?) substr out of string bug
# -  (5.23pm) Fixed typo ac_text vs ac_texta in reallength
# -  (5.25pm) reallength now returns 0 instead of "" -- bug
# -  (9.06pm) ARGH!  Bloody variable reuse!!  Bloody Perl!!
# -  (9.15pm) Making progress on getting the text to go were it's supposed to (finally!)
# -  (9.22pm) Text now goes where it supposed to, erases last text correctly, and does not mess up the nick list!
# - (11.48pm) Fixed white bug
# - (12.16am) Did something silly :)  Implemented status colours for PROTOCOL_ICQ userlists (very unnecessary now)
# - (12.36am) Annihilated $ousers :)
# - (12.45am) Fixed AddUser
# - (12.51am) Rewrote DelUser
# -  (1.04am) Modified AddUser to one param again
# -  (1.23am) Added $whichwin parameter to AddUser, RenUser, NameOf and DelUser
# -  (1.44am) First implementation of SortUsers is done (for IRC, sort by mode)
# -  (1.45am) Began implementation of alphabetical (?) sorting in AddUser
#
# 13th of February, 2000
# - (12.47pm) Started porting Strrrp
# - (12.51pm) Finished porting Strrrp
# - (12.51pm) Started porting RealLength
# - (12.52pm) Finished porting RealLength
# - (12.53pm) Started porting WrapLine
# - (12.58pm) Finished porting WrapLine
# - (12.58pm) Started porting DoubleQuote
# -  (1.01pm) Finished porting DoubleQuote
# -  (1.03pm) Began finishing porting DrawMainScreen
# -  (1.06pm) Finished porting DrawMainScreen
# -  (1.06pm) Started porting AddLine
# -  (1.19pm) Finished porting AddLine
# -  (1.21pm) Started porting AddLog
# -  (1.22pm) Finished porting AddLog
# -  (1.23pm) Started porting AddUser
# -  ( ---- ) Fixed bug (from original AndyChat) to do with the online users count
# -  ( ---- ) Finished porting AddUser
# -  ( ---- ) Started porting RenUser
# -  (2.07pm) Finished porting RenUser
# -  (2.09pm) Implemented 'sortusers' into AddUser/RenUser for future expansion
# -  (2.10pm) Started porting FindUser
# -  (2.19pm) Finished porting FindUser
# -  (2.20pm) Started porting NameOf
# -  (2.22pm) Finished porting NameOf
# -  (2.23pm) Started porting DelUser
# -  ( ---- ) Fixed bug (from original AndyChat) to do with refreshing user view when unnecessary
# -  ( ---- ) Fixed bug (from original AndyChat) to do with the online users count
# -  (2.32pm) Finished porting DelUser
# -  (2.34pm) Started porting UpdateGame
# -  (2.47pm) Finished porting UpdateGame
# -  (2.49pm) Started porting strpNoSpace
# -  (2.51pm) Finished porting strpNoSpace
# -  (2.52pm) Started porting ReadConfig
# -  (3.05pm) Having break from porting ReadConfig
# -  (3.45pm) Began changing $usr structures - grrr, why can't Perl work how I want it to
# -  (4.09pm) Failed to fix bug which made AndyChat hang upon beeps in messies as well as ReadConfig
# -  (4.12pm) Fixed reused var (argh!  How many times will this happen!) which was the -real- cause of the last bug
#             even though the last bug probably did exist too :)
# -  ( ---- ) Fixed config reading
# -  ( ---- ) Fixed bugfix about the length of bits
#
# 12th of February, 2000
# -  (4.20pm) Implemented Lang instead of some hard coded stuffz
# -  (4.30pm) Began porting ClearChatWindow(destruct)
# -  (6.52pm) Ported all subs before ClearChatWindow and ClearChatWindow
# -  (6.53pm) Started porting ClearAliasWindow
# -  (6.54pm) Finished porting ClearAliasWindow
# -  (6.55pm) Started porting DrawLeft
# -  (7.07pm) Finished porting DrawLeft
#
# 9th of February, 2000
# - (11.xxpm) Initial Development
# - (12.00am) Moved DrawMainScreen into a_common.pl
# - (12.1xam) Wrote textcolor routine in curses2andy for easy(ier) colour changing
# - (12.38am) Started LordWrite
# - (xxxxxam) Finished LordWrite, LordWrite works (wow)
#
#use Curses;

#do 'andy-ext.pl';
#do 'curses2andy.pl';

$mainwin = initscr();
getmaxyx($mainwin, $maxy, $maxx);

start_color();

sub colline {
  my ($z1) = @_;

  my $z2 = "1234567890!\@#\$\%";

  return substr($z2, $z1 - 1, 1);
}

sub irccol {
  my ($z1) = @_;

  $z1 = "0$z1";
  $z1 = " " . substr($z1, -2);
  my $z2 = " 01 02 03 10 04 06 05 15 14 12 09 11 07 13 08 16";

  return index($z2, $z1) / 3;
}

sub LordWrite {
  my ($z2, $z1) = @_;

  if (! $z1)
  {
    $z1 = $z2;
    $z2 = $mainwin;
  }

#  for ($z = 0; $z < length($z1); $z++)
#  {
  my $z = 0; while ($z < length($z1))
  {
    my $lw = index(substr($z1, $z), chr(2));
    my $lw3 = index(substr($z1, $z), chr(3));
    if (($lw3 < $lw || $lw eq -1) && $lw3 > -1) { $lw = $lw3; }
    my $lw15 = index(substr($z1, $z), chr(15));
    if (($lw15 < $lw || $lw eq -1) && $lw15 > -1) { $lw = $lw15; }
    my $lw21 = index(substr($z1, $z), chr(21));
    if (($lw21 < $lw || $lw eq -1) && $lw21 > -1) { $lw = $lw21; }
    my $lw22 = index(substr($z1, $z), chr(22));
    if (($lw22 < $lw || $lw eq -1) && $lw22 > -1) { $lw = $lw22; }
    my $lw30 = index(substr($z1, $z), "`");
    if (($lw30 < $lw || $lw eq -1) && $lw30 > -1) { $lw = $lw30; }
    my $lw31 = index(substr($z1, $z), chr(31));
    if (($lw31 < $lw || $lw eq -1) && $lw31 > -1) { $lw = $lw31; }
    my $lw127 = index(substr($z1, $z), chr(127));
    if (($lw127 < $lw || $lw eq -1) && $lw127 > -1) { $lw = $lw127; }
    if ($lw < 0)
    {
      addstr($z2, substr($z1, $z));
      if ($cbold)
      {
        attroff($z2, A_BOLD);
        $cbold = "";
      }
      if ($cinverse)
      {
        attroff($z2, A_REVERSE);
        $cinverse = "";
      }
      if ($culine)
      {
        attroff($z2, A_UNDERLINE);
        $culine = "";
      }
      return;
    }
    else
    {
      if ($lw > 0)
      {
        addstr($z2, substr($z1, $z, $lw));
        $z = $lw + $z;
      }
    }
    if (substr($z1, $z, 1) eq chr(2))
    {
      if ($cbold)
      {
        attroff($z2, A_BOLD);
        $cbold = "";
      }
      else
      {
        attron($z2, A_BOLD);
        $cbold = 1;
      }
    }
    elsif (substr($z1, $z, 1) eq chr(3))
    {
     if ($z + 1 < length($z1))
     {
      $z++;
      if ((index($colline, substr($z1, $z, 1)) > -1 && index($colline, substr($z1, $z, 1)) < 9) || substr($z1, $z, 1) eq "0")
      {
        if ($z + 1 < length($z1))
        {
          $z++;
          if ((index($colline, substr($z1, $z, 1)) > -1 && index($colline, substr($z1, $z, 1)) < 9) || substr($z1, $z, 1) eq "0")
          {
            $beforectrlc = getattrs($z2);
            textcolor($z2, irccol(substr($z1, $z - 1, 2)));
#            attron(A_UNDERLINE) if ($culine);
#            attron(A_REVERSE) if ($cinverse);
#            attron(A_BOLD) if ($cbold);
          }
          else
          {
            $z--;
            $beforectrlc = getattrs($z2);
            textcolor($z2, irccol(substr($z1, $z, 1)));
#            attron(A_UNDERLINE) if ($culine);
#            attron(A_REVERSE) if ($cinverse);
#            attron(A_BOLD) if ($cbold);
          }
        }
        else
        {
          $beforectrlc = getattrs($z2);
          textcolor($z2, irccol(substr($z1, $z, 1)));
#          attron(A_UNDERLINE) if ($culine);
#          attron(A_REVERSE) if ($cinverse);
#          attron(A_BOLD) if ($cbold);
        }
      }
      else
      {
        if ($beforectrlc)
        {
          attrset($z2, $beforectrlc);
          $beforectrlc = "";
        }
        $z--;
      }
     }
     else
     {
        if ($beforectrlc)
        {
          attrset($z2, $beforectrlc);
          $beforectrlc = "";
        }
     }
    }
    elsif (substr($z1, $z, 1) eq chr(31))
    {
      if ($culine)
      {
        attroff($z2, A_UNDERLINE);
        $culine = "";
      }
      else
      {
        attron($z2, A_UNDERLINE);
        $culine = 1;
      }
    }
    elsif (substr($z1, $z, 1) eq chr(22))
    {
      if ($cinverse)
      {
        attroff($z2, A_REVERSE);
        $cinverse = "";
      }
      else
      {
        attron($z2, A_REVERSE);
        $cinverse = 1;
      }
    }
    elsif (substr($z1, $z, 1) eq "`")
    {
      $z++;
      if ($z >= length($z1))
      {
        addstr($z2, "`");
      }
      else
      {
        if (index($colline, substr($z1, $z, 1)) > -1)
        {
          textcolor($z2, index($colline, substr($z1, $z, 1)) + 1);
#          attron(A_UNDERLINE) if ($culine);
#          attron(A_REVERSE) if ($cinverse);
#          attron(A_BOLD) if ($cbold);
        }
        elsif (substr($z1, $z, 1) eq "`")
        {
          addstr($z2, "`");
        }
        else
        {
          addstr($z2, "`" . substr($z1, $z, 1));
        }
      }
    }
    else
    {
#      addstr(substr($z1, $z, 1));
#      addstr("Error!");	# Hack!
    }
    $z++;
  }
  if ($cbold)
  {
    attroff($z2, A_BOLD);
    $cbold = "";
  }
  if ($cinverse)
  {
    attroff($z2, A_REVERSE);
    $cinverse = "";
  }
  if ($culine)
  {
    attroff($z2, A_UNDERLINE);
    $culine = "";
  }
}

sub RedrawNicks {
  if ($leftwindow ne 1) { return; }
  my $tmpx = wherex; my $tmpy = wherey; my $tmpz = getattrs($mainwin);
  textcolor(15);
  my $ac_i = 0; my $ac_j = 0;

  while (($ac_i < $maxy - 5) && ($ac_j < $window[$thiswin]->{users}))
  {
    $ac_j++;
    if (! $usr[$thiswin][$ac_j]{invis} && $usr[$thiswin][$ac_j]{name} && (($window[$thiswin]{protocol} eq 3 && $usr[$thiswin][$ac_j]{status} ne 65535) || $window[$thiswin]{protocol} ne 3))
    {
      $ac_i++;
      gotoxy($maxx - 15, $ac_i + 1);
      if ($usr[$thiswin]->[$ac_j]->{op})
      {
        LordWrite("`\$\@"); textcolor(15);
      }
      elsif ($usr[$thiswin]->[$ac_j]->{voice})
      {
        LordWrite("`\9+"); textcolor(15);
      }
      elsif ($window[$thiswin]->{protocol} eq 3)
      {
        $acrns = $usr[$thiswin][$ac_j]{status};

#        if ($acrns eq ICQ_STATUS_INVISIBLE)
#        {
#          textcolor(8);
#        }
        if ($acrns eq 0)
        {
          textcolor(9);
        }
        elsif ($acrns eq 1)
        {
          textcolor(10);
        }
        elsif ($acrns eq 4)
        {
          textcolor(10);
        }
        elsif ($acrns eq 16)
        {
          textcolor(10);
        }
        elsif ($acrns eq 2)
        {
          textcolor(10);
        }
        elsif ($acrns eq 32)
        {
          textcolor(9);
        }

        if ($acrns eq 0)
        {
          LordWrite("o");
        }
        elsif ($acrns eq 1)
        {
          LordWrite("a");
        }
        elsif ($acrns eq 4)
        {
          LordWrite("n");
        }
        elsif ($acrns eq 16)
        {
          LordWrite("!");
        }
        elsif ($acrns eq 2)
        {
          LordWrite("d");
        }
        elsif ($acrns eq 32)
        {
          LordWrite("f");
        }
        textcolor(15);
      }
      else
      {
        addstr(" "); textcolor(15);
      }
      if (reallength(DoubleQuote($usr[$thiswin][$ac_j]{name})) > 12)
      {
        LordWrite(substr(DoubleQuote($usr[$thiswin][$ac_j]{name}), 0, 12));
        textcolor(12); addstr(">");
      }
      else
      {
        LordWrite(DoubleQuote($usr[$thiswin]->[$ac_j]->{name}));
        addstr(strpadd("", 13 - reallength(DoubleQuote($usr[$thiswin][$ac_j]{name})), " "));
      }
    }
  }
  if ($lusers > $ac_i)
  {
    for ($ac_j = 1; $ac_j <= $lusers - $ac_i; $ac_j++)
    {
      addstr($ac_i + $ac_j + 1, $maxx - 15, SPACEs(14));
    }
  }
  gotoxy($tmpx, $tmpy); attrset($mainwin, $tmpz);
  refresh();
  $lusers = $ac_i;
}

sub RedrawLines {
  my ($acrlj) = @_;
  if ($leftwindow ne 1) { return; }
#  my $tmpx = wherex; my $tmpy = wherey; my $tmpz = getattrs($mainwin);
#  textcolor(7);
  my $acrli;

#  clear($channelwin);
  gotoxy($channelwin, 0, 0);

  for ($acrli = $maxy - 5; $acrli >= 1; $acrli--)
  {
#    gotoxy(1, $maxy - 3 - $acrli);
#    if ($chsline[$thiswin]->[$acrli - 1] && $chsline[$thiswin]->[$acrli] && length($chsline[$thiswin]->[$acrli - 1]) < length($chsline[$thiswin]->[$acrli]) && $acrlj)
#    {
#      LordWrite($channelwin, $chline[$thiswin]->[$acrli - 1]);
#      addstr($channelwin, strpadd("", length($chsline[$thiswin]->[$acrli]) - length($chsline[$thiswin]->[$acrli - 1]), " "));
#    }
#    elsif ($chsline[$thiswin]->[$acrli - 1])
#    {
      if ($acrli < $maxy - 5)
      {
        addstr($channelwin, "\n");
      }
      if ($chline[$thiswin][$acrli - 1])
      {
        LordWrite($channelwin, $chline[$thiswin]->[$acrli - 1]);
      }
#    }
  }
#  while ($chline[$thiswin][0] && index($chline[$thiswin]->[0], chr(7)) > -1)
#  {
#    $chline[$thiswin]->[0] = substr($chline[$thiswin]->[0], 0, index($chline[$thiswin]->[0], chr(7))) . substr($chline[$thiswin]->[0], index($chline[$thiswin]->[0], chr(7)) - 1);
#  }
#  gotoxy($tmpx, $tmpy); attrset($mainwin, $tmpz);
  refresh($channelwin);
}

sub ReLabel {
  my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
  gotoxy($maxx - 15, $maxy - 2);
  addstr(strpadd("", 14 - length($progname), " "));
  LordWrite($progname);
  gotoxy($rla, $rlb); attrset($mainwin, $rlc);
}

sub ReTitle {
  my ($z1, $z2) = @_;

  if ($leftwindow eq 1 || $z2)
  {
    my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
    gotoxy(1, 1); textcolor(8);
    if (length($z1) > $maxx - 24)
    {
      addstr(substr($z1, 0, $maxx - 24));
      textcolor(9); addstr(">");
    }
    else
    {
      addstr($z1);
      textcolor($colour{'border'}); hline(Lang(6), $maxx - 23 - length($z1));
    }
    gotoxy($rla, $rlb); attrset($mainwin, $rlc);
  }
}

sub RedrawActivity {
  my ($acraz) = @_;

  if (! $config{show_activity}) { return; }

  my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
  gotoxy(1, $maxy - 1);
  if ($acraz)
  {
    textcolor($colour{border});
    hline(Lang(6), $windowcount + 1);
  }
  else
  {
    my $acr_i; for ($acr_i = 1; $acr_i <= $windowcount; $acr_i++)
    {
      if (! $window[$acr_i]{protocol})
      {
        addstr(" ");
      }
      elsif ($acr_i eq $thiswin)
      {
        if ($window[$thiswin]{unseen}) { $window[$thiswin]{unseen} = ""; }
        textcolor(15);
        addstr(substr($acr_i, -1, 1));
      }
      elsif ($window[$acr_i]{unseen})
      {
        textcolor($window[$acr_i]{protocol} + 8);
        addstr(substr($acr_i, -1, 1));
      }
      else
      {
        textcolor($window[$acr_i]{protocol});
        addstr(substr($acr_i, -1, 1));
      }
    }
    textcolor($colour{border});
    addch(Lang(6));
  }
  gotoxy($rla, $rlb); attrset($mainwin, $rlc); refresh;
}

sub RedrawChanInfo {
  if (! $window[$thiswin]{protocol} || $window[$thiswin]{protocol} ne 2)
  {
    my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
    gotoxy(1, $maxy - 3); textcolor($colour{'border'}); hline(Lang(6), $maxx - 17);
    gotoxy($rla, $rlb); attrset($mainwin, $rlc);
  }
  elsif ($window[$thiswin]{protocol} && $window[$thiswin]{protocol} eq 2 && $config{show_ircinfo})
  {
    my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
    gotoxy(1, $maxy - 3);
    LordWrite("`1[");
    if ($my[$thiswin]{op})
    {
      LordWrite("`#@");
    }
    elsif ($my[$thiswin]{voice})
    {
      LordWrite("`#+");
    }
    LordWrite("`9$my[$thiswin]{name}");
    if ($my[$thiswin]{modes})
    {
      LordWrite("`1(+`9$my[$thiswin]{modes}`1)");
    }
    LordWrite("`1]");
    addch(Lang(6));
    LordWrite("[");
    if ($window[$thiswin]{channel})
    {
      LordWrite("`9$window[$thiswin]{channel}");
      if ($window[$thiswin]{modes})
      {
        LordWrite("`1(+`9$window[$thiswin]{modes}");
        if ($window[$thiswin]{limit})
        {
          LordWrite(" $window[$thiswin]{limit}");
        }
        if ($window[$thiswin]{key})
        {
          LordWrite(" $window[$thiswin]{key}");
        }
        LordWrite("`1)");
      }
    }
    LordWrite("`1]");
    if ($window[$thiswin]{query})
    {
      addch(Lang(6));
      LordWrite("[Query: `9" . DoubleQuote($window[$thiswin]{query}) . "`1]");
    }
#   textcolor(9); addstr(">");
    textcolor($colour{'border'}); hline(Lang(6), $maxx - 16 - wherex());
    gotoxy($rla, $rlb); attrset($mainwin, $rlc);
  }
#  elsif ($window[$thiswin]{protocol})
#  {
#    my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);
#    gotoxy(1, $maxy - 3); textcolor($colour{'border'}); hline(Lang(6), $maxx - 17);
#    gotoxy($rla, $rlb); attrset($mainwin, $rlc);
#  }
}

sub DrawMainScreen {
  my ($mode) = @_;

  if (! $mode) { $mode = 0; }

  if (($mode eq 1) || ($mode eq 0))
  {
    textcolor($colour{'border'});
    addch(1, 0, Lang(5));
    hline(Lang(6), $maxx - 22);
    textcolor($colour{'time'});
#    addstr(1, $maxx - 21, "00:00");
    addstr(1, $maxx - 21, substr(qbTIME, 0, 5));
    textcolor($colour{'border'});
    addch(1, $maxx - 16, Lang(7));
    hline(Lang(6), 3);
    textcolor($colour{date});
#    addstr(1, $maxx - 12, "12/12/12");
    addstr(1, $maxx - 12, substr(qbDATE, 0, 2) . "/" . substr(qbDATE, 3, 2) . "/" . substr(qbDATE, -2, 2));
    textcolor($colour{border});
    gotoxy($maxx - 4, 1);
    hline(Lang(6), 3);
    addch(1, $maxx - 1, Lang(8));

    gotoxy(0, 2);
    vline(Lang(9), $maxy - 5);
    gotoxy($maxx - 16, 2);
    vline(Lang(9), $maxy - 5);
    gotoxy($maxx - 1, 2);
    vline(Lang(9), $maxy - 5);

#    gotoxy(0, $maxy - 3);
    addch($maxy - 3, 0, Lang(10));
    hline(Lang(6), $maxx - 17);
    addch($maxy - 3, $maxx - 16, Lang(11));
    hline(Lang(6), 14);
    addch($maxy - 3, $maxx - 1, Lang(12));

    gotoxy(0, $maxy - 2);
    vline(Lang(9), 1);
    gotoxy($maxx - 16, $maxy - 2);
    vline(Lang(9), 1);
    gotoxy($maxx - 1, $maxy - 2);
    vline(Lang(9), 1);

    addch($maxy - 1, 0, Lang(13));
    hline(Lang(6), $maxx - 17);
    addch($maxy - 1, $maxx - 16, Lang(14));
    hline(Lang(6), 14);
    addch($maxy - 1, $maxx - 1, Lang(15));

    textcolor(8);
    addstr($maxy - 1, $maxx - 15, "M:00");
    addstr($maxy - 1, $maxx - 5, "P:00");

#    gotoxy(3, $maxy - 2); LordWrite("`2A`0ndy`2C`0hat`9!");

    textcolor($colour{game});

    addstr(5, $maxx - 16, "0");
    addstr(9, $maxx - 16, "0");
    addstr(13, $maxx - 16, "0");
    addstr(17, $maxx - 16, "0");

    ReLabel;

    refresh();
  }
  if (($mode eq 2) || ($mode eq 0))
  {
    RedrawNicks;
    RedrawActivity;
  }
  if (($mode eq 3) || ($mode eq 0))
  {
    my $ac_i;
    for ($ac_i = $maxy - 5; $ac_i > 0; $ac_i--)
    {
      gotoxy(1, $maxy - 3 - $ac_i);
      LordWrite(strpadd($chline[$thiswin]->[$ac_i], $maxx - 18, " "));
    }
  }
}

sub ClearChatWindow {
  my ($whichwin, $ac_destruct) = @_;

##  if ($leftwindow ne 1) { return; }

#  my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);

#  my $ac_i;

  for ($ac_i = 1; $ac_i <= $maxy - 5; $ac_i++)
  {
#    gotoxy(1, $maxy - 3 - $ac_i);
#    if ($leftwindow eq 1)
#    {
#      if ($chsline[$whichwin][$ac_i - 1])
#      {
#        addstr(SPACEs(length($chsline[$whichwin]->[$ac_i - 1])));
#      }
#      else
#      {
#        addstr(SPACEs($maxx - 18));
#      }
#    }
#    else
#    {
#      addstr(SPACEs($maxx - 18));
#    }
    gotoxy($channelwin, 0, $ac_i - 1); clrtoeol($channelwin);
  }
  if ($ac_destruct)
  {
    undef @{$chline[$whichwin]};
    undef @{$chsline[$whichwin]};
  }
#  gotoxy($rla, $rlb); attrset($mainwin, $rlc);

#  clear($channelwin);
#  gotoxy($channelwin, 0, $maxy - 6);
  refresh($channelwin);
}

sub ClearAliasWindow {
  my ($whichwin) = @_;

  my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);

  my $ac_i;
  if ($leftwindow eq 1)
  {
    for ($ac_i = 1; $ac_i <= $maxy - 5 && $ac_i <= $window[$whichwin]{users}; $ac_i++)
    {
      addstr($maxy - 3 - $ac_i, $maxx - 15, SPACEs(14));
    }
  }
  else
  {
    for ($ac_i = 1; $ac_i <= $maxy - 5; $ac_i++)
    {
      addstr($maxy - 3 - $ac_i, $maxx - 15, SPACEs(14));
    }
  }
  gotoxy($rla, $rlb); attrset($mainwin, $rlc);
  refresh();
}

sub DrawLeft {
  my $rla = wherex; my $rlb = wherey; my $rlc = getattrs($mainwin);

  if ($leftwindow eq 2)
  {
    ReTitle("Pizza View Mode [ PgUp/PgDn to change ]", 1);
    if ($window[$thiswin]{pizzas})
    {
      my $ac_i;
      for ($ac_i = 1; $ac_i <= $window[$thiswin]{pizzas}; $ac_i++)
      {
        gotoxy(2, $ac_i + 1);
        textcolor(15);
        if ($ac_i < 10) { addstr(" "); }
        addstr($ac_i . "] " . $pizza[$thiswin][$ac_i]{topping});
        gotoxy($maxx - 14, $ac_i + 1);
        textcolor(14);
        addstr("\$ " . pricepadc($pizza[$thiswin][$ac_i]{price}));
      }
    }
    else
    {
      textcolor(12); addstr(2, 2, Lang(106));
    }
    $leftwindow = 2;
  }
  elsif ($leftwindow eq 3)
  {
    ReTitle("Private Messages [ PgUp/PgDn to change ]", 1);
    $leftwindow = 3;
    $addbuffer = "";
    my @chlinb = @chline;
    my $ac_i;
    for ($ac_i = 1; $ac_i <= $maxy - 4; $ac_i++)
    {
# NEEDS TO BE CHANGED TO NEW FORMAT!!!!! # Hack!
#      AddLine($thiswin, "`!" . $pagess[$ac_i] . "`7");
    }
    $addbuffer = 1;
    $leftwindow = 1;
    RedrawLines;
    @chline = @chlinb;
    $leftwindow = 3;
  }
  else
  {
    $leftwindow = 2;
    if ($window[$thiswin]{channel})
    {
      if ($window[$thiswin]{topic})
      {
        ReTitle("[" . $window[$thiswin]{channel} . "] " . $window[$thiswin]{topic}, 1);
      }
      else
      {
        ReTitle("[" . $window[$thiswin]{channel} . "]", 1);
      }
    }
    else
    {
      ReTitle("[New Window]", 1);
    }
    $leftwindow = 1;
    RedrawLines;
    RedrawNicks;
  }
  gotoxy($rla, $rlb); attrset($mainwin, $rlc);
  refresh();
}

sub Strrrp {
  my ($ac_text) = @_;

  my $ac_outt = "";

  if ($ac_text)
  {
    my $ac_ri = 0; while ($ac_ri < length($ac_text))
    {
      my $lw = index(substr($ac_text, $ac_ri), chr(2));
      my $lw3 = index(substr($ac_text, $ac_ri), chr(3));
      if (($lw3 < $lw || $lw eq -1) && $lw3 > -1) { $lw = $lw3; }
      my $lw15 = index(substr($ac_text, $ac_ri), chr(15));
      if (($lw15 < $lw || $lw eq -1) && $lw15 > -1) { $lw = $lw15; }
      my $lw21 = index(substr($ac_text, $ac_ri), chr(21));
      if (($lw21 < $lw || $lw eq -1) && $lw21 > -1) { $lw = $lw21; }
      my $lw22 = index(substr($ac_text, $ac_ri), chr(22));
      if (($lw22 < $lw || $lw eq -1) && $lw22 > -1) { $lw = $lw22; }
      my $lw30 = index(substr($ac_text, $ac_ri), "`");
      if (($lw30 < $lw || $lw eq -1) && $lw30 > -1) { $lw = $lw30; }
      my $lw31 = index(substr($ac_text, $ac_ri), chr(31));
      if (($lw31 < $lw || $lw eq -1) && $lw31 > -1) { $lw = $lw31; }
      my $lw127 = index(substr($ac_text, $ac_ri), chr(127));
      if (($lw127 < $lw || $lw eq -1) && $lw127 > -1) { $lw = $lw127; }
      if ($lw < 0)
      {
        $ac_outt = $ac_outt . substr($ac_text, $ac_ri);
        return $ac_outt;
      }
      else
      {
        if ($lw > 0)
        {
          $ac_outt = $ac_outt . substr($ac_text, $ac_ri, $lw);
          $ac_ri = $lw + $ac_ri;
        }
      }
#    for ($ac_ri = 0; $ac_ri < length($ac_text); $ac_ri++)
#    {
      if (substr($ac_text, $ac_ri, 1) eq chr(2) || substr($ac_text, $ac_ri, 1) eq chr(31) || substr($ac_text, $ac_ri, 1) eq chr(22) || 
          substr($ac_text, $ac_ri, 1) eq chr(127))
      {
      }
      elsif (substr($ac_text, $ac_ri, 1) eq chr(3))
      {
       if ($ac_ri + 1 < length($ac_text))
       {
        $ac_ri++;
        if ((index($colline, substr($ac_text, $ac_ri, 1)) > -1 && index($colline, substr($ac_text, $ac_ri, 1)) < 9) || substr($ac_text, $ac_ri, 1) eq "0")
        {
          if ($ac_ri + 1 < length($ac_text))
          {
            $ac_ri++;
            if ((index($colline, substr($ac_text, $ac_ri, 1)) > -1 && index($colline, substr($ac_text, $ac_ri, 1)) < 9) || substr($ac_text, $ac_ri, 1) eq "0")
            {
            }
            else
            {
              $ac_ri--;
            }
          }
          else
          {
          }
        }
        else
        {
          $ac_ri--;
        }
       }
       else
       {
       }
      }
      elsif (substr($ac_text, $ac_ri, 1) eq "`")
      {
        if ($ac_ri + 1 < length($ac_text))
        {
          $ac_ri++;
        }
        else
        {
          $ac_outt = $ac_outt . "`";
        }
        if (substr($ac_text, $ac_ri, 1) eq "`")
        {
          $ac_outt = $ac_outt . substr($ac_text, $ac_ri, 1);
        }
        elsif (index($colline, substr($ac_text, $ac_ri, 1)) < 0)
        {
          $ac_outt = $ac_outt . substr($ac_text, $ac_ri - 1, 2);
        }
      }
      elsif (ord(substr($ac_text, $ac_ri, 1)) > 31)
      {
        $ac_outt = $ac_outt . substr($ac_text, $ac_ri, 1);
      }
      $ac_ri++;
    }
  }
  return $ac_outt;
}

#sub Strrrp {
#  my ($ac_texta) = @_;
#
#  $ac_outt = "";
#  for ($ac_i = 0; $ac_i < length($ac_texta); $ac_i++)
#  {
#    if (substr($ac_texta, $ac_i, 1) eq "`")
#    {
#      if ($ac_i + 1 < length($ac_texta)) { $ac_i++; }
#      if (substr($ac_texta, $ac_i, 1) eq "`" || index($colline, substr($ac_texta, $ac_i, 1)) < 0) { $ac_outt = "$ac_outt" . substr($ac_texta, $ac_i, 1); }
#    }
#    elsif (substr($ac_texta, $ac_i, 1) eq "")
#    {  
#      if ($ac_i + 1 < length($ac_texta)) { $ac_i++; }
#      if (substr($ac_texta, $ac_i, 1) eq "") { $ac_outt = "$ac_outt"; }
#    }
#    elsif (ord(substr($ac_texta, $ac_i, 1)) > 31)
#    {
#      $ac_outt = $ac_outt . substr($ac_texta, $ac_i, 1);
#    }
#  }
#  return $ac_outt;
#}

sub reallength {
  my ($ac_text) = @_;

  my $ac_rj = 0;

  if ($ac_text)
  {
    my $ac_ri = 0; while ($ac_ri < length($ac_text))
    {
      $lw = index(substr($ac_text, $ac_ri), chr(2));
      $lw3 = index(substr($ac_text, $ac_ri), chr(3));
      if (($lw3 < $lw || $lw eq -1) && $lw3 > -1) { $lw = $lw3; }
      $lw15 = index(substr($ac_text, $ac_ri), chr(15));
      if (($lw15 < $lw || $lw eq -1) && $lw15 > -1) { $lw = $lw15; }
      $lw21 = index(substr($ac_text, $ac_ri), chr(21));
      if (($lw21 < $lw || $lw eq -1) && $lw21 > -1) { $lw = $lw21; }
      $lw22 = index(substr($ac_text, $ac_ri), chr(22));
      if (($lw22 < $lw || $lw eq -1) && $lw22 > -1) { $lw = $lw22; }
      $lw30 = index(substr($ac_text, $ac_ri), "`");
      if (($lw30 < $lw || $lw eq -1) && $lw30 > -1) { $lw = $lw30; }
      $lw31 = index(substr($ac_text, $ac_ri), chr(31));
      if (($lw31 < $lw || $lw eq -1) && $lw31 > -1) { $lw = $lw31; }
      $lw127 = index(substr($ac_text, $ac_ri), chr(127));
      if (($lw127 < $lw || $lw eq -1) && $lw127 > -1) { $lw = $lw127; }
      if ($lw < 0)
      {
#        addstr(substr($ac_text, $ac_ri));
        $ac_rj = $ac_rj + length($ac_text) - $ac_ri;
        return $ac_rj;
      }
      else
      {
        if ($lw > 0)
        {
          $ac_rj = $ac_rj + $lw;
#          addstr(substr($ac_text, $ac_ri, $lw));
          $ac_ri = $lw + $ac_ri;
        }
      }
#    for ($ac_ri = 0; $ac_ri < length($ac_text); $ac_ri++)
#    {
      if (substr($ac_text, $ac_ri, 1) eq chr(3))
      {
       if ($ac_ri + 1 < length($ac_text))
       {
        $ac_ri++;
        if ((index($colline, substr($ac_text, $ac_ri, 1)) > -1 && index($colline, substr($ac_text, $ac_ri, 1)) < 9) || substr($ac_text, $ac_ri, 1) eq "0")
        {
          if ($ac_ri + 1 < length($ac_text))
          {
            $ac_ri++;
            if ((index($colline, substr($ac_text, $ac_ri, 1)) > -1 && index($colline, substr($ac_text, $ac_ri, 1)) < 9) || substr($ac_text, $ac_ri, 1) eq "0")
            {
#              $ac_rj++;
#              $ac_rj++;
            }
            else
            {
#              $ac_rj++;
              $ac_ri--;
            }
          }
          else
          {
#            $ac_rj++;
          }
        }
        else
        {
#          $ac_rj++;
          $ac_ri--;
        }
       }
       else
       {
#         $ac_rj++;
       }
      }
      elsif (substr($ac_text, $ac_ri, 1) eq "`")
      {
        if ($ac_ri + 1 < length($ac_text)) { $ac_ri++; }
        if (substr($ac_text, $ac_ri, 1) eq "`")
        {
          $ac_rj++;
        }
        elsif (index($colline, substr($ac_text, $ac_ri, 1)) < 0)
        {
          $ac_rj++;
          $ac_rj++;
        }
      }
      elsif (substr($ac_text, $ac_ri, 1) eq "")
      {  
        if ($ac_ri + 1 < length($ac_text)) { $ac_ri++; }
        if (substr($ac_text, $ac_ri, 1) eq "")
        {
          $ac_rj++;
        }
        elsif (index($colline, substr($ac_text, $ac_ri, 1)) < 0)
        {
          $ac_rj++;
          $ac_rj++;
        }
      }
      elsif (ord(substr($ac_text, $ac_ri, 1)) > 31 && ord(substr($ac_text, $ac_ri, 1)) ne 127)
      {
        $ac_rj++;
      }
      $ac_ri++;
    }
  }
  return $ac_rj;
}

sub WrapLine {
  my ($ac_line1) = @_;

  $leftover = "";
  my $ac_wi = length($ac_line1);
  while (($ac_wi > 0) && (substr($ac_line1, $ac_wi - 1, 1) ne " "))
  {
    $leftover = substr($ac_line1, $ac_wi - 1);
    $ac_wi = $ac_wi - 1;
  }
  if ($leftover eq $ac_line1) { $leftover = ""; }
  return substr($ac_line1, 0, length($ac_line1) - length($leftover) - 1);
}

sub DoubleQuote {
  my ($ac_line) = @_;

  if ($ac_line) { $ac_line =~ s/`/``/go; }
#  $tempstr = ""; $ac_di = 0;
#  for ($ac_di = 0; $ac_di < length($ac_line); $ac_di++)
#  {
#    if (substr($ac_line, $ac_di, 1) eq "`")
#    {
#      $tempstr = "$tempstr`";
#    }
#    elsif (substr($ac_line, $ac_di, 1) eq "")
#    {
#      $tempstr = "$tempstr";
#    }
#    $tempstr = $tempstr . substr($ac_line, $ac_di, 1);
#  }
  return $ac_line;
}

sub AddLine {
  my ($whichwin, $ac_line, $ac_saidwrap, $ac_remsend) = @_;

  $leftover = "";
  my $ac_k = 0;
  if ($ac_saidwrap)
  {
    $ac_line = DoubleQuote($ac_line);
  }
  rescroll:
  my $ac_i = 0; my $ac_j = 0;
  if (reallength($ac_line) < $maxx - 18 - reallength($ac_saidwrap))
  {
    $displine = $ac_line;
    $ac_line = "";
    $ac_j = 1;
    $ac_k++;
  }
  else
  {
    my @tmpline;
    $tmpline[1] = ""; $tmpline[2] = "";
    if (index($ac_line, " ") < 0)
    {
      $tmpline[1] = substr($ac_line, 0, $maxx - 19 - reallength($ac_saidwrap));
      $ac_line = substr($ac_line, $maxx - 17 - reallength($ac_saidwrap), length($ac_line) - ($maxx - 19 - reallength($ac_saidwrap)));
    }
    else
    {
      $tmpline[1] = ""; $ac_l = 0;
      $bla1 = length(substr($ac_line, 0, $maxx - 19 - reallength($ac_saidwrap)));
      $bla2 = reallength(substr($ac_line, 0, $maxx - 19 - reallength($ac_saidwrap)));
      $bla3 = $bla1 - $bla2;
      $tmpline[1] = WrapLine(substr($ac_line, 0, $maxx - 19 - reallength($ac_saidwrap) + $bla3));
      $ac_line = $leftover . substr($ac_line, $maxx - 19 - reallength($ac_saidwrap) + $bla3, length($ac_line) - ($maxx - 19 - reallength($ac_saidwrap) + $bla3));
    }
    $displine = $tmpline[1];
    $ac_j = 1;
    $ac_k++;
  }
  if ($ac_saidwrap)
  {
    if ($ac_k eq 1)
    {
      $displine = $ac_saidwrap . $displine;
    }
    else
    {
      $displine = SPACEs(reallength($ac_saidwrap)) . $displine;
    }
  }
  if ($ac_j > 0)
  {
#    for ($ac_i = $maxy - 4; $ac_i > 1; $ac_i--)
#    {
#      $chline[$whichwin]->[$ac_i] = $chline[$whichwin]->[$ac_i - 1];
#      $chsline[$whichwin]->[$ac_i] = $chsline[$whichwin]->[$ac_i - 1];
#    }
#    $chline[$whichwin][1] = $displine;
#    $chsline[$whichwin][1] = Strrrp($displine);

    if (! $chline[$whichwin][0])
    {
      $chline[$whichwin][0] = $displine;
      $chsline[$whichwin][0] = Strrrp($displine);
    }
    else
    {
      unshift(@{$chline[$whichwin]}, $displine);
      unshift(@{$chsline[$whichwin]}, Strrrp($displine));
    }

    if ($remsend)
    {
      # SendIPX("@@" . $config{'room'} . $displine, $ipxsocket);
    }
    if (($logging) && ($addbuffer))
    {
      print logfile $chsline[$whichwin]->[0] . "\n";
    }
  }
  if ($whichwin eq $thiswin)
  {
    addstr($channelwin, "\n");
    LordWrite($channelwin, $displine); refresh($channelwin);

#    RedrawLines(1);
  }
  elsif (! $window[$whichwin]{unseen})
  {
    $window[$whichwin]{unseen} = 1;
    RedrawActivity();
  }
  if ($ac_line ne "")
  {
    goto rescroll;
  }
}

sub AddLog {
  my ($ac_logline) = @_;

  if ($logging)
  {
    print logfile "$ac_logline\n";
  }
}

sub SortUsers {
  my ($whichwin) = @_;

  my $acsui = $window[$whichwin]{users};

  if ($acsui > 1)
  {
    if ($window[$whichwin]->{protocol} eq 2)
    {
#      @{$usr[$whichwin]}[1 .. $acsui] = sort {
#        if ($a->{op} && ! $b->{op}) { return -1; }
#        elsif ($a->{op} && $b->{op}) { return 0; }
#        elsif (! $a->{op} && $b->{op}) { return 1; }
#        elsif ($a->{voice} && ! $b->{voice}) { return -1; }
#        elsif ($a->{voice} && $b->{voice}) { return 0; }
#        elsif (! $a->{voice} && $b->{voice}) { return 1; }
#        else { return 0; }
#      } @{$usr[$whichwin]}[1 .. $acsui];

#      @{$usr[$whichwin]}[1 .. $acsui] = sort {
#        if ($b->{op}) { return 2; }
#        elsif ($b->{voice}) { return 1; }
#        else { return 0; }
#      } @{$usr[$whichwin]}[1 .. $acsui];

#      @{$usr[$whichwin]}[1 .. $acsui] = sort {
#        if ($a->{op} && $b->{op}) { return 0; }
#        elsif ($a->{op}) { return -1; }
#        elsif ($b->{op}) { return 1; }
#        elsif ($a->{voice} && $b->{voice}) { return 0; }
#        elsif ($a->{voice}) { return -1; }
#        elsif ($b->{voice}) { return 1; }
#        else { return 0; }
#      } @{$usr[$whichwin]}[1 .. $acsui];

      @{$usr[$whichwin]}[1 .. $acsui] = sort {
        if ($a->{op} && ! $b->{op}) { return -1; }
        elsif ($a->{op} && $b->{op}) { return (uc($a->{name}) cmp uc($b->{name})); }
        elsif (! $a->{op} && $b->{op}) { return 1; }
        elsif ($a->{voice} && ! $b->{voice}) { return -1; }
        elsif ($a->{voice} && $b->{voice}) { return (uc($a->{name}) cmp uc($b->{name})); }
        elsif (! $a->{voice} && $b->{voice}) { return 1; }
        else { return (uc($a->{name}) cmp uc($b->{name})); }
      } @{$usr[$whichwin]}[1 .. $acsui];
    }
    else
    {
      @{$usr[$whichwin]}[1 .. $acsui] = sort { 
        uc($a->{name}) cmp uc($b->{name})
      } @{$usr[$whichwin]}[1 .. $acsui];
    }
  }
}

sub AddUser {
  my ($whichwin, $newusr) = @_;

#  if ($usr[$whichwin]->[$whichnum]->{exists}) { AddLine("User clash!", Lang(16)); }
  $window[$whichwin]->{users}++;
  $usr[$whichwin]->[$window[$whichwin]->{users}]->{name} = $newusr;
#  $usr[$whichwin]->[$window[$whichwin]->{users}]->{exists} = 1;
  if ($window[$whichwin]->{sortusers})
  {
    SortUsers($whichwin);
  }
  if ($window[$whichwin]->{sortusers})
  {
    if ($thiswin eq $whichwin && ! $window[$thiswin]{noupdate}) { RedrawNicks; }
  }
  else
  {
    if ($window[$whichwin]->{users} <= $maxy - 5) { if ($thiswin eq $whichwin && ! $window[$thiswin]{noupdate}) { RedrawNicks; } }
  }
}

sub RenUser {
  my ($whichwin, $oldusr, $renusr) = @_;

#  $ac_changedulist = "";
  my $ac_i; my $ac_j = 0;
  for ($ac_i = 1; $ac_i <= $window[$whichwin]->{users}; $ac_i++)
  {
    if (! $usr[$whichwin]->[$ac_i]->{invis}) { $ac_j++; }
    if ($usr[$whichwin]->[$ac_i]->{name} eq $oldusr)
    {
      $usr[$whichwin]->[$ac_i]->{name} = $renusr;
      last;
    }
  }
  if ($window[$whichwin]{sortusers})
  {
    SortUsers($whichwin);
    if ($thiswin eq $whichwin && ! $window[$thiswin]{noupdate}) { RedrawNicks; }
  }
  else
  {
    if ($ac_j <= $maxy - 5) { if ($thiswin eq $whichwin && ! $window[$thiswin]{noupdate}) { RedrawNicks; } }
  }
}

sub FindUser {
  my ($whichwin, $forwhat, $findusr) = @_;

  my $founds = 0;

  my $ac_i;

  if ($window[$whichwin]{users})
  {
    for ($ac_i = 1; $ac_i <= $window[$whichwin]{users}; $ac_i++)
    {
      if ((uc($usr[$whichwin]->[$ac_i]->{name}) eq uc($findusr)) && (($forwhat eq 1) || ($forwhat eq 0)))
      {
        return $ac_i;
      }
#      elsif ((substr(uc($usr[$whichwin]->[$ac_i]->{name}), 2, length($usr[$whichwin]->{name}) - 2) eq uc($findusr)) && (($forwhat eq 1) || ($forwhat eq 0)))
#      {
#        return $ac_i;
#      }
      elsif ((uc($usr[$whichwin]->[$ac_i]->{id}) eq uc($findusr)) && (($forwhat eq 2) || ($forwhat eq 0)))
      {
        return $ac_i;
      }
      elsif ($forwhat eq 10 && length($usr[$whichwin][$ac_i]{name}) >= length($findusr) && uc(substr($usr[$whichwin][$ac_i]{name}, 0, length($findusr))) eq uc($findusr))
      {
        $founds++;
        if ($window[$whichwin]{protocol} eq 3 && $usr[$whichwin][$ac_i]{status} ne 65535)
        {
          $foundusr[$founds] = $usr[$whichwin][$ac_i]{id} . " ";
        }
        elsif ($window[$whichwin]{protocol} ne 3)
        {
          $foundusr[$founds] = $usr[$whichwin][$ac_i]{name};
        }
      }
    }
    if ($founds > 0)
    {
      if ($founds eq 1)
      {
        return $foundusr[$founds];
      }
      $founds = "";
      @$foundusr = ();
    }
  }
  return "";
}

sub NameOf {
  my ($whichwin, $ac_userid) = @_;

  my $ac_i;

  for ($ac_i = 1; $ac_i <= $window[$whichwin]->{users}; $ac_i++)
  {
    if (uc($usr[$whichwin]->[$ac_i]->{id}) eq uc($ac_userid))
    {
      return $usr[$whichwin]->[$ac_i]->{name};
    }
  }
  return "Mr Mysterious";
}

sub DelUser {
  my ($whichwin, $delusr) = @_;

  my $changedulist = "";
  my $ac_j = 0; my $ac_k = 0;

  $delusr = FindUser($whichwin, 1, $delusr);

  if ($delusr)
  {
    my $acdui;
    if ($delusr < $window[$whichwin]->{users})
    {
      for ($acdui = $delusr; $acdui < $window[$whichwin]{users}; $acdui++)
      {
        $usr[$whichwin][$acdui]{id} = $usr[$whichwin][$acdui + 1]{id};
        $usr[$whichwin][$acdui]{name} = $usr[$whichwin][$acdui + 1]{name};
        $usr[$whichwin][$acdui]{op} = $usr[$whichwin][$acdui + 1]{op};
        $usr[$whichwin][$acdui]{voice} = $usr[$whichwin][$acdui + 1]{voice};
        $usr[$whichwin][$acdui]{pizza} = $usr[$whichwin][$acdui + 1]{pizza};
        $usr[$whichwin][$acdui]{me} = $usr[$whichwin][$acdui + 1]{me};
        $usr[$whichwin][$acdui]{modes} = $usr[$whichwin][$acdui + 1]{modes};
        $usr[$whichwin][$acdui]{invis} = $usr[$whichwin][$acdui + 1]{invis};
        $usr[$whichwin][$acdui]{status} = $usr[$whichwin][$acdui + 1]{status};
        $usr[$whichwin][$acdui]{fullname} = $usr[$whichwin][$acdui + 1]{fullname};
        $usr[$whichwin][$acdui]{ip} = $usr[$whichwin][$acdui + 1]{ip};
        $usr[$whichwin][$acdui]{realip} = $usr[$whichwin][$acdui + 1]{realip};
        $usr[$whichwin][$acdui]{port} = $usr[$whichwin][$acdui + 1]{port};
      }
    }
    $acdui = $window[$whichwin]{users};

    $usr[$whichwin][$acdui]{id} = "";
    $usr[$whichwin][$acdui]{name} = "";
    $usr[$whichwin][$acdui]{op} = "";
    $usr[$whichwin][$acdui]{voice} = "";
    $usr[$whichwin][$acdui]{pizza} = "";
    $usr[$whichwin][$acdui]{me} = "";
    $usr[$whichwin][$acdui]{modes} = "";
    $usr[$whichwin][$acdui]{invis} = "";
    $usr[$whichwin][$acdui]{status} = "";
    $usr[$whichwin][$acdui]{fullname} = "";
    $usr[$whichwin][$acdui]{ip} = "";
    $usr[$whichwin][$acdui]{realip} = "";
    $usr[$whichwin][$acdui]{port} = "";

    $window[$whichwin]->{users}--;
  }
  else
  {
    NoMoreUsers($whichwin);
  }

  if ($window[$whichwin]{sortusers})
  {
#    SortUsers($whichwin);
    if ($whichwin eq $thiswin) { RedrawNicks; }
  }
  else
  {
    if ($window[$whichwin]->{users} <= $maxy - 5) { if ($whichwin eq $thiswin) { RedrawNicks; } }
  }

}

sub UpdateGame {
  my ($wgame) = @_;

  my $uga = wherex; my $ugb = wherey; my $ugc = getattrs($mainwin);
  textcolor(8);
  if (($wgame >= 1) && ($wgame <= 4))
  {
    addstr($wgame * 4 + 1, $maxx - 17, $game[$thiswin]->[$wgame]->{maxplay} - $game[$thiswin]->[$wgame]->{players});
  }
  elsif ($wgame eq 5)
  {
    gotoxy($maxx - 13, $maxy - 1);
    if ($messwaiting > 18) { textcolor(28); }
    elsif ($messwaiting > 14) { textcolor(12); }
    elsif ($messwaiting > 9) { textcolor(4); }
    else { addstr("0"); }
    addstr($messwaiting); refresh();
  }
  elsif ($wgame eq 6)
  {
    gotoxy($maxx - 3, $maxy - 1);
    if ($pagesswaiting < 2) { textcolor(28); }
    elsif ($pagesswaiting < 6) { textcolor(12); }
    elsif ($pagesswaiting < 11) { textcolor(4); }
    if (22 - $pagesswaiting < 10) { addstr("0"); }
    addstr(22 - $pagesswaiting);
  }
  gotoxy($uga, $ugb); attrset($mainwin, $ugc);
}

sub strpNoSpace {
  my ($ac_texty) = @_;

  $ac_texty = Strrrp($ac_texty);

  while (index($ac_texty, " ") > -1)
  {
    $ac_texty = substr($ac_texty, 0, index($ac_texty, " ") - 1) . substr($ac_texty, index($ac_texty, " ") - 1);
  }

  return $ac_texty;
}

sub newwindow {
  my $acz;

  for ($acz = 1; $acz <= $windowcount; $acz++)
  {
    if (! $window[$acz]{protocol})
    {
      return $acz;
    }
  }
  $windowcount++;
  return $windowcount;
}

sub NewMy {
  my ($az1, $az2) = @_;

  $my[$az1]{id} = $my[$az2]{id};
  $my[$az1]{name} = $my[$az2]{name};
  $my[$az1]{op} = "";
  $my[$az1]{voice} = "";
  $my[$az1]{pizza} = "";
  $my[$az1]{modes} = $my[$az2]{modes};
  $my[$az1]{invis} = $my[$az2]{invis};
  $my[$az1]{status} = $my[$az2]{status};
}

sub NoMoreChannel {
  my ($acz) = @_;

  $window[$acz]{channel} = "";
  $window[$acz]{modes} = "";

  NoMoreBans($acz);
  NoMoreGames($acz);
  NoMorePizzas($acz);
}

sub NoMoreMe {
  my ($acz) = @_;

  $my[$acz]{id} = "";
#  $my[$acz]{name} = "";
  $my[$acz]{op} = "";
  $my[$acz]{voice} = "";
  $my[$acz]{pizza} = "";
  $my[$acz]{modes} = "";
  $my[$acz]{invis} = "";
  $my[$acz]{status} = "";
}

sub NoMoreUsers {
  my ($acz) = @_;

  if ($window[$acz]{users} && $window[$acz]{users} > 0)
  {
    my $acdui;
    for ($acdui = 1; $acdui <= $window[$acz]{users}; $acdui++)
    {
      $usr[$acz][$acdui]{id} = "";
      $usr[$acz][$acdui]{name} = "";
      $usr[$acz][$acdui]{op} = "";
      $usr[$acz][$acdui]{voice} = "";
      $usr[$acz][$acdui]{pizza} = "";
      $usr[$acz][$acdui]{me} = "";
      $usr[$acz][$acdui]{modes} = "";
      $usr[$acz][$acdui]{invis} = "";
      $usr[$acz][$acdui]{status} = "";
      $usr[$acz][$acdui]{fullname} = "";
      $usr[$acz][$acdui]{ip} = "";
      $usr[$acz][$acdui]{realip} = "";
      $usr[$acz][$acdui]{port} = "";
    }
  }
  $window[$acz]{users} = 0;
}

sub NoMoreBans {
  my ($acz) = @_;

  if ($window[$acz]{bans})
  {
    my $aci;
    for ($aci = 1; $aci <= $window[$acz]{bans}; $aci++)
    {
      $ban[$acz][$aci] = "";
    }
    $window[$acz]{bans} = "";
  }
}

sub NoMoreGames {
  my ($acz) = @_;

  if ($window[$acz]{games})
  {
    my $aci;
    for ($aci = 1; $aci <= $window[$acz]{games}; $aci++)
    {
      $game[$acz][$aci]{maxplay} = 0;
      $game[$acz][$aci]{players} = 0;
    }
    $window[$acz]{games} = "";
  }
}

sub NoMorePizzas {
  my ($acz) = @_;

  if ($window[$acz]{pizzahost})
  {
    if ($window[$acz]{pizzas})
    {
      my $aci;
      for ($aci = 1; $aci <= $window[$acz]{pizzas}; $aci++)
      {
        $pizza[$acz][$aci]{topping} = "";
        $pizza[$acz][$aci]{price} = 0;
      }
      $window[$acz]{pizzas} = "";
    }
    $window[$acz]{pizzahost} = "";
  }
}

sub newWindowInit {
  my ($acz, $acy) = @_;

  if (! $acy) { $acy = 0; }

  if ($acy eq 0)
  {
    $window[$acz]{protocol} = "";
  }
  else
  {
    $window[$acz]{protocol} = $acy;
  }
  $window[$acz]{topic} = "";
  $window[$acz]{control} = "";
  $window[$acz]{filecontrol} = "";
  $window[$acz]{channel} = "";
  $window[$acz]{modes} = "";
  $window[$acz]{unseen} = "";
  $window[$acz]{noupdate} = "";
  $window[$acz]{sortusers} = "";
  $window[$acz]{subprotocol} = "";

#  $window[$acz]{nick} = $my{'nick'};			# Broken Hack!
#  $my[$acz]{nick} = $config{'nick'};			# Worse Hack!
  $my[$acz]{name} = $config{name};			# Better Hack!

  NoMoreUsers($acz);
  NoMoreBans($acz);
  NoMoreGames($acz);
  NoMorePizzas($acz);

  my $aci;
  for ($aci = 1; $aci <= $maxy - 5; $aci++)
  {
    $chline[$acz][$aci] = "";
    $chsline[$acz][$aci] = "";
  }

#  if ($acy eq 2)
#  {
#    RedrawChanInfo();
#  }
}

sub ReadConfig {
  $config{'name'} = "";
  my $defalias = "";
  $config{andypath} = "./";
  $config{dukepath} = "";
  $config{doom2path} = "";
  $config{bloodpath} = "";
  $config{swpath} = "";
  $config{rottpath} = "";
  $config{doompath} = "";
  $config{wormspath} = "";
  $config{quakepath} = "";
  # $config{mp3path} = "";
  $config{mp3app} = "";
  $config{paging} = 1;
  $config{cdstoponexit} = "";
  $config{invis} = "";
  $nolang = 1;
  $langua = "";
  $logging = "";
  $config{'room'} = "001";
#  $thisroom{'topic'} = 
  $thiswin = 1;
  $window[$thiswin]{topic} = "Lobby";
  $window[$thiswin]{op} = 0;
  $window[$thiswin]{protocol} = 1;
  $cf = "";

  $colour{'border'} = 1; $colour{'topline'} = 2;
  $colour{'scrolly'} = 1; $colour{'pagemsg'} = 11;
  $colour{'typemsg'} = 14; $colour{'scrollback'} = 14;
  $colour{'time'} = 8; $colour{'date'} = 8; $colour{'game'} = 8;

  if ((-f "andychat.ini") && (-r "andychat.ini"))
  {
    open(F, "andychat.ini");
    @flines = <F>;
    close(F);
    $fsize = @flines;

    my $i;
    for ($i = 0; $i < $fsize; $i++)
    {
      $str1 = ltrim(rtrim(substr($flines[$i], 0, -1)));
      if ((substr($str1, -1, 1) eq chr(13)) || (substr($str1, -1, 1) eq chr(10)))
      {
        $str1 = substr($str1, 0, -1);
      }
      if (substr($str1, 0, 1) eq ";")
      {
      }
      elsif (substr(lc($str1), 0, 9) eq "defalias=")
      {
        if (length($str1) > 9) { $defalias = strpNoSpace(substr($str1, 9)); }
        if (length($defalias) > 12) { $defalias = substr($defalias, 0, 12); }
        $config{'name'} = $defalias;
      }
      elsif (substr(lc($str1), 0, 9) eq "andypath=")
      {
        if (length($str1) > 9) { $config{andypath} = substr($str1, 9); }
        if (substr($config{andypath}, -1, 1) ne "/") { $config{andypath} = "$config{andypath}/"; }
      }
      elsif (substr(lc($str1), 0, 9) eq "dukepath=")
      {
        if (length($str1) > 9) { $config{dukepath} = substr($str1, 9); }
      }
      elsif (substr(lc($str1), 0, 9) eq "doompath=")
      {
        if (length($str1) > 9) { $config{doompath} = substr($str1, 9); }
      }
      elsif (substr(lc($str1), 0, 10) eq "doom2path=")
      {
        if (length($str1) > 10) { $config{doom2path} = substr($str1, 10); }
      }
      elsif (substr(lc($str1), 0, 10) eq "bloodpath=")
      {
        if (length($str1) > 10) { $config{bloodpath} = substr($str1, 10); }
      }
      elsif (substr(lc($str1), 0, 10) eq "wormspath=")
      {
        if (length($str1) > 10) { $config{wormspath} = substr($str1, 10); }
      }
      elsif (substr(lc($str1), 0, 10) eq "quakepath=")
      {
        if (length($str1) > 10) { $config{quakepath} = substr($str1, 10); }
      }
      elsif (substr(lc($str1), 0, 7) eq "swpath=")
      {
        if (length($str1) > 7) { $config{swpath} = substr($str1, 7); }
      }
      elsif (substr(lc($str1), 0, 9) eq "rottpath=")
      {
        if (length($str1) > 9) { $config{rottpath} = substr($str1, 9); }
      }
      elsif (substr(lc($str1), 0, 10) eq "invisible=")
      {
        if (length($str1) > 10)
        {
          $str1 = ltrim(substr($str1, 10));
          $str2 = substr($str1, 1, 1); $str1 = substr($str1, 0, 1);
          if (($str1 eq "1") || (lc($str1) eq "t") || (lc($str1) eq "y") || (lc($str2) eq "n"))
          {
            $config{'invis'} = 1;
            # To be re-implemented later .. perhaps
          }
        }
      }
      elsif (substr(lc($str1), 0, 7) eq "paging=")
      {
        if (length($str1) > 10)
        {
          $str1 = ltrim(substr($str1, 7));
          $str2 = substr($str1, 1, 1); $str1 = substr($str1, 0, 1);
          if (($str1 eq "0") || (lc($str1) eq "f") || (lc($str1) eq "n") || (lc($str2) eq "f"))
          {
            $config{paging} = 0;
          }
        }
        else
        {
          $config{paging} = 0;
        }
      }
      elsif (substr(lc($str1), 0, 13) eq "cdstoponexit=")
      {
        if (length($str1) > 10)
        {
          $str1 = ltrim(substr($str1, 13));
          $str2 = substr($str1, 1, 1); $str1 = substr($str1, 0, 1);
          if (($str1 eq "1") || (lc($str1) eq "t") || (lc($str1) eq "y") || (lc($str2) eq "n"))
          {
            $config{cdstoponexit} = 1;
          }
        }
      }
      elsif (substr(lc($str1), 0, 5) eq "room=")
      {
        # To be re-implemented later .. perhaps
      }
      elsif (substr(lc($str1), 0, 4) eq "kill")
      {
        $config{(split(/=/, $str1, 2))[0]} = (split(/=/, $str1, 2))[1];
      }
      elsif (substr(lc($str1), 0, 4) eq "new_")
      {
        $config{(split(/=/, substr($str1, 4), 2))[0]} = (split(/=/, substr($str1, 4), 2))[1];
      }
      elsif (substr(lc($str1), 0, 5) eq "show_")
      {
        $config{(split(/=/, $str1, 2))[0]} = (split(/=/, $str1, 2))[1];
      }
      elsif (substr(lc($str1), 0, 9) eq "language=")
      {
        if (length($str1) > 9)
        {
          $langua = substr($str1, 9);
          if (-r $langua)
          {
            $nolang = "";
            open(langfile, $langua);
            @langline = <langfile>;
            close(langfile);
            $langsize=@langline;
            for ($j = 0; $j < $langsize; $j++)
            {
              $langline[$j] = substr($langline[$j], 0, -1);
              if ((substr($langline[$j], -1, 1) eq chr(13)) || (substr($langline[$j], -1, 1) eq chr(10)))
              {
                $langline[$j] = substr($langline[$j], 0, -1);
              }
            }
          }
        }
      }
      elsif (substr(lc($str1), 0, 8) eq "colours=")
      {
        if (length($str1) > 8)
        {
          $langua = substr($str1, 8);
          if (-r $langua)
          {
            open(CFILE, $langua);
            @CLINES=<CFILE>;
            close(CFILE);
            $CSIZE=@CLINES;

            for ($j = 0; $j < $CSIZE; $j++)
            {
              $langua = lc(substr($CLINES[$j], 0, -1));
              if ((substr($langua, 0, 7) eq "border=") || (substr($langua, 0, 8) eq "topline=") ||
                  (substr($langua, 0, 8) eq "scrolly=") || (substr($langua, 0, 8) eq "pagemsg=") ||
                  (substr($langua, 0, 8) eq "typemsg=") || (substr($langua, 0, 11) eq "scrollback=") ||
                  (substr($langua, 0, 5) eq "date=") || (substr($langua, 0, 5) eq "time=") ||
                  (substr($langua, 0, 5) eq "game=") || (substr($langua, 0, 6) eq "topic="))
              {
                $bla = substr($langua, 0, index($langua, "="));
                $colour{$bla} = int(ltrim(rtrim(substr($langua, -2, 2))));
              }
            }
            $cf = 1;
          }
        }
      }
      elsif (substr(lc($str1), 0, 8) eq "logging=")
      {
        if (length($str1) eq 9)
        {
          $str1 = substr($str1, 8);
          if (($str1 eq "1") || (lc($str1) eq "t") || (lc($str1) eq "y"))
          {
            $logging = 1;
            open(logfile, ">>$config{andypath}" . "andychat.log");
            print logfile "\nLogfile opened on " . qbDATE() . " @ " . qbTIME() . "\n\n";
          }        
        }
        elsif (length($str1) eq 8)
        {
        }
        else
        {
          $str1 = substr($str1, 8);
          if ((lc($str1) eq "yes") || (lc($str1) eq "true") || (lc($str1) eq "on"))
          {
            $logging = 1;
            open(logfile, ">>$config{andypath}$+andychat.log");
            print logfile "\nLogfile opened on " . qbDATE() . " @ " . qbTIME() . "\n\n";
          }
          else
          {
            $logging = 1;
            open(logfile, ">>$config{andypath}$str1");
            print logfile "\nLogfile opened on " . qbDATE() . " @ " . qbTIME() . "\n\n";
          }
        }
      }
    }
  }
  if ((not $cf) && (-r "colour.ini"))
  {
    open(CFILE, "colour.ini");
    @CLINES=<CFILE>;
    close(CFILE);
    $CSIZE=@CLINES;

    for ($j = 0; $j < $CSIZE; $j++)
    {
      $langua = lc(substr($CLINES[$j], 0, -1));
      if ((substr($langua, 0, 7) eq "border=") || (substr($langua, 0, 8) eq "topline=") ||
          (substr($langua, 0, 8) eq "scrolly=") || (substr($langua, 0, 8) eq "pagemsg=") ||
          (substr($langua, 0, 8) eq "typemsg=") || (substr($langua, 0, 11) eq "scrollback=") ||
          (substr($langua, 0, 5) eq "date=") || (substr($langua, 0, 5) eq "time=") ||
          (substr($langua, 0, 5) eq "game=") || (substr($langua, 0, 6) eq "topic="))
      {
        $bla = substr($langua, 0, index($langua, "="));
        $colour{$bla} = int(ltrim(rtrim(substr($langua, -2, 2))));
      }
    }
    $cf = 1;
  }
}

$colline = "1234567890!\@#\$\%";
