##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Protocols
#
# 29th of April, 2000
# - (11.30pm) Added 'strict' flag to whichcontrol
#
# 28th of April, 2000
# - Moved IRC functions into seperate thing
#

sub whichcontrol {
  my ($self, $protocol, $channel, $strict) = @_;

  if ($window[$thiswin]{protocol} && $window[$thiswin]{protocol} eq $protocol && $window[$thiswin]{control} && $self eq $window[$thiswin]{control})
  {
    if (! $channel || ($window[$thiswin]{channel} && uc($window[$thiswin]{channel}) eq uc($channel)) || ($window[$thiswin]{query} && uc($window[$thiswin]{query}) eq uc($channel)))
    {
      $whichwin = $thiswin;
      return $thiswin;
    }
  }

  for ($ap_i = 1; $ap_i <= $windowcount; $ap_i++)
  {
    if ($window[$ap_i]{protocol} && $window[$ap_i]{protocol} eq $protocol && $window[$ap_i]{control} && $self eq $window[$ap_i]{control})
    {
      if (! $channel || ($window[$ap_i]{channel} && uc($window[$ap_i]{channel}) eq uc($channel)) || ($window[$ap_i]{query} && uc($window[$ap_i]{query}) eq uc($channel)))
      {
        $whichwin = $ap_i;
        return $ap_i;
      }
    }
  }

  if ($strict)
  {
    $whichwin = "";
    return;
  }
  else
  {
    $whichwin = $thiswin;
    return $thiswin;
  }
}

sub foreachcontrol {
  my ($self, $protocol, $todo) = @_;

  for ($ap_z = 1; $ap_z <= $windowcount; $ap_z++)
  {
    if ($window[$ap_z]{protocol} && $window[$ap_z]{protocol} eq $protocol && $window[$ap_z]{control} && $self eq $window[$ap_z]{control})
    {
      &{$todo}($ap_z);
    }
  }
}

# Load IRC module :-)

do 'a_protocols_irc.pl';

# Load ICQ module :-)

do 'a_protocols_icq.pl';

# Load Licq-parser module :-)

do 'a_protocols_licq-parser.pl';
