##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Protocols - ICQ
#
# 28th of April, 2000
# -  (6.09pm) Started work on ICQ function parsers
#

sub __icq__TextToStatus {
  my ($tmpstatus) = @_;

  if ($tmpstatus eq "Online")
  {
    return 0;
  }
  elsif ($tmpstatus eq "Away")
  {
    return 1;
  }
  elsif ($tmpstatus eq "Do Not Disturb")
  {
    return 2;
  }
  elsif ($tmpstatus eq "Not Available")
  {
    return 4;
  }
  elsif ($tmpstatus eq "Occupied")
  {
    return 16;
  }
  elsif ($tmpstatus eq "Free for Chat")
  {
    return 32;
  }
  elsif ($tmpstatus eq "Offline")
  {
    return 65535;
  }
  else
  {
    return "Unknown";
  }
}

sub __icq__StatusToText {
  my ($tmpstatus) = @_;

  if ($tmpstatus eq 0)
  {
    return "`1Online";
  }
  elsif ($tmpstatus eq 1)
  {
    return "`2Away";
  }
  elsif ($tmpstatus eq 2)
  {
    return "`2Do Not Disturb";
  }
  elsif ($tmpstatus eq 4)
  {
    return "`2Not Available";
  }
  elsif ($tmpstatus eq 16)
  {
    return "`2Occupied";
  }
  elsif ($tmpstatus eq 32)
  {
    return "`1Free for Chat";
  }
  elsif ($tmpstatus eq 65535)
  {
    return "`4Offline";
  }
  return "`#Unknown";
}

sub icq__on_useronline {
  my ($self, $tmpuin, $tmpstatus) = @_;

  $whichwin = whichcontrol($self, 3, "Server Messages");
  $tmpnum = FindUser($whichwin, 2, $tmpuin);
  if ($tmpnum)
  {
    if ($usr[$whichwin][$tmpnum]{status} eq 65535)
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7$usr[$whichwin][$tmpnum]{name} `8(`7$tmpuin`8) `7went `1online`7.");
      $usr[$whichwin][$tmpnum]{status} = $tmpstatus;
      if ($whichwin eq $thiswin) { SortUsers($thiswin); RedrawNicks(); }
    }
    else
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7$usr[$whichwin][$tmpnum]{name} `8(`7$tmpuin`8) `7went `1online `7twice?");
      $usr[$whichwin][$tmpnum]{status} = $tmpstatus;
      if ($whichwin eq $thiswin) { SortUsers($thiswin); RedrawNicks(); }
    }
  }
  else
  {
    AddLine($whichwin, "`2" . qbTIME() . "       `4Not In List `8(`7$tmpuin`8) `7went `1online`7.");
  }
}

sub icq__on_useroffline {
  my ($self, $tmpuin) = @_;

  $whichwin = whichcontrol($self, 3, "Server Messages");
  $tmpnum = FindUser($whichwin, 2, $tmpuin);
  if ($tmpnum)
  {
    if ($usr[$whichwin][$tmpnum]{status} ne 65535)
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7$usr[$whichwin][$tmpnum]{name} `8(`7$tmpuin`8) `7went `4offline`7.");
      $usr[$whichwin][$tmpnum]{status} = 65535;
      if ($whichwin eq $thiswin) { SortUsers($thiswin); RedrawNicks(); }
    }
    else
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7$usr[$whichwin][$tmpnum]{name} `8(`7$tmpuin`8) `7went `4offline `7twice?");
    }
  }
  else
  {
    AddLine($whichwin, "`2" . qbTIME() . "       `4Not In List `8(`7$tmpuin`8) `7went `4offline`7.");
  }
}

sub icq__on_userstatus {
  my ($self, $tmpuin, $tmpstatus) = @_;

  $whichwin = whichcontrol($self, 3, "Server Messages");
  $tmpnum = FindUser($whichwin, 2, $tmpuin);
  if ($tmpnum)
  {
    if ($usr[$whichwin][$tmpnum]{status} ne $tmpstatus)
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7" . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . " `8(`7$tmpuin`8) `7changed status`8: " . __icq__StatusToText($tmpstatus) . "`7.");
      $usr[$whichwin][$tmpnum]{status} = $tmpstatus;
      if ($whichwin eq $thiswin) { SortUsers($thiswin); RedrawNicks(); }
    }
    else
    {
      AddLine($whichwin, "`2" . qbTIME() . "       `7" . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . " `8(`7$tmpuin`8) `7changed status`8: " . __icq__StatusToText($tmpstatus) . " `7twice?");
    }
  }
  else
  {
    AddLine($whichwin, "`2" . qbTIME() . "       `4Not In List `8(`7$tmpuin`8) `7changed status`8: " . __icq__StatusToText($tmpstatus) . "`7.");
  }
}

sub icq__on_udpmessage {
  my ($self, $tmpdata);

  $whichwin = whichcontrol($self, 3, "Server Messages");

  AddLine($whichwin, "`2" . qbTIME() . " `8[`7UDP`8] `7" . DoubleQuote($tmpdata));
}

sub icq__on_tcpmessage {
  my ($self, $tmpdata);

  $whichwin = whichcontrol($self, 3, "Server Messages");

  AddLine($whichwin, "`2" . qbTIME() . " `8[`7TCP`8] `7" . DoubleQuote($tmpdata));
}

