#!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
#
# Started on Wednesday, 9th of February, 2000 around 11pm
#
# Build 0507 - 7th of May, 2000
# -  (7.45am) PgUp, PgDn, End all work nicely :)
# -  (8.09am) [ESC] to kill dead windows :)
#
# Build 0506 - 6th of May, 2000
# -  (3.07am) Removed /PLAYFILE and /STOPFILE until I can manage them better
# -  (4.58am) Bit of work on the arrow key handling and stuff (twas getting silly)
#
# Build 0505 - 5th of May, 2000
# -  (5.34am) Started work on new Curses window based stuff
#
# Build 0430 - 30th of April, 2000
# -  (8.00pm) Added handler for on_ctime
# - (12.37am) Fixed RedrawChanInfo() bug on /window kill
#
# Build 0429 - 29th of April, 2000
# -  (7.39pm) Started work on new advanced editor routines
# - (10.05pm) Config element new_ircname for defining name in IRC
# - (10.17pm) Fix for already in channel stuff not working
# - (10.17pm) Fixes for some op functions and stuff phantoming from earlier
# - (10.40pm) Several RedrawActivity tie-ins
# - (10.53pm) Several RedrawChanInfo optimises
# - (11.19pm) Buggered up some RedrawChanInfo optimises (fixed)
# - (12.01am) Fix for RedrawChanInfo glitch
# - (12.03am) Fix for backspace @ char 0
# - (12.23am) Editing things in the distro directory and then running the non-distro version is a bad idea :)
# - (12.23am) After realising I was working with 2 different versions, fixed some backspace @ char 0 probs :)
#
# Build 0412 - 12th of April, 2000
# -  (2.50am) Real name = AndyChat [version] - http://andy.secret.com.au/
# -  (2.56am) Added on_kick handler
# -  (9.06pm) More ` fixes
# -  (3.35am) Finished adding /kick command (?)
# -  (3.49am) Added /OP and /DOP commands
# -  (4.54am) Implemented /PING (1 hour!?  Don't know what happened there! :P)
#
# Build 0411 - 11th of April, 2000
# - (11.25pm) Real name = AndyChat [version] - http://www.secret.com.au/progs/andychat/
#
# Build 0409 - 9th of April, 2000
# - (12.01pm) Remove $my changing when doing /NICK, should fix earlier bugs
# -  (3.36pm) Set $window{sortusers} upon /JOIN
# -  (3.54pm) Fixed /NICK changing bug when not in a channel
# -  (4.15pm) Don't allow a /IRC server in a window which is already linked to server
# -  (4.42pm) Fixed some * issues (ie. nickname in use upon login)
#
# Build 0408 - 8th of April, 2000
# -  (4.10pm) Implemented PgUp/PgDn for old /LEFT stuffz
# -  (4.30pm) Added [Server Messages] window based on a bug and I like it :P
# -  (5.08pm) Added some missing handlers for IRC server info code
# - (12.19am) Some fixes for leftwindow changing updates
#
# Build 0406 - 6th of April, 2000
# - (12.55am) /PLAYFILE doesn't go icky now
# -  (1.01am) Various /PLAYFILE fixes
# -  (1.04am) Increase default /PLAYFILE delay to 2 seconds
# -  (1.13am) More /PLAYFILE bits
# -  (1.17am) Even more /PLAYFILE bits
# -  (1.22am) Fixed nick completion on tab not causing a refresh
# -  (5.44pm) Changed $me{} to $config{}
# -  (5.47pm) $paging is now $config{paging}; $cdstoponexit, $config{cdstoponexit}
# -  (5.51pm) Changed various $*path's to $config{*paths}
# -  (5.55pm) /INV command sets mode +i/-i for IRC
# -  (9.56pm) Began Query support (so I could talk to st`ph better)
# - (10.14pm) Added /QUERY [name]
# - (10.29pm) Fixed some /ME bugs which never occurred
# - (10.36pm) Fixed bug to do with left/right into windows with 'nothing'
# - (10.39pm) Fixed more left/right/window bugs into mysterious windows
# - (11.06pm) Added already in channel checking support
#
# Build 0405 - 5th of April, 2000
# - (12.40am) /JOIN now copies $my to newly created window
#
# Build 0404 - 4th of April, 2000
# -  (8.29pm) Fixed nick change error not showing colours properly
# -  ( ---- ) Added /PLAYFILE <file>
# -  ( ---- ) added /STOPFILE
# -  (9.36pm) /TOPIC implemented (IRC)
# -  (9.44pm) Fixed some /TOPIC <channel> <topic> issues
# -  (9.50pm) Fixed /TOPIC bug
#
# Build 0328 - 28th of March, 2000
# -  (2.24am) Added window parameter to AddLine's
# -  ( ---- ) Added /WINDOW NEW, worth a mention I guess :P
# -  (3.05am) Added proper parameters to newWindowInit
# -  (3.13am) Added /WINDOW NEXT
# -  (3.22am) Added left-arrow, right-arrow -> /window prev, /window next
# -  (3.24am) Added /WINDOW PREV
# -  (3.27am) Fixed no update bug, gotta learn Perl methinks :)
# -  (3.50am) No longer uses ClearAliasWindow, RedrawNicks instead due to bizarrity
# -  (4.01am) ReTitle fixes in /WINDOW NEW, NEXT, PREV
# -  (4.46am) Increased backtype buffer from 10 to 32
# -  (5.11am) Made funky /JOIN code to create new window on same server
# -  (5.14am) Implemented irc__join instead of $window[bla]{control}->join
# -  (5.18am) Added /WINDOW KILL (destroys -current- window if > 1 :P)
# -  (5.21am) Don't clear Window 1 even
# -  (5.40am) Control connection on new join channel window things works
# -  (5.44am) Corrected protocol mode for created windows
# -  (6.01am) ALT-1 .. ALT-9 go to window's 1-9
# -  (6.08am) ALT = 27, not 0
# -  (4.00pm) [wrong file] Patched Net-IRC module to do cunknown
#
# Build 0325 - 25th of March, 2000
# - (12.15am) Implemented $thisword into GetLLine (for nick completion, etc)
# -  (1.13am) Added nick completion.  Works only when -no- duplicates.
# -  (1.51pm) Added handlers for vworld/help on Austnet
# -  (3.43pm) Tab completion now works for first word entered
# -  (3.54pm) Nick completion and : highlighting for personal messages
# -  (4.18pm) Does above when no spaces in input now
#
# Build 0324 - 24th of March, 2000
# - (12.23am) Added | to / conversion in Pizza names
# -  (1.08am) Added cpizza handler and it works *laughs*
# -  (3.17am) /SELLPIZZA works :)
# -  (3.45am) /NICK implemented (IRC)
# -  (4.05am) /NICK fixes for forbidden nicks + language fixes
# -  (1.35pm) /AWAY implemented (IRC)
# -  (2.16pm) Included a_screen.pl
# -  (6.44pm) Return correct lang() error for nick too long
# - (11.10pm) /PART implemented (IRC)
# - (11.50pm) /QUIT implemented (IRC)
#
# Build 0323 - 23rd of March, 2000
# -  (5.34pm) Don't strip whitespace from left of input unless it's a command
# -  (5.48pm) Fixed time update bug (every second, urgh!)
# -  (5.52pm) Fixed time/date update cursor replacement whilst typing bug
# -  (6.00pm) Fixed time/date update position x = y, y = x?  What was I thinking.
# -  (6.05pm) No longer adds things to the bottom of the keyboard back buffer if
#             they are the same as the last thing you typed/copied.
# -  (7.00pm) Added /PIZZA
# -  (7.12pm) Added /CTCP
# -  (7.16pm) Fixed the keyboard up/down stuff I kinda broke before
# -  (7.39pm) Converted $my{} to $my[$window]{}, and globals/defaults are now $me{}
# -  (7.52pm) Removing obsolete code is sometimes a bad idea :P  Messages are now
#             being sent again :)
# -  (8.30pm) /INV kinda implemented .. kinda
# -  (8.48pm) /QUIT kinda implemented (if ! IRC; exit)
# -  (8.48pm) /X implemented (exit)
# -  (9.11pm) Included a_help.pl
# -  (9.13pm) /HELP implemented
# - (10.03pm) /CANCEL half implemented (for cancelling pizza orders)
# - (10.13pm) /BUYPIZZA half implemented
# - (11.26pm) /SELLPIZZA half implemented
# - (11.34pm) /KILLPIZZA half implemented
# - (11.44pm) /CLS (aka: /CLEAR) implemented
#
# Build 0322 - 22nd of March, 2000
# - (12.13am) Changed IRC polls to test a theory
# - (12.48am) Restored IRC poll time
# -  ( ---- ) Fixed keyboard buffer scrollback
# -  (1.10am) Doubled line limit
# -  (1.17am) Moved /IRC JOIN to /JOIN
# -  ( ---- ) Made /J to /JOIN alias
# -  (2.38am) Tried to add up/down buffer support - failed
# -  (2.42am) Fixed up/down keyboard support
# -  (2.42am) Removed bogus keyboard arrow stuffz
# -  (2.44am) Fixed up/down keyboard count error
# -  (2.45am) Fixed up/down keyboard undefined var error
# -  (2.48am) Added "command not found" error
# -  (2.49am) Added "command not found" error - for IRC too
# -  (8.42pm) Once again porting SaveSpace bits
# -  (9.09pm) /NICK kinda implemented .. kinda
# -  (9.11pm) /QUOTE kinda implemented
#
# Build 0321 - 21st of March, 2000
# -  (1.00am) Continued work on stuffz
# -  (1.25am) Ported up-arrow back function thing incorrectly
# -  ( ---- ) Added DoIdleLoop
# -  ( ---- ) Added /me command (action).  Works for IRC.
# -  ( ---- ) Added /msg command (private message).  Works for IRC.
# -  ( ---- ) Added more IRC handlers
# -  (7.15pm) Tried to fix character bungling
# -  (8.08pm) Fixed character weirdness (backspace at beginning of line, ^_ stuffz)
# -  (8.18pm) Fixed bug thing
# - (10.10pm) Added port parameter to /irc connect
# - (10.56pm) Andrew can't count :)  /WHOIS = 6+1=7
# - (10.57pm) Andrew can't count :)  1 parameter = 1 parameter
# - (11.10pm) Made Build 0321 distribution
#
# Build 0217 - 17th of February, 2000
# -  (2.18pm) Fixed displaying of space after [xxx] room number if no topic
# -  (4.52pm) Porting more of end of code stuff
# -  (5.17pm) Porting more text entry nonsense
# -  (9.35pm) Began porting the basics of SaveSpace
#
# Build 0212 - 12th of February, 2000 (why do I bother with the date? :P)
# -  (1.08am) Resumed Work
# -  (1.xxam) Finished main sub (in a way)
# -  (1.56am) Finished Work for now
# -  (4.20pm) Integrated Language bits
#
# Build 0210 - 10th of February, 2000
# - (11.xxam) Continued stuffz
# -  (4.01pm) Fixed disappearing time bug
# -  (9.10pm) Started GetLLine
# - (10.25pm) Fixed yellow/magenta colour mistake
# - (10.30pm) GetLLine now properly recognises Backspace in XTerm and Console (?)
#
# Build 0209 - 9th of February, 2000
# - (11.xxpm) Initial Development
#
use Curses;
use Time::HiRes qw ( time alarm sleep );
use Term::ReadKey;
use Net::IRC;

do 'andy-ext.pl';
do 'curses2andy.pl';

do 'andy-txt.pl';

do 'a_lang.pl';
do 'a_common.pl';
do 'a_logo.pl';
do 'a_protocols.pl';
do 'a_help.pl';
do 'a_screen.pl';

$kbuff = "";	# You can't understand how dodgy this is :(((
$Version = "3.00";
$Build = "0507";
ReadMode(4);

# SUBS GO HERE

sub DoIdleLoop {
  if ($ircconnections > 0)
  {
    $andychat_irc->do_one_loop();
  }
  for ($dil_i = 1; $dil_i <= $windowcount; $dil_i++)
  {
    if ($window[$dil_i]{protocol} eq 3 && $window[$dil_i]{subprotocol} eq "c" && $window[$dil_i]{channel} eq "Server Messages")
    {
      licq_parser__do_one_loop($dil_i);
    }
  }
  ChecktheMess();
  if (($playfile) && (time() - $pfi11 > 2))
  {
    if ($pfin < $pfis)
    {
      $pfi11 = time();
      $ppp = $pfit[$pfin];
      $pfin++;
      if (($window[$pfic]->{protocol} eq 2) && ($ppp ne ""))
      {
        if ($window[$pfic]{channel})
        {
          irc__privmsg($window[$pfic]{control}, $window[$pfic]{channel}, $ppp);
          AddLine($pfic, $ppp, "`#<`7" . $my[$thiswin]{'name'} . "`#> `7");
        }
      }
    }
    else
    {
      $playfile = "";
      irc__action($window[$pfic]{control}, $window[$pfic]{channel}, Lang(105));
      AddLine($pfic, Lang(105), "`8" . chr(ACS_S1) . " `%" . $my[$thiswin]{'name'} . " `7");
    }
  }
  if (substr($ltime, 0, 5) ne substr(qbTIME(), 0, 5))
  {
    $tmpx = wherex();
    $tmpy = wherey();
    gotoxy($maxx - 21, 1); textcolor($colour{'time'});
    addstr(substr(qbTIME(), 0, 5)); $ltime = qbTIME();
    gotoxy($tmpx, $tmpy); textcolor($colour{'typemsg'});
    refresh();
  }
  if ($ldate ne qbDATE())
  {
    $tmpx = wherex();
    $tmpy = wherey();
    gotoxy($maxx - 12, 1); textcolor($colour{'date'});
    addstr(substr(qbDATE(), 0, 2) . "/" . substr(qbDATE(), 3, 2) . "/" . substr(qbDATE(), -2, 2)); $ldate = qbDATE();
    gotoxy($tmpx, $tmpy); textcolor($colour{'typemsg'});
    refresh();
  }
}

sub GetLLine {
  my ($zz1, $zz2, $zz3) = @_;

  $j = wherey();
  $k = wherex();
  my $ch = "";
  my $roffset = 0;

  if ($zz1 ne "")
  {
    $i = length($zz1);
    $tempstr = $zz1;
    if (length($tempstr) > $zz2)
    {
      addstr(substr($tempstr, length($tempstr) - $zz2, $zz2)); refresh;
    }
    else
    {
      addstr($tempstr); refresh;
    }
  }
  else
  {
    $i = 0;
    $tempstr = "";
  }
  while ($ch ne chr(13))
  {
    while (not keypressed())
    {
      DoIdleLoop;
    }
    $ch = kbuf();
    if (ord($ch) eq 27)
    {
      if (keypressed() && $kbuff eq "[")
      {
        $ch = kbuf();
        if (keypressed() && $kbuff eq "A")
        {
          $ch = kbuf();
          $kbuff = $kbuff . chr(0) . chr(72);
          $ch = kbuf();
        }
        elsif (keypressed() && $kbuff eq "B")
        {
          $ch = kbuf();
          $kbuff = $kbuff . chr(0) . chr(80);
          $ch = kbuf();
        }
        elsif (keypressed() && $kbuff eq "C")
        {
          $ch = kbuf();
          $kbuff = $kbuff . chr(0) . chr(77);
          $ch = kbuf();
        }
        elsif (keypressed() && $kbuff eq "D")
        {
          $ch = kbuf();
          $kbuff = $kbuff . chr(0) . chr(75);
          $ch = kbuf();
        }
      }
      else
      {
# Lost characters
      }
    }
    if ($ch eq chr(127))
    {
      if (keypressed())
      {
        $ch = kbuf();
        if ($ch eq "?")
        {
          $kbuff = $kbuff . chr(8);
          $ch = kbuf();
        }
      }
    }
    if ((($ch eq chr(8)) || ($ch eq chr(127))) && ($i + $roffset > 0))
    {
      $i--;
      if ($i eq 0)
      {
        $tempstr = "";
        $ch = chr(13);
      }
      elsif ($roffset < 0)
      {
        $tempstr = substr($tempstr, 0, length($tempstr) + $roffset - 1) . substr($tempstr, length($tempstr) + $roffset);
      }
      else
      {
        $tempstr = substr($tempstr, 0, -1);
      }
      if ($i + $roffset >= $zz2)
      {
        gotoxy($k, $j); addstr(substr($tempstr, $i + $roffset - $zz2, $zz2)); refresh;
      }
      elsif ($roffset < 0)
      {
        gotoxy($k, $j); addstr($tempstr . " ");
        gotoxy($k + length($tempstr) + $roffset, $j); refresh;
      }
      else
      {
        gotoxy(wherex() - 1, wherey()); addstr(" "); gotoxy(wherex() - 1, wherey()); refresh;
      }
      $thisword = substr($tempstr, 0, length($tempstr) + $roffset);
      $thisword = substr($thisword, rindex($thisword, " ") + 1);
    }
    elsif (ord($ch) eq 0)
    {
      if (keypressed())
      {
        $ch = kbuf();
        if (ord($ch) eq 72)
        {
          if ($bktype > 1 && $backtype[$bktype - 1] && $backtype[$bktype - 1] ne "")
          {
            $bktype--;
            $tempstr = $backtype[$bktype];
            $i = length($tempstr);
            $roffset = 0;
            gotoxy(1 + reallength($my[$thiswin]{'name'}) + 2, $maxy - 2); textcolor($colour{'scrollback'});
            addstr(strpadd("", $maxx - 20 - reallength($my[$thiswin]{'name'}), " "));
            gotoxy(1 + reallength($my[$thiswin]{'name'}) + 2, $maxy - 2); 
            if (length($tempstr) > $zz2)
            {
              addstr(substr($tempstr, length($tempstr) - $zz2, $zz2)); refresh;
            }
            else
            {
              addstr($tempstr); refresh;
            }
            $thisword = substr($tempstr, rindex($tempstr, " ") + 1);
          }
        }
        elsif (ord($ch) eq 80)
        {
          if ($bktype < 32)
          {
            $bktype++;
            $tempstr = $backtype[$bktype];
            $i = length($tempstr);
            $roffset = 0;
            gotoxy(1 + reallength($my[$thiswin]{'name'}) + 2, $maxy - 2); textcolor($colour{'scrollback'});
            addstr(strpadd("", $maxx - 20 - reallength($my[$thiswin]{'name'}), " "));
            gotoxy(1 + reallength($my[$thiswin]{'name'}) + 2, $maxy - 2); 
            if (length($tempstr) > $zz2)
            {
              addstr(substr($tempstr, length($tempstr) - $zz2, $zz2)); refresh;
            }
            else
            {
              addstr($tempstr); refresh;
            }
            $thisword = substr($tempstr, rindex($tempstr, " ") + 1);
          }
          elsif ($bktype eq 32)
          {
            addstr($maxy - 2, 1, strpadd("", $maxx - 20, " "));
#            gotoxy(1, $maxy - 2);
            return "";
          }
        }
        elsif (ord($ch) eq 75)
        {
          if (length($tempstr) + $roffset > 0)
          {
            $roffset--;
            $thisword = substr($tempstr, 0, length($tempstr) + $roffset);
            $thisword = substr($thisword, rindex($thisword, " ") + 1);
            if ($i + $roffset <= $zz2 && $roffset < 0)
            {
              gotoxy($k + length($tempstr) + $roffset, $j);
              refresh;
            }
          }
        }
        elsif (ord($ch) eq 77)
        {
          if ($roffset < 0)
          {
            $roffset++;
            $thisword = substr($tempstr, 0, length($tempstr) + $roffset);
            $thisword = substr($thisword, rindex($thisword, " ") + 1);
            if ($i + $roffset <= $zz2 && $roffset < 1)
            {
              gotoxy($k + length($tempstr) + $roffset, $j);
              refresh;
            }
          }
        }
      }
    }
    elsif (ord($ch) eq 9 && $thisword)
    {
      $tmpnick = FindUser($thiswin, 10, $thisword);
      if ($tmpnick) 
      {
        $tempstr = substr($tempstr, 0, - length($thisword)) . $tmpnick;
        $i = length($tempstr);
        addstr($maxy - 2, wherex() - length($thisword), $tmpnick);
        $thisword = $tmpnick;
        refresh;
      }
    }
    elsif ((ord($ch) > 31) && (ord($ch) ne 127) && ($i <= $zz3))
    {
      if ($roffset < 0)
      {
        $tempstr = substr($tempstr, 0, length($tempstr) + $roffset) . $ch . substr($tempstr, length($tempstr) + $roffset);
      }
      else
      {
        $tempstr = "$tempstr$ch";
      }
      $i++;
      if ($i + $roffset > $zz2)
      {
        gotoxy($k, $j);
        addstr(substr($tempstr, $i + $roffset - $zz2, $zz2)); refresh;
      }
      elsif ($roffset < 0)
      {
        gotoxy($k, $j);
        if ($i > $zz2)
        {
          addstr(substr($tempstr, 0, $zz2)); 
        }
        else
        {
          addstr($tempstr); 
        }
        gotoxy($k + length($tempstr) + $roffset, $j); refresh;
      }
      else
      {
        addstr($ch); refresh;
      }
      if ($ch eq " ")
      {
        $thisword = "";
      }
      else
      {
        if (! $thisword) { $thisword = $ch; } else { $thisword = $thisword . $ch; }
      }
    }
  }
  return $tempstr;
}

sub SaveSpace {
  if (uc(substr($ppp, 0, 10)) eq "/IRC JOIN ")
  {
    $ppp = "/JOIN " . substr($ppp, 10);
  }
  elsif (uc(substr($ppp, 0, 3)) eq "/J ")
  {
    $ppp = "/JOIN " . substr($ppp, 3);
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/MSG ")
  {
    $ppp = "/P " . substr($ppp, 5);
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/QUIT")
  {
    if ($window[$thiswin]->{protocol} ne 2)
    {
      $ppp = "/X";
    }
  }

  if (uc(substr($ppp, 0, 5)) eq "/ICQ ")
  {
    if ($window[$thiswin]{protocol} eq 1)
    {
      $ppp = ltrim(substr($ppp, 5));

      if (-r $config{'licq_usersconf'})
      {
        open(AFILE, $config{'licq_usersconf'});
        @LINES=<AFILE>;
        close(AFILE);
        $SIZE=@LINES;

        for ($i = 0; $i < $SIZE; $i++) 
        {
          if (substr($LINES[$i], 0, 10) eq "NumOfUsers")
          {
            $window[$thiswin]{users} = substr($LINES[$i], 13, -1);
          }
          elsif (substr($LINES[$i], 0, 4) eq "User")
          {
            $s1 = substr($LINES[$i], 4, -1);
            $s2 = substr($s1, 0, index($s1, " "));
            $s3 = substr($s1, index($s1, "=") + 2);

            $usr[$thiswin][$s2]{id} = $s3;

            $tmpuin = $config{'licq_basedir'} . "/users/$s3.uin";
            if (-r $tmpuin)
            {
              open(AFILE, $tmpuin);
              @BLINES=<AFILE>;
              close(AFILE);
              $BSIZE=@BLINES;

              for ($j = 0; $j < $BSIZE; $j++)
              {
                ($ss1, $ss2) = split(/=/, substr($BLINES[$j], 0, -1), 2);
                if ($ss1 && $ss1 eq "Alias ")
                {
                  $usr[$thiswin][$s2]{name} = substr($ss2, 1);
                }
              }
            }
            else
            {
              $usr[$thiswin][$s2]{name} = $s3;
            }
            $usr[$thiswin][$s2]{status} = 65535;
          }
        }
      }

#      AddLine($thiswin, "3499471 = " . FindUser($thiswin, 2, "3499471"));
      system("/usr/local/bin/licq -d 15 -c -o licq-parser &");

      local *OURICQFIFO;

      open(OURICQFIFO, "<licq-parser");

      $window[$thiswin]{handle} = *OURICQFIFO;
      $window[$thiswin]{control} = "15822774";
      $window[$thiswin]{channel} = "Server Messages";
      $window[$thiswin]{protocol} = 3;
      $window[$thiswin]{subprotocol} = "c"; # a = raw ICQ, b = Licq plugin, c = Dodgy Licq :)
    }
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/IRC ")
  {
    $ppp = ltrim(substr($ppp, 5));
    if (uc(substr($ppp, 0, 7)) eq "SERVER ")
    {
      $ppp = "CONNECT " . substr($ppp, 7);
    }

    if (uc(substr($ppp, 0, 8)) eq "CONNECT ")
    {
      if ($window[$thiswin]{protocol} eq 1)
      {
        $ppp = substr($ppp, 8);
        if (index($ppp, " ") > -1)
        {
          $ppp1 = substr($ppp, index($ppp, " ") + 1);
          $ppp = substr($ppp, 0, index($ppp, " "));
        }
        else
        {
          $ppp1 = 6667;
        }
        AddLine($thiswin, Lang(24) . "`%Connecting to `7" . $ppp);
        $ircconnections++;
        if ($ircconnections eq 1)
        {
          $andychat_irc = new Net::IRC;
          $andychat_irc->timeout(0.01);
        }
        if ($window[$thiswin]->{control} = $andychat_irc->newconn(Nick => $my[$thiswin]{'name'},
                                                Server => $ppp,
                                                Port => $ppp1,
                                                Ircname => $config{'ircname'} || 'AndyChat ' . $Version . " - http://andy.secret.com.au/"))
        {
          $window[$thiswin]->{protocol} = 2;
          $window[$thiswin]->{control}->add_global_handler(378, \&irc__on_motd);
          $window[$thiswin]->{control}->add_global_handler(377, \&irc__on_motd);
          $window[$thiswin]->{control}->add_global_handler(376, \&irc__on_connect);
          $window[$thiswin]->{control}->add_global_handler('disconnect', \&irc__on_disconnect);
          $window[$thiswin]->{control}->add_global_handler(375, \&irc__on_motd);
          $window[$thiswin]->{control}->add_global_handler(372, \&irc__on_motd);
          $window[$thiswin]->{control}->add_global_handler(353, \&irc__on_names);
          $window[$thiswin]->{control}->add_global_handler(255, \&irc__on_lusers);
          $window[$thiswin]->{control}->add_global_handler(254, \&irc__on_lusers);
          $window[$thiswin]->{control}->add_global_handler(253, \&irc__on_lusers);
          $window[$thiswin]->{control}->add_global_handler(252, \&irc__on_lusers);
          $window[$thiswin]->{control}->add_global_handler(251, \&irc__on_lusers);
          $window[$thiswin]->{control}->add_handler('join', \&irc__on_join);
          $window[$thiswin]->{control}->add_handler('quit', \&irc__on_quit);
          $window[$thiswin]->{control}->add_handler('nick', \&irc__on_nick);
          $window[$thiswin]->{control}->add_handler('nicknameinuse', \&irc__on_nicknameinuse);
          $window[$thiswin]->{control}->add_handler('erroneusnickname', \&irc__on_nicknameinuse);
          $window[$thiswin]->{control}->add_handler('nowaway', \&irc__on_awaytoggle);
          $window[$thiswin]->{control}->add_handler('unaway', \&irc__on_awaytoggle);
          $window[$thiswin]->{control}->add_handler('away', \&irc__on_away);
          $window[$thiswin]->{control}->add_handler('part', \&irc__on_part);
          $window[$thiswin]->{control}->add_handler('kick', \&irc__on_kick);
          $window[$thiswin]->{control}->add_handler('msg', \&irc__on_msg);
          $window[$thiswin]->{control}->add_handler('whoishelp', \&irc__on_whoishelp);
          $window[$thiswin]->{control}->add_handler('whoisuser', \&irc__on_whoisuser);
          $window[$thiswin]->{control}->add_handler('whoisserver', \&irc__on_whoisserver);
          $window[$thiswin]->{control}->add_handler('whoisoperator', \&irc__on_whoisoperator);
          $window[$thiswin]->{control}->add_handler('whoischanop', \&irc__on_whoischanop);
          $window[$thiswin]->{control}->add_handler('whoischannels', \&irc__on_whoischannels);
          $window[$thiswin]->{control}->add_handler('whoisidle', \&irc__on_whoisidle);
          $window[$thiswin]->{control}->add_handler('whoisvworld', \&irc__on_whoisvworld);
          $window[$thiswin]->{control}->add_handler('endofwhois', \&irc__on_endofwhois);
          $window[$thiswin]->{control}->add_handler('endofnames', \&irc__on_endofnames);
          $window[$thiswin]->{control}->add_handler('whoreply', \&irc__on_whoreply);
          $window[$thiswin]->{control}->add_handler('notice', \&irc__on_notice);
          $window[$thiswin]->{control}->add_handler('public', \&irc__on_public);
          $window[$thiswin]->{control}->add_handler('caction', \&irc__on_caction);
          $window[$thiswin]->{control}->add_handler('topic', \&irc__on_topic);
          $window[$thiswin]->{control}->add_handler('topicinfo', \&irc__on_topicinfo);
          $window[$thiswin]->{control}->add_handler('crfinger', \&irc__on_crfinger);
          $window[$thiswin]->{control}->add_handler('ctime', \&irc__on_ctime);
          $window[$thiswin]->{control}->add_handler('crtime', \&irc__on_crtime);
          $window[$thiswin]->{control}->add_handler('cversion', \&irc__on_cversion);
          $window[$thiswin]->{control}->add_handler('crversion', \&irc__on_crversion);
          $window[$thiswin]->{control}->add_handler('cping', \&irc__on_cping);
          $window[$thiswin]->{control}->add_handler('crping', \&irc__on_crping);
          $window[$thiswin]->{control}->add_handler('cpizza', \&irc__on_cpizza);
          $window[$thiswin]->{control}->add_handler('cnewpizza', \&irc__on_cnewpizza);
          $window[$thiswin]->{control}->add_handler('cunknown', \&irc__on_cunknown);
          $window[$thiswin]->{control}->add_handler('umode', \&irc__on_mode);
          $window[$thiswin]->{control}->add_handler('mode', \&irc__on_mode);
          $window[$thiswin]->{control}->add_handler('channelmodeis', \&irc__on_chanmodeis);
          $window[$thiswin]->{control}->add_handler('channelcreate', \&irc__on_channelcreate);
          $window[$thiswin]->{control}->add_handler('nosuchnick', \&irc__on_nosuchnick);
          $window[$thiswin]->{control}->add_handler('welcome', \&irc__on_motd);
          $window[$thiswin]->{control}->add_handler('yourhost', \&irc__on_motd);
          $window[$thiswin]->{control}->add_handler('created', \&irc__on_motd);
          $window[$thiswin]->{control}->add_handler('myinfo', \&irc__on_motd);
          $window[$thiswin]->{sortusers} = 1;
          $window[$thiswin]->{channel} = "Server Messages";
          $window[$thiswin]->{topic} = "irc://$ppp:$ppp1/";
#         $my[$thiswin]{id} = "irc";	# Hack!
          RedrawChanInfo();
          RedrawActivity();
          ReTitle("[Server Messages] irc://$ppp:$ppp1/");
        }
        else
        {
          $ircconnections--;
          AddLine($thiswin, "Could not connect to IRC server $ppp:$ppp1", Lang(16));
        }
      }
      else
      {
        AddLine($thiswin, "Already linked.. Do a /WINDOW NEW first, then /IRC SERVER.", Lang(16));
      }
    }
    else
    {
      AddLine($thiswin, "Command $ppp not found", Lang(16));
    }
  }
  elsif (uc(substr($ppp, 0, 8)) eq "/WINDOW ")
  {
    $ppp = ltrim(substr($ppp, 8));

    if (length($ppp) eq 1 && int($ppp) > 0 && $window[$ppp]{protocol} && $ppp ne $thiswin)
    {
      $lastwin = $thiswin;
      $thiswin = $ppp;
      ClearChatWindow($lastwin);
#      ClearAliasWindow($lastwin);
      RedrawNicks();
      RedrawLines();
      if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
      RedrawActivity();
      ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
    }
    elsif (substr(uc($ppp), 0, 3) eq "NEW")
    {
      ClearChatWindow($thiswin);
      $lastwin = $thiswin;
      $thiswin = newwindow();
      newWindowInit($thiswin, 1);
      RedrawNicks();
      if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
      RedrawActivity();
      ReTitle("[New Window]");
    }
    elsif (substr(uc($ppp), 0, 4) eq "KILL")
    {
      if ($thiswin > 1)
      {
        $lastwin = $window[$thiswin]{protocol};
        ClearChatWindow($thiswin, 1);
        if ($thiswin eq $windowcount) { $windowcount--; }
        newWindowInit($thiswin);
        while (! $window[$thiswin]{protocol})
        {
          $thiswin++;
          if ($thiswin > $windowcount) { $thiswin = 1; }
        }
        RedrawNicks();
        RedrawLines();
        if (($lastwin && $lastwin eq 2) || $window[$thiswin]{protocol} eq 2) { RedrawChanInfo(); }
        RedrawActivity();
        if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
        }
        elsif ($window[$thiswin]{channel})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "]");
        }
        else
        {
          ReTitle("[New Window]");
        }
      }
      else
      {
      }
    }
    elsif (substr(uc($ppp), 0, 4) eq "NEXT")
    {
      $lastwin = $thiswin;
      $thiswin++;
      if ($thiswin > $windowcount) { $thiswin = 1; }
      while (! $window[$thiswin]{protocol})
      {
        $thiswin++;
        if ($thiswin > $windowcount) { $thiswin = 1; }
      }
      if ($thiswin ne $lastwin)
      {
        ClearChatWindow($lastwin);
#        ClearAliasWindow($lastwin);
        RedrawNicks();
        RedrawLines();
        if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
        RedrawActivity();
        if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
        }
        elsif ($window[$thiswin]{channel})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "]");
        }
        else
        {
          ReTitle("[New Window]");
        }
      }
    }
    elsif (substr(uc($ppp), 0, 4) eq "PREV")
    {
      $lastwin = $thiswin;
      $thiswin--;
      if ($thiswin < 1) { $thiswin = $windowcount; }
      while (! $window[$thiswin]{protocol})
      {
        $thiswin--;
        if ($thiswin < 1) { $thiswin = $windowcount; }
      }
      if ($thiswin ne $lastwin)
      {
        ClearChatWindow($lastwin);
#        ClearAliasWindow($lastwin);
        RedrawNicks();
        RedrawLines();
        if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
        RedrawActivity();
        if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
        }
        elsif ($window[$thiswin]{channel})
        {
          ReTitle("[" . $window[$thiswin]{channel} . "]");
        }
        else
        {
          ReTitle("[New Window]");
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/NICK")
  {
    if (uc($ppp) eq "/NICK")
    {
      if ($window[$whichwin]->{protocol} eq 2)
      {
# Early Implementation :)
#        irc__names($window[$thiswin]->{control}, $window[$thiswin]->{channel});
      }
    }
    elsif (substr($ppp, 5, 1) eq " ")
    {
      $ppp = Strrrp(substr($ppp, 6));
      if (length($ppp) > 12)
      {
        AddLine($thiswin, Lang(16) . Lang(18));
        $ppp = substr($ppp, 0, 12);
      }
      if (FindUser($thiswin, 1, $ppp))
      {
        AddLine($thiswin, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `%$ppp `7is already in use");
      }
      elsif ($window[$thiswin]{protocol} eq 1)
      {
        $my[$thiswin]{name} = $ppp;
      }
      else
      {
        if ($window[$thiswin]->{protocol} eq 2)
        {
          if ($my[$thiswin]{name} eq "*")
          {
            $my[$thiswin]{name} = $ppp;
            RedrawChanInfo();
          }
          irc__nick($window[$thiswin]->{control}, $ppp);
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/PIZZA")
  {
    if (! $window[$thiswin]{pizzahost})
    {
      AddLine($thiswin, Lang(24) . Lang(21));
      $window[$thiswin]{pizzahost} = $my[$thiswin]{id};

      if ($window[$thiswin]{protocol} eq 2)
      {
        if ($window[$thiswin]{channel} ne "")
        {
          irc__ctcp($window[$thiswin]{control}, $window[$thiswin]{channel}, "PIZZA");
        }
      }
    }
    elsif ($window[$thiswin]{pizzahost} eq $my[$thiswin]{id})
    {
      AddLine($thiswin, Lang(24) . Lang(22));
      $window[$thiswin]{pizzahost} = "";
      if ($window[$thiswin]{protocol} eq 2)
      {
        if ($window[$thiswin]{channel} ne "")
        {
          irc__ctcp($window[$thiswin]{control}, $window[$thiswin]{channel}, "PIZZA");
        }
      }
    }
    else
    {
      $tmpnum = FindUser($thiswin, 2, $window[$thiswin]{pizzahost});
      if ($tmpnum)
      {
        AddLine($thiswin, $usr[$thiswin][$tmpnum]{name} . Lang(23), Lang(16));
      }
    }
  }
  elsif (uc(substr($ppp, 0, 4)) eq "/INV")
  {
    if ($window[$thiswin]->{protocol} eq 1) # ??
    {
      if ($my[$thiswin]{invis})
      {
        $my[$thiswin]{invis} = "";
        AddLine($thiswin, Lang(25), Lang(24));
      }
      else
      {
        $my[$thiswin]{invis} = 1;
        AddLine($thiswin, Lang(26));
      }
    }
    elsif ($window[$thiswin]{protocol} eq 2)
    {
      if ($my[$thiswin]{modes})
      {
        if (index($my[$thiswin]{modes}, "i") > -1)
        {
          irc__mode($window[$thiswin]{control}, $my[$thiswin]{name}, "-i");
        }
        else
        {
          irc__mode($window[$thiswin]{control}, $my[$thiswin]{name}, "+i");
        }
      }
      else
      {
        irc__mode($window[$thiswin]{control}, $my[$thiswin]{name}, "+i");
      }
    }
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/AWAY")
  {
    if ($window[$thiswin]{protocol} eq 2)
    {
      if (uc($ppp) eq "/AWAY")
      {
        irc__away($window[$thiswin]->{control});
      }
      elsif (substr($ppp, 5, 1) eq " ")
      {
        irc__away($window[$thiswin]->{control}, substr($ppp, 6));
      }
    }
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/QUIT")
  {
    if (index($ppp, " ") > -1)
    {
      irc__quit($window[$thiswin]->{control}, substr($ppp, index($ppp, " ") + 1));
    }
    else
    {
      irc__quit($window[$thiswin]->{control});
    }
  }
  elsif (uc($ppp) eq "/X")
  {
    $ppp = "X NOW";
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/HELP ")
  {
    TraceHelpOn(substr($ppp, 6));
  }
  elsif (uc($ppp) eq "/CANCEL")
  {
    if ($my[$thiswin]{pizza})
    {
      $my[$thiswin]{pizza} = "";
      AddLine($thiswin, Lang(95), Lang(96));
      if ($window[$thiswin]{pizzahost} eq $my[$thiswin]{id})
      {
        # Insert Pizza Removal Code Here !!xxxxxxnorder
        $tmpnum = FindUser($thiswin, 2, $my[$thiswin]{id});
        $usr[$thiswin][$tmpnum]{pizza} = "";
        $my[$thiswin]{pizza} = "";
      }
      elsif ($window[$thiswin]{protocol} eq 2)
      {
        $tmpnum = FindUser($thiswin, 2, $window[$thiswin]{pizzahost});
        irc__ctcp($window[$thiswin]{control}, $usr[$thiswin][$tmpnum]{name}, "NORDER");
      }
    }
    else
    {
      AddLine($thiswin, Lang(94), Lang(16));
    }
  }
  elsif (uc(substr($ppp, 0, 10)) eq "/BUYPIZZA ")
  {
    $ppp = int(substr($ppp, 10));
    if (! $window[$thiswin]{pizzahost})
    {
      AddLine($thiswin, Lang(98), Lang(16));
    }
    else
    {
      if ($ppp > 0 && $ppp <= $window[$thiswin]{pizzas})
      {
        if ($my[$thiswin]{pizza})
        {
          AddLine($thiswin, Lang(93), Lang(16));
        }
        else
        {
          AddLine($thiswin, Lang(97) . $pizza[$thiswin][$ppp]{topping}, Lang(96));

          $my[$thiswin]{pizza} = $ppp;
          if ($window[$thiswin]{pizzahost} eq $my[$thiswin]{id})
          {
            # Insert Pizza Buy Code Here !!xxxxxxorder[n]
          }
          elsif ($window[$thiswin]{protocol} eq 2)
          {
            $tmpnum = FindUser($thiswin, 2, $window[$thiswin]{pizzahost});
            irc__ctcp($window[$thiswin]{control}, $usr[$thiswin][$tmpnum]{name}, "ORDER " . $ppp);
          }
        }
      }
      else
      {
        AddLine($thiswin, Lang(92), Lang(16));
      }
    }
  }
  elsif (uc(substr($ppp, 0, 11)) eq "/SELLPIZZA ")
  {
    if (! $window[$thiswin]{pizzahost})
    {
      AddLine($thiswin, Lang(98), Lang(16));
    }
    else
    {
      if ($window[$thiswin]{pizzahost} ne $my[$thiswin]{id})
      {
        AddLine($thiswin, Lang(99), Lang(16));
      }
      else
      {
        if ($window[$thiswin]{pizzas} && $window[$thiswin]{pizzas} >= 20)
        {
          AddLine($thiswin, Lang(100), Lang(16));
        }
        else
        {
          $ppp = substr($ppp, 11);
          if (index($ppp, " ") > -1)
          {
            $str1 = strpadd("", 4 - index($ppp, " "), "0") . substr($ppp, 0, index($ppp, " "));
            $ppp = substr($ppp, index($ppp, " ") + 1);
            $ppp =~ s/\|/\//go;
            if ($window[$thiswin]{pizzas}) { $window[$thiswin]{pizzas}++; } else { $window[$thiswin]{pizzas} = 1; }
            $pizza[$thiswin][$window[$thiswin]{pizzas}]{topping} = $ppp;
            $pizza[$thiswin][$window[$thiswin]{pizzas}]{price} = $str1;
            AddLine($thiswin, Lang(101), Lang(96));
            AddLine($thiswin, Lang(96) . "`%" . $ppp . " `7for only `%\$" . mmoney(int($str1) / 100) . "`7");
            if ($leftwindow eq 9) { DrawLeft(9); }
            if ($window[$thiswin]{protocol} eq 2 && $window[$thiswin]{channel})
            {
              irc__ctcp($window[$thiswin]->{control}, $window[$thiswin]{channel}, "NEWPIZZA " . $str1 . " " . $ppp);
            }
          }
          else
          {
            AddLine($thiswin, "Usage: /SELLPIZZA COST Topping");
            AddLine($thiswin, "Example: /SELLPIZZA 0850 Hawaiian");
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 11)) eq "/KILLPIZZA ")
  {
    $ppp = ltrim(substr($ppp, 11));
    if (! $window[$thiswin]{pizzahost})
    {
      AddLine($thiswin, Lang(98), Lang(16));
    }
    else
    {
      if ($window[$thiswin]{pizzahost} ne $my[$thiswin]{id})
      {
        AddLine($thiswin, Lang(99), Lang(16));
      }
      else
      {
        if (! $window[$thiswin]{pizzas} || int($ppp) < $window[$thiswin]{pizzas})
        {
          AddLine($thiswin, Lang(92), Lang(16));
        }
        else
        {
          # Insert Pizza Kill Code Here !!xxxxxxkillpizza[nn]
          if ($window[$thiswin]{protocol} eq 2 && $window[$thiswin]{channel})
          {
            irc__ctcp($window[$thiswin]->{control}, $window[$thiswin]{channel}, "KILLPIZZA " . $ppp);
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/JOIN ")
  {
    if ($window[$thiswin]->{protocol} eq 2)
    {
     $ppp = ltrim(substr($ppp, 6));
     $tmpchannels = 0; $tmpchannel = $ppp;
     
     if (substr($ppp, 0, 1) ne "#" && substr($ppp, 0, 1) ne "&")
     {
       AddLine($thiswin, "$ppp is not a channel.", Lang(16));
     }
     else
     {
      foreachcontrol($window[$thiswin]{control}, 2, \&irc__inroom);
      if ($tmpchannels > 0)
      {
        AddLine($thiswin, "Already in channel $ppp", Lang(16));
      }
      elsif (! $window[$thiswin]->{channel})
      {
        irc__join($window[$thiswin]{control}, $ppp);
        $window[$thiswin]->{channel} = $ppp;
#        AddLine($thiswin, Lang(24) . "`%Joining `7" . $ppp);
      }
      else
      {
        $lastwin = $thiswin;
        ClearChatWindow($thiswin);
        $thiswin = newwindow();
        newWindowInit($thiswin, 2);
        RedrawNicks();
        $window[$thiswin]{control} = $window[$lastwin]{control};
        $window[$thiswin]{sortusers} = 1;
        NewMy($thiswin, $lastwin);
        irc__join($window[$thiswin]{control}, $ppp);
        $window[$thiswin]->{channel} = $ppp;
        ReTitle("[" . $window[$thiswin]{channel} . "] Joining...");
        RedrawChanInfo();
        RedrawActivity();
#        AddLine($thiswin, "This window is already linked to a channel!", Lang(16));
      }
      undef $tmpchannels;
     }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/PART ")
  {
    if ($window[$thiswin]->{protocol} eq 2)
    {
      $ppp = ltrim(substr($ppp, 6));
      if (index($ppp, " ") > -1)
      {
        $data = substr($ppp, index($ppp, " ") + 1);
        $ppp = substr($ppp, 0, index($ppp, " "));
      }
      else
      {
        $data = "";
      }
      if (uc($ppp) eq uc($window[$thiswin]{channel}))
      {
        irc__part($window[$thiswin]{control}, $ppp, $data);
      }
    }
  }
  elsif (uc($ppp) eq "/CLS" || uc($ppp) eq "/CLEAR")
  {
    ClearChatWindow($thiswin, 1);
  }
  elsif (uc(substr($ppp, 0, 4)) eq "/ME ")
  {
    if ($window[$thiswin]->{protocol} eq 2)
    {
      if ($window[$thiswin]->{query})
      {
        irc__action($window[$thiswin]->{control}, $window[$thiswin]->{query}, substr($ppp, 4));
        AddLine($thiswin, substr($ppp, 4), "`8" . chr(ACS_S1) . " `!" . $my[$thiswin]{'name'} . " `7");
      }
      elsif ($window[$thiswin]->{channel})
      {
        irc__action($window[$thiswin]->{control}, $window[$thiswin]->{channel}, substr($ppp, 4));
        AddLine($thiswin, substr($ppp, 4), "`8" . chr(ACS_S1) . " `%" . $my[$thiswin]{'name'} . " `7");
      }
      else
      {
      }
    }
  }
#  elsif (uc(substr($ppp, 0, 10)) eq "/PLAYFILE ")
#  {
#    $ppp = substr($ppp, 10);
#    if (! -r $ppp)
#    {
#      AddLine($thiswin, Lang(103) . $ppp, Lang(16));
#    }
#    elsif ($window[$thiswin]{channel} ne "")
#    {
#      open(PFI, $ppp);
#      @pfit = <PFI>;
#      close(PFI);
#      $pfis = @pfit;
#
#      for ($i = 0; $i < $pfis; $i++)
#      {
#        while (substr($pfit[$i], -1, 1) eq chr(10) || substr($pfit[$i], -1, 1) eq chr(13))
#        {
#          $pfit[$i] = substr($pfit[$i], 0, -1);
#        }
#      }
#      $pfin = 0;
#      $pfic = $thiswin;
#      $playfile = 1;
#      $pfi11 = time() + 10;
#      $astr = Lang(104) . $ppp . " in 10 seconds";
#      irc__action($window[$pfic]{control}, $window[$pfic]{channel}, $astr);
#      AddLine($thiswin, $astr, "`8" . chr(ACS_S1) . " `%" . $my[$thiswin]{'name'} . " `7"); $astr = "";
#      $afterinpu = 1;
#    }
#  }
#  elsif (uc(substr($ppp, 0, 9)) eq "/STOPFILE")
#  {
#    if ($playfile)
#    {
#      undef $playfile;
#      irc__action($window[$pfic]{control}, $window[$pfic]{channel}, Lang(105));
#      AddLine($thiswin, Lang(105), "`8" . chr(ACS_S1) . " `%" . $my[$thiswin]{'name'} . " `7");
#      $pfin = 0;
#      $pfic = "";
#      $afterinpu = 1;
#    }
#  }
  elsif (uc(substr($ppp, 0, 4)) eq "/OP ")
  {
    $ppp = ltrim(substr($ppp, 4));
    if ($window[$thiswin]->{protocol} eq 1)
    {
#      if (length($ppp) > 40) { $ppp = substr($ppp, 0, 40); }
    }
    elsif ($window[$thiswin]->{protocol} eq 2)
    {
      if (substr($ppp, 0, 1) eq "#" || substr($ppp, 0, 1) eq "&")
      {
        if (index($ppp, " ") > -1)
        {
          $tmpchannel = substr($ppp, 0, index($ppp, " "));
          $ppp = ltrim(substr($ppp, index($ppp, " ") + 1));
        }
        else
        {
          $tmpchannel = $ppp;
          $ppp = "";
        }
      }
      else
      {
        $tmpchannel = $window[$thiswin]{channel};
      }

      $tmpwho = $ppp;

      if ($tmpchannel)
      {
        $whichwin = whichcontrol($window[$thiswin]{control}, 2, $tmpchannel);   # Hack!  Fixme!!! FIX ME!!!
        if (! $my[$whichwin]{op})
        {
          AddLine($whichwin, "TEMP: You are not an operator on channel $tmpchannel.", Lang(16));
        }
        else
        {
          $tmpnum = FindUser($whichwin, 1, $tmpwho);
          if ($tmpnum)
          {
            if ($usr[$whichwin][$tmpnum]{op})
            {
              AddLine($whichwin, "TEMP: User is already an op.", Lang(16));
            }
            else
            {
              irc__mode($window[$whichwin]{control}, $tmpchannel, "+o $tmpwho");
            }
          }
          else
          {
            AddLine($whichwin, "TEMP: Could not find $tmpwho on $tmpchannel", Lang(16));
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 5)) eq "/DOP ")
  {
    $ppp = ltrim(substr($ppp, 5));
    if ($window[$thiswin]->{protocol} eq 1)
    {
#      if (length($ppp) > 40) { $ppp = substr($ppp, 0, 40); }
    }
    elsif ($window[$thiswin]->{protocol} eq 2)
    {
      if (substr($ppp, 0, 1) eq "#" || substr($ppp, 0, 1) eq "&")
      {
        if (index($ppp, " ") > -1)
        {
          $tmpchannel = substr($ppp, 0, index($ppp, " "));
          $ppp = ltrim(substr($ppp, index($ppp, " ") + 1));
        }
        else
        {
          $tmpchannel = $ppp;
          $ppp = "";
        }
      }
      else
      {
        $tmpchannel = $window[$thiswin]{channel};
      }

      $tmpwho = $ppp;

      if ($tmpchannel)
      {
        $whichwin = whichcontrol($window[$thiswin]{control}, 2, $tmpchannel);   # Hack!  Fixme!!! FIX ME!!!
        if (! $my[$whichwin]{op})
        {
          AddLine($whichwin, "TEMP: You are not an operator on channel $tmpchannel.", Lang(16));
        }
        else
        {
          $tmpnum = FindUser($whichwin, 1, $tmpwho);
          if ($tmpnum)
          {
            if (! $usr[$whichwin][$tmpnum]{op})
            {
              AddLine($whichwin, "TEMP: User is not an op.", Lang(16));
            }
            else
            {
              irc__mode($window[$whichwin]{control}, $tmpchannel, "-o $tmpwho");
            }
          }
          else
          {
            AddLine($whichwin, "TEMP: Could not find $tmpwho on $tmpchannel", Lang(16));
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 7)) eq "/TOPIC ")
  {
    $ppp = ltrim(substr($ppp, 7));
    if ($window[$thiswin]->{protocol} eq 1)
    {
      if (length($ppp) > 40) { $ppp = substr($ppp, 0, 40); }
    }
    elsif ($window[$thiswin]->{protocol} eq 2)
    {
      if (substr($ppp, 0, 1) eq "#" || substr($ppp, 0, 1) eq "&")
      {
        if (index($ppp, " ") > -1)
        {
          $tmpchannel = substr($ppp, 0, index($ppp, " "));
          $ppp = substr($ppp, index($ppp, " ") + 1);
        }
        else
        {
          $tmpchannel = $ppp;
          $ppp = "";
        }
      }
      else
      {
        $tmpchannel = $window[$thiswin]{channel};
      }

      if ($tmpchannel)
      {
#        if (! $my[$thiswin]{op} && index($modes[$thiswin], "t") > -1)
#        {
          irc__topic($window[$thiswin]->{control}, $tmpchannel, $ppp);
#        } # This should not say thiswin, fixme!
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/KICK ")
  {
    $ppp = ltrim(substr($ppp, 6));
    if ($window[$thiswin]->{protocol} eq 1)
    {
#      if (length($ppp) > 40) { $ppp = substr($ppp, 0, 40); }
    }
    elsif ($window[$thiswin]->{protocol} eq 2)
    {
      if (substr($ppp, 0, 1) eq "#" || substr($ppp, 0, 1) eq "&")
      {
        if (index($ppp, " ") > -1)
        {
          $tmpchannel = substr($ppp, 0, index($ppp, " "));
          $ppp = ltrim(substr($ppp, index($ppp, " ") + 1));
        }
        else
        {
          $tmpchannel = "";
          $ppp = "";
          # Die here because of no params.  -- Hack
        }
      }
      else
      {
        $tmpchannel = $window[$thiswin]{channel};
      }

      if (index($ppp, " ") > -1)
      {
        $tmpwho = substr($ppp, 0, index($ppp, " "));
        $ppp = substr($ppp, index($ppp, " ") + 1);
      }
      elsif ($ppp)
      {
        $tmpwho = $ppp;
        $ppp = "";
      }

      if ($tmpchannel)
      {
        $whichwin = whichcontrol($window[$thiswin]{control}, 2, $tmpchannel);   # Hack!  Fixme!!! FIX ME!!!
        if (! $my[$whichwin]{op})
        {
          AddLine($whichwin, "TEMP: You are not an operator on channel $tmpchannel.", Lang(16));
        }
        else
        {
          if (FindUser($whichwin, 1, $tmpwho))
          {
            irc__kick($window[$whichwin]{control}, $tmpchannel, $tmpwho, $ppp);
          }
          else
          {
            AddLine($whichwin, "TEMP: Could not find u/$tmpwho c/$tmpchannel", Lang(16));
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/QUERY")
  {
    if ($window[$thiswin]{protocol} eq 2)
    {
      if (length($ppp) eq 6)
      {
        if ($window[$thiswin]{query})
        {
          AddLine($thiswin, "Ending conversation with " . $window[$thiswin]{query}, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
          $window[$thiswin]{query} = "";
          RedrawChanInfo();
        }
      }
      elsif (substr($ppp, 6, 1) eq " ")
      {
        if ($window[$thiswin]{query})
        {
          AddLine($thiswin, "Ending conversation with " . $window[$thiswin]{query}, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
          $window[$thiswin]{query} = "";
          RedrawChanInfo();
        }
        $ppp = ltrim(substr($ppp, 7));
        if (index($ppp, " ") > -1)
        {
          $ppp = substr($ppp, 0, index($ppp, " "));
        }
        $window[$thiswin]{query} = $ppp;
        AddLine($thiswin, "Starting conversation with " . $window[$thiswin]{query}, "`@" . chr(183) . "`%" . chr(ACS_DEGREE) . "`@" . chr(183) . " `7");
        RedrawChanInfo();
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/CTCP ")
  {
    if ($window[$thiswin]->{protocol} eq 2)
    {
      $ppp = substr($ppp, 6);

      if (index($ppp, " ") > -1)
      {
        irc__ctcp($window[$thiswin]->{control}, substr($ppp, 0, index($ppp, " ")), substr($ppp, index($ppp, " ") + 1));
        AddLine($thiswin, substr($ppp, index($ppp, " ") + 1), "`8[`4ctcp`8(`@" . substr($ppp, 0, index($ppp, " ")) . "`8)] `7");
      }
    }
  }
  elsif (uc(substr($ppp, 0, 7)) eq "/QUOTE ")
  {
    if ($window[$thiswin]->{protocol} eq 2)
    {
      $ppp = substr($ppp, 7);
# Early Implementation :)
#      irc__raw($window[$thiswin]->{control}, $ppp);
    }
  }
  elsif (uc(substr($ppp, 0, 13)) eq "/REDRAWSCREEN")
  {
    DrawMainScreen("");
  }
  elsif (uc(substr($ppp, 0, 12)) eq "/REDRAWNICKS")
  {
    RedrawNicks();
  }
  elsif (uc(substr($ppp, 0, 3)) eq "/P ")
  {
    $ppp = substr($ppp, 3);
    if (index($ppp, " ") > -1)
    {
      if ($window[$thiswin]->{protocol} eq 2)
      {
        irc__privmsg($window[$thiswin]->{control}, substr($ppp, 0, index($ppp, " ")), substr($ppp, index($ppp, " ") + 1));
        AddLine($thiswin, substr($ppp, index($ppp, " ") + 1), "`8[`4msg`8(`@" . DoubleQuote(substr($ppp, 0, index($ppp, " "))) . "`8)] `7");
      }
      elsif ($window[$thiswin]{protocol} eq 3)
      {
        if ($window[$thiswin]{subprotocol} eq "c")
        {
          if (index($ppp, " ") < 0)
          {
            AddLine($thiswin, "ERR: No message specified");
          }
          else
          {
            $tmpuin = substr($ppp, 0, index($ppp, " "));
            if (int($tmpuin) < 10000 || int($tmpuin) > 100000000)
            {
              AddLine($thiswin, "ERR: Invalid UIN specified");
            }
            else
            {
              icq__licqfifo__msg($window[$thiswin]{control}, $tmpuin, substr($ppp, index($ppp, " ") + 1));
            }
          }
        }
      }
    }
  }
  elsif (uc(substr($ppp, 0, 6)) eq "/PING ")
  {
    $ppp = ltrim(substr($ppp, 6));
    if ($window[$thiswin]->{protocol} eq 2)
    {
      irc__ctcp($window[$thiswin]{control}, $ppp, "PING " . time());
      AddLine($thiswin, "PING", "`8[`4ctcp`8(`@" . DoubleQuote($ppp) . "`8)] `7");
    }
  }
  elsif (uc(substr($ppp, 0, 8)) eq "/NOTICE ")
  {
    $ppp = substr($ppp, 8);
    if (index($ppp, " ") > -1)
    {
      if ($window[$thiswin]->{protocol} eq 2)
      {
        irc__notice($window[$thiswin]->{control}, substr($ppp, 0, index($ppp, " ")), substr($ppp, index($ppp, " ") + 1));
        AddLine($thiswin, substr($ppp, index($ppp, " ") + 1), "`8[`4notice`8(`@" . DoubleQuote(substr($ppp, 0, index($ppp, " "))) . "`8)] `7");
      }
    }
  }
  elsif (uc(substr($ppp, 0, 7)) eq "/WHOIS ")
  {
    $ppp = substr($ppp, 7);
    if ($window[$thiswin]->{protocol} eq 2)
    {
      irc__whois($window[$thiswin]->{control}, $ppp);
    }
  }
  else
  {
    AddLine($thiswin, "Command $ppp not found", Lang(16));
  }
}

# SUBS END HERE

# VAR HACKS START HERE

$carrnum = "001";

# VAR HACKS END HERE

print "\nAndyCHAT XXX $Version - Do Not Distribute! Unless at Aardy''s Network Games!\n";
print "Written by Andrew Macks (Andypoo) for Private and Network Games Use Only!\n";

#sleep 50;

$mainwin = initscr();
getmaxyx($mainwin, $maxy, $maxx);

$channelwin = subwin($maxy - 5, $maxx - 17, 2, 1); scrollok($channelwin, 1);
$userboxwin = subwin($maxy - 5, 14, 2, $maxx - 14);

start_color();

textcolor(15); textbackground(4);
addstr(0, 0, " AndyChat for IRC v$Version -=- Build " . $Build . " -=- (c) 1997 to 2000 Andypoo''s Software");
addstr(SPACEs($maxx - wherex()));
gotoxy(0, 1);
textbackground(0);
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Starting Engine ... "); refresh;
textcolor(10); addstr("Complete\n"); refresh;
$config{'invis'} = ""; $logging = ""; $addbuffer = ""; $locas = "";
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Reading Configuration File ... "); refresh;
ReadConfig();
textcolor(10); addstr("Complete\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Searching for IPX Packet Driver ... "); refresh;
textcolor(12); addstr("Fail"); textcolor(7); addstr(" because we don't use it anymore\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Opening Network Socket ... "); refresh;
textcolor(12); addstr("Fail"); textcolor(7); addstr(" because there isn't any network code\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Resetting Variables ... "); refresh;
for ($i = 1; $i <= 40; $i++) { $mess[$i] = ""; }
$wherescr = 2; $scrdir = 1;
$messwaiting = 0;
$pagesswaiting = 22;
$pingtime = 0; $ircconnections = 0;
$leftwindow = 4; $windowcount = 1; $lusers = 0; newWindowInit($thiswin, 1); $window[$thiswin]{topic} = "Lobby";
$cpagess = ""; $ltime = ""; $ldate = ""; $ppp = ""; $getmes = ""; $s = ""; $timeto_update = 0;
textcolor(10); addstr("Complete\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Parsing Command-line Parameters ... "); refresh;
if (index("@ARGV", "/NOF") < 0) { $nofade = ""; } else { $nofade = 1; }
if (index("@ARGV", "/NOSO") < 0) { $soundoff = ""; } else { $soundoff = 1; }
if (index("@ARGV", "/NOSC") < 0) { $scrolloff = ""; } else { $scrolloff = 1; }
if (index("@ARGV", "DEBUG") < 0) { $debug = ""; } else { $debug = 1; }
textcolor(10); addstr("Complete\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Initializing Network Packets ... "); refresh;
textcolor(12); addstr("Fail"); textcolor(7); addstr(" -- see above\n"); refresh;
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" Searching for other users\n"); refresh;
#textcolor(12); addstr("Fail"); textcolor(7); addstr(" -- see above\n"); refresh;
#textcolor(11); addch(
$amserver = 1;

sleep 1;	# This is only temporary, obviously

if ($amserver)
{
  textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" No other users present.\n"); refresh;
}
textcolor(15); addch(ACS_DIAMOND); textcolor(7); addstr(" " . Lang(4));

$progname = "`2A`0ndy`2C`0hat `6v`\$3`6.`\$0`\@b";
$onlinenum = int($carrnum);
if ($config{'name'} eq "") { $config{'name'} = "USER$carrnum"; }
# $tmpusr{'name'} = $config{'name'};
# if (finduser(@tmpusr, 1) > 0)
# {
#   while(findusr(@tmpusr, 1) > 0)
#   {
#     $k = int(rand(9999)) + 1;
#     $tmpusr{'name'} = "USER" . strpadd("", 4 - length($k), "0") . $k;
#   }
#   $config{'name'} = $tmpusr{'name'};
# }

$config{'number'} = strpadd("", 3 - length($onlinenum), "0") . $onlinenum;

$tnum = int($onlinenum);

while ($tnum > 14) {
  $tnum = $tnum - 14;
}

clear;
DrawMainScreen();
textcolor($colour{'topline'});
addstr(0, 0, " You are user number ");
textcolor(15);
addstr(wherey(), wherex(), $onlinenum);
textcolor($colour{'topline'});
addstr(wherey(), wherex(), " and your alias is ");
textcolor($tnum);
addstr(wherey(), wherex(), $config{'name'});
textcolor($colour{'topline'});
addstr(wherey(), wherex(), ".  ");
addstr(SPACEs($maxx - wherex()));

refresh;

if (index(uc("@ARGV"), "/NOI") < 0)
{
  DrawLogo($config{'name'});
  textcolor(7);
  ScrollText("Press Any Key to actually start chatting away, not just any key tho, because this key will appear in your buffer.  So make it a good one!  ", $maxx - 15, $maxy - 2, 14, 0.1);
  gotoxy($maxx - 15, $maxy - 2);  LordWrite($progname);
  for ($j = 1; $j <= 8; $j++)
  {
    addstr($j + 3, 2 + $loceoff, SPACEs(57));
  }
  addstr(13, 2 + $loceoff, SPACEs(57));

  refresh();
}

if ($config{room})
{
  $window[$thiswin]{channel} = $config{room};
  if ($window[$thiswin]{topic} ne "")
  {
    ReTitle("[" . $config{room} . "] " . $window[$thiswin]{'topic'});
  }
  else
  {
    ReTitle("[" . $config{room} . "]");
  }
}
else
{
  ReTitle("[New Window]");
}

textcolor($colour{'topline'});
addstr(0, 0, " AndyChat v3.00 Build " .  $Build . " -=- (c) Copyright 1997-2000 by Andypoo's Software!");
addstr(SPACEs($maxx - wherex()));

gotoxy(1, $maxy - 2);
refresh();

gotoxy($channelwin, 0, $maxy - 6);
refresh($channelwin);

%tmpusr = %me;
$tmpusr{'name'} = "`" . colline($tnum) . $config{'name'};

# AddUser(@tmpusr, $tmpusr{'number'});

while ((uc($ppp) ne "X NOW") && ($getmes ne "allquit"))
{
  if ($locas ne "")		# Check server commands from self --> self
  {
    if ($messwaiting < 20)
    {
      $messwaiting++;
#      UpdateGame(5);
      $mess[$messwaiting] = $locas;
    }
    else
    {
      for ($t = 1; $t <= 19; $t++)
      {
        $mess[$t] = $mess[$t + 1];
      }
      $mess[20] = $locas;
    }
    $locas = "";
    gotoxy(1, $maxy - 2);
  }

  if (keypressed())
  {
    $ppp = ""; $astr = ""; $bktype = 33;
    $astr = kbuf();
    if ($astr eq chr(27))
    {
      $astr = ""; while (keypressed()) { $astr = $astr . kbuf(); }
#      AddLine($thiswin, "[ESC] $astr");
      if (substr($astr, 0, 2) eq "[A")			# Arrow Up
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        if ($backtype[32])
        {
          $astr = $backtype[32]; $bktype = 32;
        }
        else
        {
          $astr = "";
        }
      }
      elsif (substr($astr, 0, 2) eq "[B")		# Arrow Down
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "[C")		# Arrow Right
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        $lastwin = $thiswin;
        $thiswin++;
        if ($thiswin > $windowcount) { $thiswin = 1; }
        while (! $window[$thiswin]{protocol})
        {
          $thiswin++;
          if ($thiswin > $windowcount) { $thiswin = 1; }
        }
        if ($thiswin ne $lastwin)
        {
          ClearChatWindow($lastwin);
#          ClearAliasWindow($lastwin);
          RedrawNicks();
          RedrawLines();
          if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
          RedrawActivity();
          if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          elsif ($window[$thiswin]{channel})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
          else
          {
            ReTitle("[New Window]");
          }
        }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "[D")		# Arrow Left
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        $lastwin = $thiswin;
        $thiswin--;
        if ($thiswin < 1) { $thiswin = $windowcount; }
        while (! $window[$thiswin]{protocol})
        {
          $thiswin--;
          if ($thiswin < 1) { $thiswin = $windowcount; }
        }
        if ($thiswin ne $lastwin)
        {
          ClearChatWindow($lastwin);
#          ClearAliasWindow($lastwin);
          RedrawNicks();
          RedrawLines();
          if ($window[$lastwin]{protocol} && ($window[$lastwin]{protocol} eq 2 || $window[$thiswin]{protocol} eq 2)) { RedrawChanInfo(); }
          RedrawActivity();
          if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          elsif ($window[$thiswin]{channel})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
          else
          {
            ReTitle("[New Window]");
          }
        }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[1~")		# Home
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[2~")		# Insert
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[3~")		# Delete
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[4~")		# End
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($window[$thiswin]{scrollback})
        {
          $window[$thiswin]{scrollback} = "";
          $window[$thiswin]{unseen} = "";
          RedrawLines();
          RedrawChanInfo();
        }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[5~")		# PgUp
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($window[$thiswin]{scrollback})
        {
          if ($chline[$thiswin][$maxy - 5 + $window[$thiswin]{scrollback}])
          {
            $window[$thiswin]{scrollback} = $window[$thiswin]{scrollback} + 10;
            RedrawLines();
            RedrawChanInfo();
          }
        }
        else
        {
          if ($chline[$thiswin][$maxy - 5])
          {
            $window[$thiswin]{scrollback} = 10;
            RedrawLines();
            RedrawChanInfo();
          }
        }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[6~")		# PgDn
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($window[$thiswin]{scrollback})
        {
          if ($window[$thiswin]{scrollback} > 10)
          {
            $window[$thiswin]{scrollback} = $window[$thiswin]{scrollback} - 10;
            if ($window[$thiswin]{unseen} && $window[$thiswin]{unseen} > $window[$thiswin]{scrollback})
            {
              $window[$thiswin]{unseen} = $window[$thiswin]{scrollback};
            }
          }
          else
          {
            $window[$thiswin]{scrollback} = "";
            $window[$thiswin]{unseen} = "";
          }
          RedrawLines();
          RedrawChanInfo();
        }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "OP")		# F1
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
#        if ($leftwindow ne 1) { DrawLeft(1); }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "OQ")		# F2
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        if ($leftwindow ne 2) { DrawLeft(2); }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "OR")		# F3
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
#        if ($leftwindow ne 3) { DrawLeft(3); }
        $astr = "";
      }
      elsif (substr($astr, 0, 2) eq "OS")		# F4
      {
        if (length($astr) > 2) { $kbuff = $kbuff . substr($astr, 2); }
        if ($leftwindow ne 4) { DrawLeft(4); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[[A")		# F1 (alternative)
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
#        if ($leftwindow ne 1) { DrawLeft(1); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[[B")		# F2 (alternative)
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($leftwindow ne 2) { DrawLeft(2); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[[C")		# F3 (alternative)
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
#        if ($leftwindow ne 3) { DrawLeft(3); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[[D")		# F4 (alternative)
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($leftwindow ne 4) { DrawLeft(4); }
        $astr = "";
      }
      elsif (substr($astr, 0, 3) eq "[[E")		# F5 (alternative)
      {
        if (length($astr) > 3) { $kbuff = $kbuff . substr($astr, 3); }
        if ($leftwindow ne 5) { DrawLeft(5); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[15~")		# F5
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
        if ($leftwindow ne 5) { DrawLeft(5); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[17~")		# F6
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
        if ($leftwindow ne 6) { DrawLeft(6); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[18~")		# F7
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
#        if ($leftwindow ne 7) { DrawLeft(7); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[19~")		# F8
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
        if ($leftwindow ne 8) { DrawLeft(8); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[20~")		# F9
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
        if ($leftwindow ne 9) { DrawLeft(9); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[21~")		# F10
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
#        if ($leftwindow ne 10) { DrawLeft(10); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[23~")		# F11
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
#        if ($leftwindow ne 11) { DrawLeft(11); }
        $astr = "";
      }
      elsif (substr($astr, 0, 4) eq "[24~")		# F12
      {
        if (length($astr) > 4) { $kbuff = $kbuff . substr($astr, 4); }
#        if ($leftwindow ne 12) { DrawLeft(12); }
        $astr = "";
      }
      elsif (defined $astr && length($astr) > 0)
      {
        if (length($astr) > 1) { $kbuff = $kbuff . substr($astr, 1); $astr = substr($astr, 0, 1); }
        if (index("0123456789", $astr) > -1)
        {
          if ($astr eq 0) { $astr = 10; }
          $astr = "/WINDOW $astr";
          goto afterinp;
        }
        else
        {
          $astr = "";
        }
      }
      else
      {
        if ($thiswin > 1 && $window[$thiswin]{protocol} eq 1)
        {
          ClearChatWindow($thiswin, 1);
          if ($thiswin eq $windowcount) { $windowcount--; }
          newWindowInit($thiswin);
          while (! $window[$thiswin]{protocol})
          {
            $thiswin++;
            if ($thiswin > $windowcount) { $thiswin = 1; }
          }
          RedrawNicks();
          RedrawLines();
          if ($window[$thiswin]{protocol} > 1) { RedrawChanInfo(); }
          RedrawActivity();
          if ($window[$thiswin]{channel} && $window[$thiswin]{topic})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          elsif ($window[$thiswin]{channel})
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
          else
          {
            ReTitle("[New Window]");
          }
        }
#        AddLine($thiswin, "`0Escape and nothing more important...`7");
      }
    }
    elsif (ord($astr) eq 127)
    {
      $astr = "";
    }
#    elsif (ord($astr) > 127)
#    {
#      $astr = ord($astr);
#    }
    if (ord($astr) > 31)
    {
      gotoxy(1, $maxy - 2); textcolor(10); addstr($my[$thiswin]{'name'} . ": "); refresh;
      $thisword = $astr;
      textcolor($colour{'typemsg'}); $astr = GetLLine($astr, $maxx - 20 - length($my[$thiswin]{'name'}), 240);
      gotoxy(1, $maxy - 2); textcolor(7); addstr(strpadd("", $maxx - 18, " ")); refresh;
#      addstr("." . ord($astr) . ".");			# Hack
#      if ($astr eq "x") { $ppp = "X NOW"; }		# Hack
    }
    else
    {
#      $astr = ord($astr);
      $astr = "";
    }
    afterinp:
    $afterinpu = "";
    $strout = $astr;
    if ($strout ne "")
    {
      if (($backtype[10] && $strout ne $backtype[10]) || (! $backtype[10]))
      {
        for ($i = 1; $i <= 31; $i++)
        {
          $backtype[$i] = $backtype[$i + 1];
        }
        $backtype[32] = $strout;
      }
    }
    $exitnut = 1;
    $bsl = length($strout . $my[$thiswin]{'name'}) + 2;
    $ppp = rtrim($strout);
    if (uc(ltrim($ppp)) eq "X") { $ppp = "X NOW"; }
    if (substr(ltrim($ppp), 0, 1) eq "/")
    {
      $ppp = ltrim($ppp); $s = "";
      SaveSpace(); if ($ppp ne "X NOW") { $ppp = ""; }
      if ($cheatdeath) { goto fakenum; }
      if ($afterinpu) { goto afterinp; }
    }
    else
    {
#      $ppp = Strrrp($ppp);
      if ($ppp ne "")
      {
        $s = "@@" . $config{'room'} . "`" . colline($tnum) . $config{'name'} . ": `7" . $ppp;
#        if (uc($ppp) ne "X NOW") { AddLine($thiswin, $ppp, "`" . colline($tnum) . $config{'name'} . ": `7"); }
      }
      else
      {
        $s = "";
      }
    }
  }
  DoIdleLoop;
  if (($s eq "") && (time() - $timeto_update > 30))
  {
#    $s = "##000who";
    $timeto_update = time();
  }
  if (($s ne "") && (uc($ppp) ne "X NOW"))
  {
    if (index($ppp, ":") > 0 && (index($ppp, ":") < index($ppp, " ") || index($ppp, " ") < 0))
    {
      $tmpnick = FindUser($thiswin, 10, substr($ppp, 0, index($ppp, ":")));
      if ($tmpnick)
      {
        $ppp = substr($ppp, index($ppp, ":") + 1);
        $ppp = $tmpnick . chr(2) . ":" . chr(2) . $ppp;
      }
    }
    if ($window[$thiswin]->{protocol} eq 1)
    {
      # SendIPX($s, $ipxsocket);
      AddLine($thiswin, $ppp, "`" . colline($tnum) . $my[$thiswin]{'name'} . ": `7");
    }
    elsif (($window[$thiswin]->{protocol} eq 2) && ($ppp ne ""))
    {
      if ($window[$thiswin]{query})
      {
        irc__privmsg($window[$thiswin]->{control}, $window[$thiswin]->{query}, $ppp);
        AddLine($thiswin, $ppp, "`8[`4msg`8(`@" . DoubleQuote($window[$thiswin]{query}) . "`8)] `7");
      }
      elsif ($window[$thiswin]{channel})
      {
        irc__privmsg($window[$thiswin]->{control}, $window[$thiswin]->{channel}, $ppp);
        AddLine($thiswin, $ppp, "`#<`7" . $my[$thiswin]{'name'} . "`#> `7");
      }
    }
    if ($debug) { AddLine($thiswin, "OUT: " . $s); }
    $s = ""; $ppp = "";
  }
  if (($locas ne "") && (index(uc($locas), "X NOW") < 0))
  {
    if ($messwaiting < 20)
    {
      $messwaiting++;
#      UpdateGame(5);
      $mess[$messwaiting] = $locas;
    }
    else
    {
      for ($t = 1; $t <= 19; $t++)
      {
        $mess[$t] = $mess[$t + 1];
      }
      $mess[20] = $locas;
    }
    $locas = "";
    gotoxy(1, $maxy - 2);
  }
  # EatWaiting();
  refresh();
}

if ($logging)
{
  print logfile "\nLogfile closed on " . qbDATE() . " @ " . qbTIME() . "\n";
  close(logfile);
}

if (not $nolang)
{
  close(langfile);
}

# if ((MSCDEXLoaded) && (DrvBusy) && ($config{cdstoponexit}))
# {
#   PauseAudio;
# }

endwin();

#sleep 60;
