##!/usr/bin/perl
#
# Schpati - Pre-Alpha of AndyChat v3.xx
# MODULE: Protocols - IRC
#
# Started on Thursday, 17th of February, 2000 around 11.15pm
#
# 16th of June, 2000
# -  (5.33am) Display correct on_invite message
# -  (5.36am) Implemented $config{joinoninvite}
# -  (5.45am) New unified error thingie (yellow thingie)
# -  (6.16am) irc__newServer, irc__newChannel code tidyups
# -  (6.29am) irc__whichChannel
# -  (6.32am) irc__whichServer
# -  (7.13am) Several changes with the new $srv/$chn bits, little speedups and lots of slowdowns likely
# -  ( ---- ) Lots of reconnect on disconnect work
# -  (9.34am) Fixed some [Server Messages] vs Server Messages
# -  (9.04pm) Temporary workaround for little problem
# - (10.20pm) Casing bug fixed
#
# 13th of June, 2000
# - (10.18pm) Fixed pings not going anywhere bug
# - (10.28pm) Temporary on_invite
# - (11.40pm) Sort modes nicely, removed unnecessary RedrawChanInfo() (I think)
#
# 5th of June, 2000
# -  (5.30am) Added another Austnet extension to Net::IRC to stop nick change in event causing bad errors
#
# 4th of June, 2000
# -  (1.25pm) Fixed 'Already in channel' bug
# -  (1.29pm) Added 'nonewwin' flag to irc__join, to prevent/force creating new window
# -  ( ---- ) Implemented irc__invite
# -  (7.19pm) Fixed rejoinonkick bug
# -  (7.30pm) Channel control is now a reference to Server control
# -  (8.37pm) Don't send blank user(dcc) to user
#
# 3rd of June, 2000
# - (11.10pm) Moved more stuff into irc__join in preparation for join on start and join on invite
# - (11.58pm) Implemented rejoin on kick
#
# 2nd of June, 2000 (after Build 0602 released :P)
# -  (8.04pm) Set rcontrol correctly on autodccget (minor bug)
#
# 2nd of June, 2000
# -  (1.12am) DCC CHAT almost complete :)
# -  (1.14am) Queries now change when user's nick changes
# -  (3.15am) /DCC CHAT sends work now :)
# -  (5.43pm) whichDCC now looks at $acy->peerport and peeraddr :)  Sneaky..
# -  (6.33pm) Rewrote irc__whichDCC several times, got DCC working again :)
#
# 1st of June, 2000
# -  (9.25pm) Optimised some RedrawChanInfo() calls
# -  (9.32pm) Fixed some changes for CTCPs in Net::IRC 0.70 and later
# -  (9.41pm) on_cdcc fixes, CTCP is *VERY* different now(!!)
# -  (9.46pm) Silly silly me
# - (11.01pm) irc__whichDCC implemented, irc__killDCC correctly named
# - (11.09pm) Work begun on irc__on_dcc_open, ooo
# - (12.04am) irc__on_dcc_open chat support done?  irc__on_chat started
#
# 31st of May, 2000
# -  (8.33pm) Code tidying @[ = $[
# -  (9.32pm) Do not DoubleQuote in on_motd (doublequote twice, ouch :P)
#
# 30th of May, 2000
# -  (7.21pm) New on_caction handling for new Net::IRC, now only works with 0.70 or later
#
# 29th of May, 2000
# -  (4.10pm) Started work on irc__newServer, irc__newChannel, irc__newDCC
# -  (4.10pm) Started work on irc__killServer, irc__killChannel, irc__killDCC
#
# 28th of May, 2000
# -  (4.41pm) Window kills now jump to previous window, and windowcount is handled better
# -  (7.19pm) Removed some unnecessary ClearChatWindow things
# -  (8.17pm) Attempt to fix windows not parting correctly
# -  (8.21pm) Found the real bug for the above! :)
# -  (8.23pm) Take #2
#
# 22nd of May, 2000
# -  (1.10pm) Made characters on end of line ncurses 5 compatible, upgrade now :P
# -  ( ---- ) Started on DCC stuffz
#
# 13th of May, 2000
# - (12.38am) Fixed who replies going to wrong window
#
# 7th of May, 2000
# -  (9.07am) LOTS of pizza code cleanups
# -  (9.14am) Even more pizza code cleanups
#
# 1st of May, 2000
# - (11.15pm) Actions now follow queries too
# - (11.17pm) Fixed 'no users displayed' in room bug
#
# 29th of April, 2000
# -  (2.29am) More ` fixes to do with CTCP replies :)
# -  ( ---- ) Implemented on_ctime
# -  (7.27pm) Some NoMoreChannel implementation (not really happy with it)
# - (10.11pm) Fixed phantom $thiswin vs $whichwin on_names bug
# - (10.58pm) More RedrawActivity bits
# - (11.32pm) privmsg/notice now return in proper windows (I think)
#
# 28th of April, 2000
# -  (3.10am) Fixed several on_kick bugs
# -  (3.17am) Fixed several more on_kick bugs
# -  (3.19am) Fixed one more on_kick bug
# -  (3.39am) Added irc__kick function
# -  ( ---- ) Minor on_topic changes
# -  (4.05am) Added irc__on_topicinfo handler
# -  (4.35am) Painfully added better Austnet on_motd parsing which is cool
# -  (5.15am) on_crping, on_crversion, on_crfinger, on_crtime all implemented
# -  (5.44pm) Renamed to a_protocols_irc.pl
# -  (5.46pm) whichcontrol/foreachcontrol now check IRC windows only!
# -  (6.25pm) whichcontrol/foreachcontrol moved to a_protocols and $protocol parameter added
#
# 12th of April, 2000
# - (12.24am) Removed 'Channel mode set twice' warning for +l and +k changes
# -  (1.12am) Fix(?) for some uninit'd value thing which never happened in whichcontrol
# -  (1.12am) Also added query support to whichcontrol
# -  (1.38am) Added all room quit I think
# -  (1.42am) Possible fix for phantom modes after disconnect
# -  (1.44am) Not very good fix for phantom modes on on_part/on_kick
# -  (1.52am) Code tidying for do_disconnect
# -  (2.37am) Undid and redid earlier fix(?)
# -  (2.46am) Did earlier fix and recent fix properly :)
# - (12.47pm) Removed an unnecessary(?) SortUsers command
# -  (4.28pm) Readded SortUsers command
# -  (8.44pm) Tried to fix on_kick problems
#
# 11th of April, 2000
# - (11.55pm) Fixed some bugs to do with using ` around the place
#
# 9th of April, 2000
# -  (3.50pm) Fixed CTCP PIZZA crash :P
# -  (4.36pm) Fixed undef value when doing stuff with new channels and stuffz
# -  (4.46pm) Fixed contents of {id} to avoid multiple user@host causing probs :)
# -  (4.48pm) Fix for $tmpnick . "!" . $tmphost eq $my{id}
# - (12.15am) Change so that receiving private actions are in Cyan like sending private actions
#
# 8th of April, 2000
# -  (2.01pm) No more uninit'd value when in unassigned window
# -  (2.15pm) Added RedrawChanInfo after a chanmode change +o or +v on us
# -  (2.43pm) Fixed users randomly joining wrong channel, twas a casing issue
# -  (3.08pm) Several fixes for new $pizza and NoMore* things
# -  (3.17pm) Better channel/topic protection when killwindowonpart in use
# -  (3.28pm) Better protection against dupe pizza servers (on_part/on_quit now kill stale pizzas)
# -  (4.45pm) Added whoisinserverwindow and awayinserverwindow flags for outputting away/whois replies
# -  (5.00pm) Added on_nosuchnick
# - (12.58am) on_motd/on_lusers changes for "Server Messages"
# -  (1.02am) Some fixes for on_mode stuffz
# -  (1.12am) Removed some error checking on whichcontrol :P
# -  (1.16am) Did some schtuffz to umm... the ummm... nick changing code
#
# 6th of April, 2000
# -  (1.23am) Self nick change now causes a ChanInfo bar refresh
# -  (6.00pm) Added irc__mode
# -  (6.18pm) ChanInfo line updated after /part now
# -  (6.40pm) Added $config{killwindowonpart} support
# - (10.55pm) Added $my{op} detection upon join
#
# 5th of April, 2000
# -  (3.11pm) Implemented noupdate stuffz
# -  (3.27pm) Modes +o-o and +v-v should work to a degree
# -  (3.29pm) Fixed bug relating to sorting not happening in 'other' windows
# -  (3.46pm) Added on_cping
# -  (3.49pm) Fixed on_cping (wonder if that would've crashed clients :P)
# -  (4.23pm) Changed some BitchX stuff to AndyChat stuff
# -  (4.25pm) Restored BitchX stuff, AndyChat didn't work :)
# - (11.35pm) Lots more on_mode stuffz
# - (12.04am) Better self-op/self-voice detection
# - (12.12am) User on_mode stuff half implemented, needs seperate function!
# - (12.15am) Added do_usermodechange function mentioned above
# - (12.20am) Made do_chanmodechange function aswell, for initial mode stuff
# - (12.29am) Implemented on_chanmodeis
#
# 4th of April, 2000
# -  (8.44pm) Added better on_topic support
# -  (8.57pm) on_topic support works now :)
# -  (9.57pm) Displays topic change info in room of topic change
# - (10.30pm) Started implementing on_mode
#
# 28th of March, 2000
# -  (2.21am) Added whichcontrol function thing and made AddLine changes
# -  (2.55am) Finished implementing all $thiswin changes (I think)
# -  (3.59am) Fixed ReTitle and RedrawNicks bug in on_part
# -  ( ---- ) Made DoubleQuote changes and scrapped them
# -  (4.14am) DoubleQuote'd public messies
# -  (5.08am) DoubleQuote'd a lot of stuffz :)
# -  (5.12am) Added irc__join
# -  (5.32am) Did lots of conversion for whichcontrol($self, $channel) stuff
# -  (6.11am) Fixed on_away display
# -  (6.19am) Added server workaround for no signon time
# -  (3.00pm) Started implementing foreachcontrol, global stuffz
# -  (3.14pm) foreachcontrol handler works :)  Nick changes now work properly
# -  (3.15pm) Implemented foreachcontrol to on_quit, gotta love this :)
# -  (3.41pm) Channel specific server messies now end up in correct window
# -  (5.12pm) Clears topic (no more [#bla] Joining... with rooms with no topic)
#
# 25th of March, 2000
# -  (1.05pm) Added better irc__on_disconnect parsing
# -  (1.46pm) Added irc__on_whoisvworld
# -  (1.48pm) Added irc__on_whoishelp
# -  (2.00pm) Better irc__on_disconnect parsing
# -  (3.45pm) Fixed typo which crashed upon topic change
#
# 24th of March, 2000
# -  (1.10am) Added irc__on_cpizza
# -  (1.44am) Completed irc__on_cpizza
# -  (1.46am) Minor fixes to irc__on_cpizza
# -  ( ---- ) Implemented irc__on_endofnames and irc__on_whoreply for stuffz
# -  (3.17am) The new irc__on_join pizza stuff works :)
# -  (3.35am) Added irc__nick
# -  (3.45am) Added irc__on_nicknameinuse
# -  (4.11am) Added CTCP display for people requesting VERSION
# -  (1.24pm) Added whois idle parsing
# -  (1.32pm) Added irc__on_awaytoggle for unaway/nowaway modes
# -  (1.40pm) Added irc__on_away
# -  (1.41pm) Added irc__away
# -  (1.49pm) irc__on_away returns correct stuffz now
# -  (1.59pm) irc__on_awaytoggle now shows the args in grey
# -  (7.49pm) irc__on_msg now adds to pagess buffer
# -  (8.19pm) And does it properly too!
# - (11.14pm) Added irc__part
# - (11.38pm) Added irc__quit
# - (11.44pm) Added irc__on_disconnect
# - (11.51pm) Parsed the quit reason properly
#
# 23rd of March, 2000
# -  (7.03pm) Added irc__ctcp
# - (10.15pm) irc__on_join now sets $usr{id} to hostmask
# - (11.37pm) irc__on_join triggers a ctcp pizza if me = pizza server
#
# 22nd of March, 2000
# -  (1.26am) Added irc__on_nick
#
# 21st of March, 2000
# - (12.38pm) Changed ACS_BULLET to ACS_DEGREE
# -  ( ---- ) Added irc__on_lusers
# -  ( ---- ) Fixed .o. thing on server messies
# -  (1.08pm) -- MARK --
# -  ( ---- ) Added irc__on_notice
# -  (1.40pm) Added irc__on_cversion
# -  ( ---- ) Fixed irc__on_cversion
# -  (2.06pm) Added irc__on_topic
# -  ( ---- ) Fixed irc__on_topic
# -  ( ---- ) Fixed join/part message colours
# -  (2.18pm) Really fixed irc__on_topic
# -  ( ---- ) Fixed wrong character on self-actions
# -  (3.58pm) Added irc__on_quit
# -  (4.00pm) Added reason to quit/part message
# -  (4.05pm) Kinda got the reasons to work
# -  (4.20pm) Added irc__notice
# - (10.28pm) Started whois stuffz
# - (10.32pm) Added irc__on_whoisuser
# - (10.34pm) Added irc__whois
#
# 20th of March, 2000
# - (11.01pm) Finished more of irc__on_caction from earlier
# - ( ----- ) Added irc__privmsg
# - ( ----- ) Added irc__action and got it working!
# - ( ----- ) Added irc__on_motd
#
# 5th of March, 2000
# - (11.14pm) Changed incoming message format and private message format
# - (earlier) Fixed IRC timeouts, even tho I have further work to do on em.
#
# 17th of February, 2000
# - (11.15pm) Initial Development
# - ( ----- ) Added several IRC onevents

# IRC Special Functions

sub irc__inroom {
  my ($whichwin, $self) = @_;

  if ($window[$whichwin]{channel} && uc($window[$whichwin]{channel}) eq uc($tmpchannel))
  {
    $tmpchannels++;
  }
}

sub irc__newServer {
  my $acz;

  if ($irc__servercount)
  {
    for ($acz = 1; $acz <= $irc__servercount; $acz++)
    {
      if (! $irc__server[$acz]{status})
      {
        return $acz;
      }
    }
    $irc__servercount++;
  }
  else
  {
    $irc__servercount = 1;
  }
  return $irc__servercount;
}

sub irc__whichServer {
  my ($acz) = @_;
  # (Self)
  my ($irc__i);

  if (! $irc__servercount)
  {
    return;
  }
  else
  {
    for ($irc__i = 1; $irc__i <= $irc__servercount; $irc__i++)
    {
      if ($irc__server[$irc__i]{control} eq $acz)
      {
        return $irc__i;
      }
    }
  }
}

sub irc__killServer {
  my ($acz) = @_;

  $irc__server[$acz]{control} = "";
  $irc__server[$acz]{status} = "";
  $irc__server[$acz]{ip} = "";
  $irc__server[$acz]{port} = "";
  $irc__server[$acz]{name} = "";
  $irc__server[$acz]{away} = "";
  $irc__server[$acz]{window} = "";
  $irc__server[$acz]{channels} = 0;

  while ($acz eq $irc__servercount && ! $irc__server[$irc__servercount]{status} && $irc__servercount > 0)
  {
    $irc__servercount--;
  }
}

sub irc__newChannel {
  my ($acy) = @_;
  my $acz;

  if ($irc__server[$acy]{channels})
  {
    for ($acz = 1; $acz <= $irc__server[$acy]{channels}; $acz++)
    {
      if (! $irc__channel[$acy][$acz]{status})
      {
        return $acz;
      }
    }
    $irc__server[$acy]{channels}++;
  }
  else
  {
    $irc__server[$acy]{channels} = 1;
  }
  $acz = $irc__server[$acy]{channels};
  irc__killChannel($acy, $acz);
  return $irc__server[$acy]{channels};
}

sub irc__allChannels {
  my ($acz) = @_;
  my ($tmpchannels, $irc__i);

  if (! $irc__server[$acz]{channels})
  {
    return;
  }
  else
  {
    $tmpchannels = "";
    for ($irc__i = 1; $irc__i <= $irc__server[$acz]{channels}; $irc__i++)
    {
      $tmpchannels = $tmpchannels . "," . $irc__channel[$acz][$irc__i]{channel};
    }
    return substr($tmpchannels, 1);
  }
}

sub irc__eachChannel {
  my ($acz, $acy);
  my ($irc__i);

  if (! $irc__server[$acz]{channels})
  {
    return;
  }
  else
  {
    for ($irc__i = 1; $irc__i <= $irc__server[$acz]{channels}; $irc__i++)
    {
      &{$acy}($acz, $irc__i);
    }
  }
}

sub irc__whichChannel {
  my ($acz, $acy, $acx) = @_;
  # (Server, Channel, Status[ni])
  my ($irc__i);

  if (! $irc__server[$acz]{channels})
  {
    return;
  }
  else
  {
    for ($irc__i = 1; $irc__i <= $irc__server[$acz]{channels}; $irc__i++)
    {
      if (uc($irc__channel[$acz][$irc__i]{channel}) eq uc($acy))
      {
        return $irc__i;
      }
    }
  }
}

sub irc__killChannel {
  my ($acy, $acz) = @_;

  $irc__channel[$acy][$acz]{control} = "";
  $irc__channel[$acy][$acz]{status} = "";
  $irc__channel[$acy][$acz]{channel} = "";
  $irc__channel[$acy][$acz]{window} = "";
  $irc__channel[$acy][$acz]{modes} = "";
  $irc__channel[$acy][$acz]{key} = "";
  $irc__channel[$acy][$acz]{limit} = "";
  $irc__channel[$acy][$acz]{users} = 0;
}

sub irc__newDCC {
  my $acz;

  if ($irc__dcccount)
  {
    for ($acz = 1; $acz <= $irc__dcccount; $acz++)
    {
      if (! $irc__dcc[$acz]{status})
      {
        return $acz;
      }
    }
    $irc__dcccount++;
  }
  else
  {
    $irc__dcccount = 1;
  }
  return $irc__dcccount;
}

sub irc__whichDCC {
  my ($acz, $acy, $acx, $acw, $acv) = @_;
  # Self (server), Control (DCC{_socket}), Nick, Type, Status
  my ($irc__i);

  if (! $irc__dcccount)
  {
    return;
  }
  else
  {
    for ($irc__i = 1; $irc__i <= $irc__dcccount; $irc__i++)
    {
      if ((! $acz || $irc__dcc[$irc__i]{server} eq $acz) &&
          (! $acy || ($irc__dcc[$irc__i]{control} && $irc__dcc[$irc__i]{control} eq $acy) || ($irc__dcc[$irc__i]{ip} eq unpack("N", $acy->peeraddr()) && $irc__dcc[$irc__i]{port} eq $acy->peerport())) &&
          (! $acx || $irc__dcc[$irc__i]{name} eq $acx) &&
          (! $acw || $irc__dcc[$irc__i]{type} eq $acw) &&
          (! $acv || $irc__dcc[$irc__i]{status} eq $acv))
      {
        return $irc__i;
      }
    }
  }
  return;
}

sub irc__killDCC {
  my ($acz) = @_;

  $irc__dcc[$acz]{control} = "";
  $irc__dcc[$acz]{rcontrol} = "";
  $irc__dcc[$acz]{server} = "";
  $irc__dcc[$acz]{status} = "";
  $irc__dcc[$acz]{ip} = "";
  $irc__dcc[$acz]{port} = "";
  $irc__dcc[$acz]{name} = "";
  $irc__dcc[$acz]{type} = "";
  $irc__dcc[$acz]{realfile} = "";
  $irc__dcc[$acz]{filename} = "";
  $irc__dcc[$acz]{filesize} = 0;
  $irc__dcc[$acz]{viewsize} = 0;
  $irc__dcc[$acz]{blocksize} = 0;
  undef $irc__dcc[$acz]{fh};
  $irc__dcc[$acz]{progress} = 0;
  $irc__dcc[$acz]{lastwin} = 1;
  $irc__dcc[$acz]{started} = "";
  $irc__dcc[$acz]{active} = "";
}

# IRC Bits!

$__irc_mark1 = "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " ";
$__irc_mark14 = "`\$" . chr(250) . "`%" . chr(237) . "`\$" . chr(250) . " `7";

# IRC Listen/Response

sub irc__connect {
  my ($srv) = @_;
  my ($irc_s);

  $whichwin = $irc__server[$srv]{window};

  if (! $window[$whichwin]{protocol})
  {
    AddLine($whichwin, "Server window for this IRC network has disappeared", $__irc_mark14);
  }
  elsif ($window[$whichwin]{protocol} ne 1)
  {
    AddLine($whichwin, "Window already has an attached protocol", $__irc_mark14);
  }
  else
  {
    $window[$whichwin]{protocol} = 2;
    if ($irc_s = $irc->newconn(Nick => $my[$whichwin]{'name'},
                         Server => $irc__server[$srv]{ip},
                         Port => $irc__server[$srv]{port},
                         Ircname => $config{'ircname'} || 'AndyChat ' . $Version . " - http://andy.secret.com.au/"))
    {
      $irc_s->add_global_handler(378, \&irc__on_motd);
      $irc_s->add_global_handler(377, \&irc__on_motd);
      $irc_s->add_global_handler(376, \&irc__on_connect);
      $irc_s->add_global_handler('disconnect', \&irc__on_disconnect);
      $irc_s->add_global_handler(375, \&irc__on_motd);
      $irc_s->add_global_handler(372, \&irc__on_motd);
      $irc_s->add_global_handler(353, \&irc__on_names);
      $irc_s->add_global_handler(255, \&irc__on_lusers);
      $irc_s->add_global_handler(254, \&irc__on_lusers);
      $irc_s->add_global_handler(253, \&irc__on_lusers);
      $irc_s->add_global_handler(252, \&irc__on_lusers);
      $irc_s->add_global_handler(251, \&irc__on_lusers);
      $irc_s->add_handler('join', \&irc__on_join);
      $irc_s->add_handler('quit', \&irc__on_quit);
      $irc_s->add_handler('nick', \&irc__on_nick);
      $irc_s->add_handler('nicknameinuse', \&irc__on_nicknameinuse);
      $irc_s->add_handler('erroneusnickname', \&irc__on_nicknameinuse);
      $irc_s->add_handler('nowaway', \&irc__on_awaytoggle);
      $irc_s->add_handler('unaway', \&irc__on_awaytoggle);
      $irc_s->add_handler('away', \&irc__on_away);
      $irc_s->add_handler('part', \&irc__on_part);
      $irc_s->add_handler('kick', \&irc__on_kick);
      $irc_s->add_handler('msg', \&irc__on_msg);
      $irc_s->add_handler('whoishelp', \&irc__on_whoishelp);
      $irc_s->add_handler('whoisuser', \&irc__on_whoisuser);
      $irc_s->add_handler('whoisserver', \&irc__on_whoisserver);
      $irc_s->add_handler('whoisoperator', \&irc__on_whoisoperator);
      $irc_s->add_handler('whoischanop', \&irc__on_whoischanop);
      $irc_s->add_handler('whoischannels', \&irc__on_whoischannels);
      $irc_s->add_handler('whoisidle', \&irc__on_whoisidle);
      $irc_s->add_handler('whoisvworld', \&irc__on_whoisvworld);
      $irc_s->add_handler('endofwhois', \&irc__on_endofwhois);
      $irc_s->add_handler('endofnames', \&irc__on_endofnames);
      $irc_s->add_handler('whoreply', \&irc__on_whoreply);
      $irc_s->add_handler('notice', \&irc__on_notice);
      $irc_s->add_handler('public', \&irc__on_public);
      $irc_s->add_handler('caction', \&irc__on_caction);
      $irc_s->add_handler('topic', \&irc__on_topic);
      $irc_s->add_handler('topicinfo', \&irc__on_topicinfo);
      $irc_s->add_handler('crfinger', \&irc__on_crfinger);
      $irc_s->add_handler('ctime', \&irc__on_ctime);
      $irc_s->add_handler('crtime', \&irc__on_crtime);
      $irc_s->add_handler('cversion', \&irc__on_cversion);
      $irc_s->add_handler('crversion', \&irc__on_crversion);
      $irc_s->add_handler('cping', \&irc__on_cping);
      $irc_s->add_handler('crping', \&irc__on_crping);
      $irc_s->add_handler('cpizza', \&irc__on_cpizza);
      $irc_s->add_handler('cnewpizza', \&irc__on_cnewpizza);
      $irc_s->add_handler('cdcc', \&irc__on_cdcc);
      $irc_s->add_handler('cunknown', \&irc__on_cunknown);
      $irc_s->add_handler('umode', \&irc__on_mode);
      $irc_s->add_handler('mode', \&irc__on_mode);
      $irc_s->add_handler('channelmodeis', \&irc__on_chanmodeis);
      $irc_s->add_handler('channelcreate', \&irc__on_channelcreate);
      $irc_s->add_handler('nosuchnick', \&irc__on_nosuchnick);
      $irc_s->add_handler('welcome', \&irc__on_motd);
      $irc_s->add_handler('yourhost', \&irc__on_motd);
      $irc_s->add_handler('created', \&irc__on_motd);
      $irc_s->add_handler('myinfo', \&irc__on_motd);
      $irc_s->add_handler('dcc_open', \&irc__on_dcc_open);
      $irc_s->add_handler('dcc_update', \&irc__on_dcc_update);
      $irc_s->add_handler('dcc_close', \&irc__on_dcc_close);
      $irc_s->add_handler('chat', \&irc__on_chat);
      $irc_s->add_handler('invite', \&irc__on_invite);

      $window[$whichwin]{control} = $irc_s;
      $window[$whichwin]{sortusers} = 1;
      $window[$whichwin]{channel} = "Server Messages";
      $window[$whichwin]{topic} = "irc://" . $irc__server[$srv]{ip} . ":" . $irc__server[$srv]{port} . "/";

      if ($whichwin eq $thiswin)
      {
        RedrawChanInfo();
        ReTitle("[Server Messages] " . $window[$thiswin]{topic});
      }
      else
      {
        RedrawActivity();
      }
    }
    return $irc_s;
  }
}

sub irc__on_connect {
  my $self = shift;
  my ($irc__i, $tmpchannels);

  if ($config{invisonirc})
  {
    $self->mode($my[whichcontrol($self, 2)]{name}, "+i");
  }

  $srv = irc__whichServer($self);

#  AddLine($thiswin, "Control IRC__: $irc__server[$srv]{control}");
#  AddLine($thiswin, "Strict Window: $window[$thiswin]{control}");
#  AddLine($thiswin, "WeThinkWeAre : $self");

  $irc__server[$srv]{status} = 5;

  if ($irc__server[$srv]{channels})
  {
    $tmpchannels = "";
    for ($irc__i = 1; $irc__i <= $irc__server[$srv]{channels}; $irc__i++)
    {
      if ($irc__channel[$srv][$irc__i]{status} eq 6)
      {
        $tmpchannels = $tmpchannels . "," . $irc__channel[$srv][$irc__i]{channel};
      }
    }
    if ($tmpchannels)
    {
      $self->join(substr($tmpchannels, 1));
    }
    if ($irc__server[$srv]{away})
    {
      $self->away($irc__server[$srv]{away});
    }
  }

#  AddLine($thiswin, "Connected to IRC!", Lang(24));
}

sub irc__on_motd {
  my ($self, $event) = @_;
  my ($srv, $chn);

  @args = $event->args;
  shift @args;
  $tmpchannel = $args[0];

  $srv = irc__whichServer($self);

  if (substr($tmpchannel, 0, 1) eq "#" || substr($tmpchannel, 0, 1) eq "&")
  {
    if (index($tmpchannel, " ") > 1)
    {
      $tmpreason = substr($tmpchannel, index($tmpchannel, " ") + 1);
      $tmpchannel = substr($tmpchannel, 0, index($tmpchannel, " "));
    }
    $chn = irc__whichChannel($srv, $tmpchannel);
    $whichwin = $irc__channel[$srv][$chn]{window};
    if (! $whichwin)
    {
      AddLine($thiswin, "$tmpchannel failed new method in on_motd -- please report", $__irc_mark14);
      $whichwin = whichcontrol($self, 2, $tmpchannel);
    }
  }
  else
  {
    $whichwin = $irc__server[$srv]{window};
    if (! $whichwin)
    {
      AddLine($thiswin, "Server failed new method in on_motd -- please report", $__irc_mark14);
      $whichwin = whichcontrol($self, 2, "Server Messages");
    }
  }

  if ($window[$whichwin]{channel} ne "Server Messages")
  {
    if (index($tmpreason, " ") > -1)
    {
      $tmpcontent = substr($tmpreason, index($tmpreason, " ") + 1);
      $tmpreason = substr($tmpreason, 0, index($tmpreason, " "));
    }

    if (substr($tmpreason, length($tmpreason) - 1, 1) eq ":")
    {
      $tmpreason = substr($tmpreason, 0, -1);
    }

    AddLine($whichwin, $tmpcontent, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7$tmpreason `8(`3$tmpchannel`8): `7");
  }
  else
  {
    AddLine($whichwin, "@args", "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7");
  }
#  $mm = "";
#  for ($m = 128; $m < 255; $m++)
#  {
#    $mm = $mm . chr($m);
#  }
#  AddLine($whichwin, $mm);
#  AddLine($whichwin, "@args", "`@-`%o`@- `7");
}

sub irc__on_whoisuser {
  my ($self, $event) = @_;

  $tmpnick = ($event->args)[1];
  $tmphost = ($event->args)[2] . "\@" . ($event->args)[3];
  $tmpname = ($event->args)[5];

  @args = $event->args;

  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "`0-`%=`0- `%" . DoubleQuote($tmpnick) . " `8(`7" . DoubleQuote($tmphost) . "`8) ()");
#  AddLine($whichwin, $tmpname, "`0-`%=`0- `%i`7rcname  : ");

  AddLine($whichwin, "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%" . DoubleQuote($tmpnick) . " `8(`7" . DoubleQuote($tmphost) . "`8) ()");
  AddLine($whichwin, DoubleQuote($tmpname), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%i`7rcname  : ");
}

sub irc__on_whoisserver {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%s`7erver   : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%s`7erver   : ");
}

sub irc__on_whoisoperator {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%o`7perator : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%o`7perator : ");
}

sub irc__on_whoischanop {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%c`7hanop   : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%c`7hanop   : ");
}

sub irc__on_whoisvworld {
  my ($self, $event) = @_;

  $tmphost = ($event->args)[2];

  $tmphost = substr($tmphost, rindex($tmphost, " ") + 1);

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, $tmphost, "`0-`%=`0- `%v`7world   : ");
  AddLine($whichwin, DoubleQuote($tmphost), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%v`7world   : ");
}

sub irc__on_whoishelp {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%i`7nfo     : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%i`7nfo     : ");
}

sub irc__on_whoisidle {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  $tmpidle = $args[0];
  $tmpsignon = $args[1];

  if (index($tmpsignon, "idle") > -1)
  {
    $tmpsignon = 0;
  }
  else
  {
    $tmpsignon = $args[1];
  }

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "`0-`%=`0- `%i`7dle     : " . readablesecs($tmpidle) . " (signon: " . localtime($tmpsignon) . ")");
  AddLine($whichwin, "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%i`7dle     : " . readablesecs($tmpidle) . " (signon: " . localtime($tmpsignon) . ")");
}

sub irc__on_whoischannels {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;
  shift @args;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "@args", "`0-`%=`0- `%c`7hannels : ");
  AddLine($whichwin, DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%c`7hannels : ");
}

sub irc__on_endofwhois {
  my ($self, $event) = @_;

  if ($config{whoisinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, "`0-`%=`0- `%e`7nd of WHOIS");
  AddLine($whichwin, "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%e`7nd of WHOIS");
}

sub irc__whois {
  my ($self, $to) = @_;

  $self->whois($to);
}

sub irc__on_away {
  my ($self, $event) = @_;

  @args = $event->args;

  $tmpnick = $args[1];

  shift @args;
  shift @args;

  if ($config{awayinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, $tmpnick . " - @args", "`0-`%=`0- `%a`7way     : ");
  AddLine($whichwin, DoubleQuote($tmpnick) . " - " . DoubleQuote("@args"), "`0" . chr(250) . "`%" . chr(237) . "`0" . chr(250) . " `%a`7way     : ");
}

sub irc__on_nosuchnick {
  my ($self, $event) = @_;

  @args = $event->args;

  $tmpnick = $args[1];

  shift @args;
  shift @args;

  if ($config{nouserinserverwindow})
  {
    $whichwin = whichcontrol($self, 2, "Server Messages");
  }
  else
  {
    $whichwin = whichcontrol($self, 2);
  }

#  AddLine($whichwin, " - @args", "`#-`%=`#- `%$tmpnick`7");
  AddLine($whichwin, " - " . DoubleQuote("@args"), "`#" . chr(250) . "`%" . chr(237) . "`#" . chr(250) . " `%" . DoubleQuote($tmpnick) . "`7");
}

sub irc__away {
  my ($self, $data) = @_;

  $self->away($data);
}

sub irc__on_awaytoggle {
  my ($self, $event) = @_;

  @args = $event->args;

  shift @args;

#  AddLine(whichcontrol($self, 2), "@args", "`@-`%=`@- `7");
  AddLine(whichcontrol($self, 2), DoubleQuote("@args"), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7");
}

sub irc__on_nicknameinuse {
  my ($self, $event) = @_;

  $my[whichcontrol($self, 2)]{name} = ($event->args)[0];
  $tmpnick = ($event->args)[1];

#  AddLine(whichcontrol($self, 2), "`@-`%=`@- `%" . DoubleQuote($tmpnick) . " `7is already in use or forbidden");
  AddLine(whichcontrol($self, 2), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `%" . DoubleQuote($tmpnick) . " `7is already in use or forbidden");
}

sub irc__do_nickchange {
  my ($whichwin, $self) = @_;

  if ($tmpnick eq $my[$whichwin]{name})
  {
    $my[$whichwin]{name} = $newnick;
    if ($whichwin eq $thiswin)
    {
      RedrawChanInfo();
    }
  }

  if (FindUser($whichwin, 1, $tmpnick))
  {
    RenUser($whichwin, $tmpnick, $newnick);

    $my[$whichwin]{id} = $newnick . substr($my[$whichwin]{id}, length($tmpnick));

#    AddLine($whichwin, "`@-`%=`@- `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
  }

  if ($window[$whichwin]{query} && $window[$whichwin]{query} eq $tmpnick)
  {
    $window[$whichwin]{query} = $newnick;
    if ($whichwin eq $thiswin) { RedrawChanInfo(); }
  }
}

sub irc__on_nick {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
#  $tmphost = $event->host;
  $newnick = ($event->args)[0];

  foreachcontrol($self, 2, \&irc__do_nickchange);

#  RenUser(whichcontrol($self, 2, $tmpto), $tmpnick, $newnick);

#  AddLine(whichcontrol($self, 2, $tmpto), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `%". DoubleQuote($tmpnick) . " `7is now known as `3" . DoubleQuote($newnick));
}

sub irc__nick {
  my ($self, $data) = @_;

  $self->nick($data);
}

sub irc__do_usermodechange {
  my ($whichwin, $self) = @_;

  for ($ap_i = 0; $ap_i < length($tmpmodes); $ap_i++)
  {
    if (substr($tmpmodes, $ap_i, 1) eq "+")
    {
      $tf = 1;
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "-")
    {
      $tf = "";
    }
    else
    {
      if ($tf)
      {
        if ($my[$whichwin]{modes})
        {
          if (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > -1)
          {
            AddLine($whichwin, "User mode set twice", $__irc_mark14);
          }
          else
          {
            $my[$whichwin]{modes} = $my[$whichwin]{modes} . substr($tmpmodes, $ap_i, 1);
          }
        }
        else
        {
          $my[$whichwin]{modes} = substr($tmpmodes, $ap_i, 1);
        }
      }
      else
      {
        if (! $my[$whichwin]{modes} || index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < 0)
        {
          AddLine($whichwin, "    `\@Warning`7: `\%User mode undefined before defined");
        }
        else
        {
          if (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0 && index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < length($my[$whichwin]{modes}) - 1)
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 0, index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1))) .
                                    substr($my[$whichwin]{modes}, index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) + 1);
          }
          elsif (index($my[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0)
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 0, -1);
          }
          else
          {
            $my[$whichwin]{modes} = substr($my[$whichwin]{modes}, 1);
          }
        }
      }
    }
  }

  $my[$whichwin]{modes} = join('', sort(split(//, $my[$whichwin]{modes})));

}

sub irc__do_chanmodechange {
  my ($whichwin) = @_;

  for ($ap_i = 0; $ap_i < length($tmpmodes); $ap_i++)
  {
    if (substr($tmpmodes, $ap_i, 1) eq "+")
    {
      $tf = 1;
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "-")
    {
      $tf = "";
    }
    # o [user]	op
    # v [user]	voice
    # b [mask]	ban

    # k [key] require [key] to join channel
    # l [num]	limit channel number to [num]

    # i	invite only
    # m	moderated, voices only
    # n	no external messages
    # p	private
    # t	topic change restricted to ops
    # s	secret
    elsif (substr($tmpmodes, $ap_i, 1) eq "o")
    {
      $tm++;
      $tmpnum = FindUser($whichwin, 1, $args[$tm]);
      if ($tmpnum)
      {
        $usr[$whichwin][$tmpnum]{op} = $tf;
        if ($usr[$whichwin][$tmpnum]{me})
        {
          $my[$whichwin]{op} = $tf;
          if ($whichwin eq $thiswin) { RedrawChanInfo(); }
        }
        SortUsers($whichwin);
        if ($whichwin eq $thiswin) { RedrawNicks; }
      }
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "v")
    {
      $tm++;
      $tmpnum = FindUser($whichwin, 1, $args[$tm]);
      if ($tmpnum)
      {
        $usr[$whichwin][$tmpnum]{voice} = $tf;
        if ($usr[$whichwin][$tmpnum]{me})
        {
          $my[$whichwin]{voice} = $tf;
          if ($whichwin eq $thiswin) { RedrawChanInfo(); }
        }
        SortUsers($whichwin);
        if ($whichwin eq $thiswin) { RedrawNicks; }
      }
    }
    elsif (substr($tmpmodes, $ap_i, 1) eq "b")
    {
    }
    else
    {
      if (substr($tmpmodes, $ap_i, 1) eq "k")
      {
        if ($tf)
        {
          $tm++;
          $window[$whichwin]{key} = $args[$tm];
        }
        else
        {
          $tm++;
          $window[$whichwin]{key} = "";
          if ($window[$whichwin]{key} && $window[$whichwin]{key} ne $args[$tm])
          {
            AddLine($whichwin, "    `\@Security Error`7: `\%Key change doesn't match previous key!  Ignoring tho :P");
          }
        }
      }
      elsif (substr($tmpmodes, $ap_i, 1) eq "l")
      {
        if ($tf)
        {
          $tm++;
          $window[$whichwin]{limit} = $args[$tm];
        }
        else
        {
          $window[$whichwin]{limit} = "";
        }
      }
      elsif (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > -1)
      {
        AddLine($whichwin, "Channel mode set twice", $__irc_mark14);
      }
      if ($tf)
      {
        if ($window[$whichwin]{modes})
        {
          if (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > -1)
          {
          }
          else
          {
            $window[$whichwin]{modes} = $window[$whichwin]{modes} . substr($tmpmodes, $ap_i, 1);
          }
        }
        else
        {
          $window[$whichwin]{modes} = substr($tmpmodes, $ap_i, 1);
        }
      }
      else
      {
        if (! $window[$whichwin]{modes} || index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < 0)
        {
          AddLine($whichwin, "    `\@Warning`7: `\%Channel mode undefined before defined");
        }
        else
        {
          if (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0 && index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) < length($window[$whichwin]{modes}) - 1)
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 0, index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1))) .
                                        substr($window[$whichwin]{modes}, index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) + 1);
          }
          elsif (index($window[$whichwin]{modes}, substr($tmpmodes, $ap_i, 1)) > 0)
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 0, -1);
          }
          else
          {
            $window[$whichwin]{modes} = substr($window[$whichwin]{modes}, 1);
          }
        }
      }
    }
  }

  $window[$whichwin]{modes} = join('', sort(split(//, $window[$whichwin]{modes})));

  if ($tmpnick)
  {
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7mode`8/`3" . DoubleQuote($tmpto) . " `8[`%" . DoubleQuote("@args") . "`8] `7by `%" . DoubleQuote($tmpnick));
  }
  if ($whichwin eq $thiswin) { RedrawChanInfo(); }
}

sub irc__on_chanmodeis {
  my ($self, $event) = @_;

  @args = $event->args;
  $tmpto = $args[1];
  $tmpnick = "";

  shift @args;
  shift @args;

  $whichwin = whichcontrol($self, 2, $tmpto);
  $tmpmodes = $args[0];
  $tm = 0; $tf = 1;

  irc__do_chanmodechange($whichwin);
}

sub irc__mode {
  my ($self, $to, $data) = @_;

  $self->mode($to, $data);
}

sub irc__on_mode {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;
  $argsize = @args;

  if (substr($tmpto, 0, 1) ne "#" && substr($tmpto, 0, 1) ne "&")
  {
    $tmpmodes = $args[0];
    $tm = 0; $tf = 1;

    foreachcontrol($self, 2, \&irc__do_usermodechange);

    $whichwin = whichcontrol($self, 2, "Server Messages");
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7Mode change `8[`%" . DoubleQuote("@args") . "`8] `7for user `3" . DoubleQuote($tmpto));
    if ($self eq $window[$thiswin]{control})
    {
      RedrawChanInfo();
    }
  }
  else
  {
    $whichwin = whichcontrol($self, 2, $tmpto);
    $tmpmodes = $args[0];
    $tm = 0; $tf = 1;

    irc__do_chanmodechange($whichwin);
#    if ($whichwin eq $thiswin)
#    {
#      RedrawChanInfo();
#    }
  }
}

sub irc__on_debug {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;
  $argsize = @args;

  AddLine($thiswin, "Self: $self");
  AddLine($thiswin, "From: $tmpnick");
  AddLine($thiswin, "  To: $tmpto");
  AddLine($thiswin, "Data: $argsize - @args");
}

sub irc__on_lusers {
  my ($self, $event) = @_;

  @args = $event->args;
  shift @args;

#  AddLine(whichcontrol($self, 2), "@args", "`!-`%=`!- `7");
  AddLine(whichcontrol($self, 2, "Server Messages"), DoubleQuote("@args"), "`!" . chr(250) . "`%" . chr(237) . "`!" . chr(250) . " `7");
}

sub irc__on_msg {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];

  @args = $event->args;

  if ($config{paging})
  {
    if ($pagesswaiting > 1)
    {
      $pagesswaiting--; 
      UpdateGame(6);
    }
    if ($pagesswaiting < 22)
    {
      for ($ap_i = $pagesswaiting; $ap_i <= 22; $ap_i++)
      {
        if ($ap_i > 1)
        {
          $pagess[$ap_i - 1] = $pagess[$ap_i];
        }
      }
    }
    $pagess[21] = $tmpnick . " whispers @args";
    AddLog(whichcontrol($self, 2), $pagess[21]);
  }

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  $whichwin = whichcontrol($self, 2, $tmpnick, 1);
  if (! $whichwin)
  {
    $whichwin = whichcontrol($self, 2);
  }
  AddLine($whichwin, $event->args, "`8[`#" . DoubleQuote($tmpnick) . "`8(`5" . DoubleQuote($tmphost) . "`8)]`7 ");
}

sub irc__on_notice {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];

#  AddLine($event->args, "`\$$tmpnick`7: `%");
  $whichwin = whichcontrol($self, 2, $tmpnick, 1);
  if (! $whichwin)
  {
    $whichwin = whichcontrol($self, 2);
  }
  AddLine($whichwin, $event->args, "`8-`#" . DoubleQuote($tmpnick) . "`8(`5" . DoubleQuote($tmphost) . "`8)-`7 ");
}

sub irc__notice {
  my ($self, $to, $data) = @_;

  $self->notice($to, $data);
}

sub irc__on_public {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];

  AddLine(whichcontrol($self, 2, $tmpto), $event->args, "`9<`7" . DoubleQuote($tmpnick) . "`9>`7 ");
}

sub irc__privmsg {
  my ($self, $to, $data) = @_;

  $self->privmsg($to, $data);
}

sub irc__on_caction {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];

  @args = $event->args;
#  shift @args;

  if (substr($tmpto, 0, 1) eq "&" || substr($tmpto, 0, 1) eq "#")
  {
    AddLine(whichcontrol($self, 2, $tmpto), "@args", "`8" . chr(240) . " `\$" . DoubleQuote($tmpnick) . " `7");
  }
  else
  {
    $whichwin = whichcontrol($self, 2, $tmpnick, 1);
    if (! $whichwin)
    {
      $whichwin = whichcontrol($self, 2);
    }
    AddLine($whichwin, "@args", "`8" . chr(240) . " `!" . DoubleQuote($tmpnick) . " `7");
  }
}

sub irc__action {
  my ($self, $to, $data) = @_;

  $self->ctcp("ACTION", $to, $data);
}

sub irc__ctcp {
  my ($self, $to, $data) = @_;

  if (index($data, " ") > -1)
  {
    $self->ctcp(substr($data, 0, index($data, " ")), $to, substr($data, index($data, " ") + 1));
  }
  else
  {
    $self->ctcp($data, $to);
  }
}

sub irc__on_cunknown {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  AddLine(whichcontrol($self, 2, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested unknown ctcp " . DoubleQuote("@args") . " `7from " . DoubleQuote($tmpto));
}

sub irc__on_cdcc {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;
  @args = split(/ /, $args[0]);

  my $tmpip = inet_ntoa pack "N", $args[2];

  $whichwin = whichcontrol($self, 2, $tmpto);

  if ($args[0] eq "CHAT")
  {
    AddLine($whichwin, $__irc_mark1 . "DCC `7CHAT `8(`7" . DoubleQuote($args[1]) . "`8) `7request from `%" . DoubleQuote($tmpnick) . "`8[`3" . $tmphost . " `7[". $tmpip . ":" . $args[3] . "]`8]");
    $whichdcc = irc__newDCC();
    $irc__dcc[$whichdcc]{status} = 1;	# 0 = Non-existant, 1 = Requested, 2 = Ack/Connecting, 5 = Established
    $irc__dcc[$whichdcc]{name} = $tmpnick;
    $irc__dcc[$whichdcc]{filename} = "chat";
    $irc__dcc[$whichdcc]{ip} = $args[2];
    $irc__dcc[$whichdcc]{port} = $args[3];
    $irc__dcc[$whichdcc]{type} = "chat";
    $irc__dcc[$whichdcc]{server} = $self;
    $irc__dcc[$whichdcc]{lastwin} = $whichwin;
    $irc__dcc[$whichdcc]{active} = time();
    if ($config{autodccchat})
    {
      $irc__dcc[$whichdcc]{status} = 2;
      $self->new_chat(0, $tmpnick, $args[2], $args[3]);
#      $lastwin = $thiswin;
#      ClearChatWindow($thiswin);
#      $thiswin = newwindow();
#      newWindowInit($thiswin, 2);
#      RedrawNicks();
#      $window[$thiswin]{control} = $window[$lastwin]{control};
#      $window[$thiswin]{sortusers} = 1;
#      NewMy($thiswin, $lastwin);
#      $window[$thiswin]->{channel} = $ppp;
#      ReTitle("[" . $window[$thiswin]{channel} . "] Joining...");
#      RedrawChanInfo();
#      RedrawActivity();
    }
  }
  elsif ($args[0] eq "SEND")
  {
    $tmpsize = $args[4] / 1024;
    if ($tmpsize > 1024)
    {
      $tmpsize = $tmpsize / 1024;
      if (index($tmpsize, ".") < length($tmpsize) - 3)
      {
        $tmpsize = substr($tmpsize, 0, index($tmpsize, ".") + 3);
      }
      $tmpsize = $tmpsize . " mb";
    }
    else
    {
      if (index($tmpsize, ".") < length($tmpsize) - 3)
      {
        $tmpsize = substr($tmpsize, 0, index($tmpsize, ".") + 3);
      }
      $tmpsize = $tmpsize . " kb";
    }
    $whichdcc = irc__newDCC();
    $irc__dcc[$whichdcc]{status} = 1;
    $irc__dcc[$whichdcc]{name} = $tmpnick;
    $tmpfile = $args[1];
    if (index($tmpfile, "/") > -1)
    {
      $tmpfile = substr($tmpfile, rindex($tmpfile, "/") + 1);
    }
    $tmpfile =~ s/\.\./\./;
    if (! $tmpfile)
    {
      irc__killDCC($whichdcc);
      AddLine($whichwin, "Invalid DCC SEND from $tmpnick, file was $args[1]", $__irc_mark14);
      return;
    }
    $irc__dcc[$whichdcc]{filename} = ($config{incoming} || "files/") . $tmpfile;
    $irc__dcc[$whichdcc]{realfile} = $args[1];
    $irc__dcc[$whichdcc]{filesize} = $args[4];
    $irc__dcc[$whichdcc]{viewsize} = $tmpsize;
    $irc__dcc[$whichdcc]{ip} = $args[2];
    $irc__dcc[$whichdcc]{port} = $args[3];
    $irc__dcc[$whichdcc]{type} = "get";
    $irc__dcc[$whichdcc]{server} = $self;
    $irc__dcc[$whichdcc]{lastwin} = $whichwin;
    $irc__dcc[$whichdcc]{active} = time();
    AddLine($whichwin, $__irc_mark1 . "DCC `7SEND `8(`7" . DoubleQuote($irc__dcc[$whichdcc]{filename}) . "`8) `7request from `%" . DoubleQuote($tmpnick) . "`8[`3" . $tmphost . " `7[" . $tmpip . ":" . $args[3] . "]`8] `7$tmpsize");
    if ($config{autodccget})
    {
      $irc__dcc[$whichdcc]{status} = 2;
      $irc__dcc[$whichdcc]{progress} = -s $irc__dcc[$whichdcc]{filename};
      if (-s $irc__dcc[$whichdcc]{filename})
      {
        if (-s $irc__dcc[$whichdcc]{filename} < $irc__dcc[$whichdcc]{filesize})
        {
          $irc__dcc[$whichdcc]{fh} = new IO::File ">>$irc__dcc[$whichdcc]{filename}";
          if (defined $irc__dcc[$whichdcc]{fh})
          {
            $irc__dcc[$whichdcc]{rcontrol} = $self->new_get($tmpnick, $args[1], $args[2], $args[3], $args[4], $irc__dcc[$whichdcc]{fh}, $irc__dcc[$whichdcc]{progress});
          }
          else
          {
            AddLine($whichwin, "Error writing to $irc__dcc[$whichdcc]{filename}", $__irc_mark14);
            irc__killDCC($whichdcc);
          }
        }
        elsif (-s $irc__dcc[$whichdcc]{filename} > $irc__dcc[$whichdcc]{filesize})
        {
          AddLine($whichwin, "Local file $irc__dcc[$whichdcc]{filename} bigger than remote??", $__irc_mark14);
          irc__killDCC($whichdcc);
        }
        else
        {
          AddLine($whichwin, "File sizes match, $irc__dcc[$whichdcc]{filename}", $__irc_mark14);
          irc__killDCC($whichdcc);
        }
      }
      else
      {
        $irc__dcc[$whichdcc]{progress} = 0;
        $irc__dcc[$whichdcc]{fh} = new IO::File ">$irc__dcc[$whichdcc]{filename}";
        if (defined $irc__dcc[$whichdcc]{fh})
        {
          $irc__dcc[$whichdcc]{rcontrol} = $self->new_get($tmpnick, $args[1], $args[2], $args[3], $args[4], $irc__dcc[$whichdcc]{fh}, $irc__dcc[$whichdcc]{progress});
        }
        else
        {
          AddLine($whichwin, "Error writing to $irc__dcc[$whichdcc]{filename}", $__irc_mark14);
          irc__killDCC($whichdcc);
        }
      }
    }
  }
}

sub irc__on_chat {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  if (! "@args")
  {
    return;
  }

  $whichdcc = irc__whichDCC("", $tmpto);

  if ($whichdcc)
  {
    $whichwin = whichcontrol($irc__dcc[$whichdcc]{control}, 2, $tmpnick, 1);
    if (! $whichwin) { $whichwin = whichcontrol($irc__dcc[$whichdcc]{control}, 2, "", 1); }
    if (! $whichwin) { $whichwin = whichcontrol($irc__dcc[$whichdcc]{server}, 2, "=" . $tmpnick, 1); }
    if (! $whichwin) { $whichwin = $irc__dcc[$whichdcc]{lastwin}; }
    AddLine($whichwin, "@args", "`8[`0$tmpnick`8(`2dcc`8)] `7");
  }
  else
  {
    AddLine($whichwin, "@args", "`8[`0$tmpnick`8(`2dcc`8)(error)] `7");
  }
}

sub irc__on_dcc_open {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  $whichdcc = irc__whichDCC($self, $tmpto, "", lc($args[0]));

  if (! $whichdcc) { $whichdcc = irc__whichDCC($self, "", $tmpnick, lc($args[0]), 2); } # Dodgy hack! :)

#  if (lc($args[0]) eq "chat")
#  {
#    $whichdcc = irc__whichDCC($self, $tmpto);
#  }
#  elsif (lc($args[0]) eq "get")
#  {
#    $whichdcc = irc__whichDCC($self, $tmpto);
#  }
#  elsif (lc($args[0]) eq "send")
#  {
#    $whichdcc = irc__whichDCC($self, $tmpto);
##    $whichdcc = irc__whichDCC($self, "", $tmpnick, "", 2);
#  }
#  else
#  {
#    return irc__on_debug($self, $event);
#  }

  if ($whichdcc)
  {
    $irc__dcc[$whichdcc]{status} = 5;
    $irc__dcc[$whichdcc]{control} = $tmpto;
    $irc__dcc[$whichdcc]{started} = time();
    $irc__dcc[$whichdcc]{active} = time();
    if (! $irc__dcc[$whichdcc]{ip})
    {
      $irc__dcc[$whichdcc]{ip} = unpack("N", $args[1]->peeraddr());
      $irc__dcc[$whichdcc]{port} = $args[1]->peerport();
    }
#    my $tmpip = inet_ntoa pack "N", $irc__dcc[$whichdcc]{ip};
    my $tmpip = $args[1]->peerhost();
    AddLine($irc__dcc[$whichdcc]{lastwin}, $__irc_mark1 . "DCC `7" . uc($args[0]) . " with `%" . DoubleQuote($tmpnick) . "`8[`3". $tmpip . "`7:" . $irc__dcc[$whichdcc]{port} . "`8] `7established");
  }
  else
  {
    AddLine($thiswin, "I am confused! (Couldn't find " . $tmpnick . "'s DCC " . uc($args[0]) . ")", $__irc_mark14);
    irc__on_debug($self, $event);
  }
}

sub irc__on_dcc_update {
  my ($self, $event) = @_;

  $whichdcc = irc__whichDCC($self, ${($event->to)[0]}{_socket});

  if ($whichdcc)
  {
    if ($event->format eq "GET")
    {
      $irc__dcc[$whichdcc]{progress} = ${($event->args)[0]}{_bin};
    }
    elsif ($event->format eq "SEND")
    {
      $irc__dcc[$whichdcc]{progress} = ${($event->args)[0]}{_bout};
    }
    $irc__dcc[$whichdcc]{active} = time();
    if (! $irc__dcc[$whichdcc]{rcontrol}) { $irc__dcc[$whichdcc]{rcontrol} = ($event->to)[0]; }
  }
  else
  {
    $tmpnick = ${($event->args)[0]}{_nick};
    AddLine($thiswin, "Packet from $tmpnick received on unknown DCC channel", $__irc_mark14);
  }

#  AddLine($thiswin, "nick = $tmpnick");
# Time to work on a more effective way of doing these hashes *Grins*
}

sub irc__on_dcc_close {
  my ($self, $event) = @_;

  $tmpnick = $event->from;
  $tmpto = ($event->to)[0];
  $tmptype = $event->format;

  $whichdcc = irc__whichDCC($self, $tmpto);

  if ($whichdcc)
  {
    $whichwin = whichcontrol($irc__dcc[$whichdcc]{control}, 2, "", 1);
    if (! $whichwin) { $whichwin = whichcontrol($irc__dcc[$whichdcc]{control}, 2, "", 1); }
    if (! $whichwin) { $whichwin = $irc__dcc[$whichdcc]{lastwin}; }
    if ($tmptype eq "GET")
    {
      $irc__dcc[$whichdcc]{fh}->close();
    }

    if ($tmptype eq "GET" || $tmptype eq "SEND")
    {
      if (($tmptype eq "SEND" && $irc__dcc[$whichdcc]{progress} + $irc__dcc[$whichdcc]{blocksize} < $irc__dcc[$whichdcc]{filesize}) ||
          ($tmptype eq "GET" && -s $irc__dcc[$whichdcc]{filename} < $irc__dcc[$whichdcc]{filesize}))
      {
        AddLine($whichwin, $__irc_mark1 . "DCC `7lost $tmptype `4to " . DoubleQuote($tmpnick) . " `8[`7closed`8]");
      }
#      elsif ($irc__dcc[$whichdcc]{progress} eq $irc__dcc[$whichdcc]{filesize})
      else
      {
        my $tmptime = (time() - $irc__dcc[$whichdcc]{started});
        if (index($tmptime, ".") > -1 && index($tmptime, ".") < length($tmptime) - 5)
        {
          $tmptime = substr($tmptime, 0, index($tmptime, ".") + 4);
        }
        my $tmpspeed = ($irc__dcc[$whichdcc]{filesize} / (time() - $irc__dcc[$whichdcc]{started})) / 1000;
        if (index($tmpspeed, ".") > -1 && index($tmpspeed, ".") < length($tmpspeed) - 3)
        {
          $tmpspeed = substr($tmpspeed, 0, index($tmpspeed, ".") + 2);
        }
        if ($tmptype eq "GET") { $tmpwhich = "from" } else { $tmpwhich = "to"; }

        AddLine($whichwin, $__irc_mark1 . "DCC `%" . $tmptype . "`7:`2" . DoubleQuote($irc__dcc[$whichdcc]{realfile}) . " `8[`!$irc__dcc[$whichdcc]{viewsize}`8] `7$tmpwhich " . DoubleQuote($tmpnick) . " completed in " . $tmptime . " secs `8(`%" . $tmpspeed . " `7kb/sec`8)");
      }
#      else
#      {
#        AddLine($whichwin, $__irc_mark1 . "DCC `7overflew $tmptype `4to " . DoubleQuote($tmpnick) . " `8[`7closed`8]");
#      }
    }
    else
    {
      AddLine($whichwin, $__irc_mark1 . "DCC `7lost $tmptype `4to " . DoubleQuote($tmpnick) . " `8[`7closed`8]");
    }
    irc__killDCC($whichdcc);
  }
  else
  {
    AddLine($whichwin, $__irc_mark1 . "DCC `7lost $tmptype `4to " . DoubleQuote($tmpnick) . " `8[`7Unknown DCC`8]");
  }
}

sub irc__on_cpizza {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;
#  shift @args;
  $tmpdata = "@args";

  $whichwin = whichcontrol($self, 2, $tmpto);

  if (substr($tmpto, 0, 1) ne "#" && substr($tmpto, 0, 1) ne "&")
  {
    if (substr($tmpdata, 0, 1) eq "#" || substr($tmpdata, 0, 1) eq "&")
    {
      if (index($tmpdata, " ") > 1)
      {
        $tmpto = substr($tmpdata, 0, index($tmpdata, " "));
        $tmpdata = substr($tmpdata, index($tmpdata, " ") + 1);
      }
      else
      {
        $tmpto = $tmpdata;
        $tmpdata = "";
      }
      $whichwin = whichcontrol($self, 2, $tmpto);
    }
    else
    {
      AddLine($whichwin, "$tmpnick sent an invalid PIZZA packet - $tmpdata", $__irc_mark14);
      return;
    }
  }

#    # Shouldn't be here..  Yes it should :)  My bad :)  Will fix soon :)  Found @ 5.20am . 0328
#    irc__on_cunknown($self, $event);
#    return;
#  }

  $tmpnum = FindUser($whichwin, 1, $event->nick);

  if ($tmpnum)
  {
    if ($window[$whichwin]{pizzahost})
    {
      if ($window[$whichwin]{pizzahost} eq $usr[$whichwin][$tmpnum]{id})
      {
        NoMorePizzas($whichwin);
        AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
        return;
      }
      AddLine($whichwin, "Pizza Server Collision!  But we'll ignore this for now...", $__irc_mark14);
    }
    $window[$whichwin]{pizzahost} = $usr[$whichwin][$tmpnum]{id};
    AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(85));
    if ($window[$whichwin]{pizzas})
    {
      for ($ap_i = 1; $ap_i <= $window[$whichwin]{pizzas}; $ap_i++)
      {
        $pizza[$whichwin][$ap_i]{topping} = "";
        $pizza[$whichwin][$ap_i]{price} = 0;
      }
    }
    $window[$whichwin]{pizzas} = "";
    if ($tmpdata)
    {
      while ($tmpdata)
      {
        if (index($tmpdata, " ") eq 4)
        {
          if ($window[$whichwin]{pizzas})
          {
            $window[$whichwin]{pizzas}++;
          }
          else
          {
            $window[$whichwin]{pizzas} = 1;
          }
          $tmppizzas = $window[$whichwin]{pizzas};
          $pizza[$whichwin][$tmppizzas]{price} = substr($tmpdata, 0, 4);
          $tmpdata = substr($tmpdata, 5);
          if (index($tmpdata, "|") > 0)
          {
            $pizza[$whichwin][$tmppizzas]{topping} = substr($tmpdata, 0, index($tmpdata, "|"));
            $tmpdata = substr($tmpdata, index($tmpdata, "|") + 1);
          }
          else
          {
            $pizza[$whichwin][$tmppizzas]{topping} = $tmpdata;
            $tmpdata = "";
          }
          AddLine($whichwin, Lang(101), Lang(96));
          AddLine($whichwin, Lang(96) . "`%$pizza[$whichwin][$tmppizzas]{topping} `7for only `%\$" . mmoney($pizza[$whichwin][$tmppizzas]{price} / 100) . "`7");
        }
        else
        {
          AddLine($whichwin, "Died after Pizza No. $window[$whichwin]{pizzas}");
          $tmpdata = "";
        }
      }
    }
  }
  else
  {
    AddLine($whichwin, "Imaginary user $tmpnick tried to start a Pizza Server..", $__irc_mark14);
  }
}

sub irc__on_cnewpizza {
  my ($self, $event) = @_;

  $tmpto = ($event->to)[0];
  $tmpnick = $event->nick;
  $whichwin = whichcontrol($self, 2, $tmpto);
  $tmpnum = FindUser($whichwin, 1, $event->nick);
  @args = $event->args;
#  shift @args;
  $tmpdata = "@args";

  if ($tmpnum)
  {
    if ($window[$whichwin]{pizzahost})
    {
      if ($window[$whichwin]{pizzahost} eq $usr[$whichwin][$tmpnum]{id})
      {
        if (index($tmpdata, " ") eq 4)
        {
          if ($window[$whichwin]{pizzas})
          {
            $window[$whichwin]{pizzas}++;
            $pizza[$whichwin][$window[$whichwin]{pizzas}]{topping} = substr($tmpdata, 5);
            $pizza[$whichwin][$window[$whichwin]{pizzas}]{price} = substr($tmpdata, 0, 4);
          }
          else
          {
            $window[$whichwin]{pizzas} = 1;
            $pizza[$whichwin][1]{topping} = substr($tmpdata, 5);
            $pizza[$whichwin][1]{price} = substr($tmpdata, 0, 4);
          }
          AddLine($whichwin, Lang(101), Lang(96));
          AddLine($whichwin, Lang(96) . "`%$pizza[$whichwin][$window[$whichwin]{pizzas}]{topping} `7for only \$`%" . mmoney($pizza[$whichwin][$window[$whichwin]{pizzas}]{price} / 100) . "`7");
        }
        else
        {
          AddLine($whichwin, "Invalid newpizza packet from $tmpnick - @args", $__irc_mark14);
        }
      }
      else
      {
        AddLine($whichwin, "$tmpnick is pretending to be a Pizza Server..", $__irc_mark14);
      }
    }
    else
    {
      AddLine($whichwin, "Received NEWPIZZA from $tmpnick with no pizza host", $__irc_mark14);
    }
  }
  else
  {
    AddLine($whichwin, "Imaginary user $tmpnick tried to start a Pizza Server..", $__irc_mark14);
  }
}

sub irc__on_crfinger {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  @args = $event->args;
#  shift @args;

  AddLine(whichcontrol($self, 2, $tmpto), DoubleQuote("@args"), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7CTCP `%FINGER `7reply from " . DoubleQuote($tmpnick) . ": ");
}

sub irc__on_ctime {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
#  @args = $event->args;

  $self->ctcp_reply($event->nick, "TIME " . localtime);

  AddLine(whichcontrol($self, 2, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested TIME `7from " . DoubleQuote($tmpto));
}

sub irc__on_crtime {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  @args = $event->args;
#  shift @args;

  AddLine(whichcontrol($self, 2, $tmpto), DoubleQuote("@args"), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7CTCP `%TIME `7reply from " . DoubleQuote($tmpnick) . ": ");
}

sub irc__on_cversion {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  $self->ctcp_reply($event->nick, "VERSION AndyChat v$Version - Build $Build");

  AddLine(whichcontrol($self, 2, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested VERSION `7from " . DoubleQuote($tmpto));
}

sub irc__on_crversion {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  @args = $event->args;
#  shift @args;

  AddLine(whichcontrol($self, 2, $tmpto), DoubleQuote("@args"), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7CTCP `%VERSION `7reply from " . DoubleQuote($tmpnick) . ": ");
}

sub irc__on_cping {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpto = ($event->to)[0];
  @args = $event->args;

  $self->ctcp_reply($event->nick, "PING @args");

  AddLine(whichcontrol($self, 2, $tmpto), "`8>`7>`%> `0" . DoubleQuote($tmpnick) . " `8[`2" . DoubleQuote($tmphost) . "`8] `2requested PING `7from " . DoubleQuote($tmpto));
}

sub irc__on_crping {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  @args = $event->args;
#  shift @args;

  $tmpdata = time() - "@args";

  AddLine(whichcontrol($self, 2, $tmpto), $tmpdata . " seconds", "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7CTCP `%PING `7reply from " . DoubleQuote($tmpnick) . ": ");
}

sub irc__on_topic {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmpto = ($event->to)[0];
  @args = $event->args;

#  AddLine($thiswin, "Topic: $tmpto - @args");

  if ($tmpto)
  {
    $window[whichcontrol($self, 2, $tmpto)]->{topic} = Strrrp("@args");
    if (whichcontrol($self, 2, $tmpto) eq $thiswin)
    {
      ReTitle("[" . $window[$thiswin]->{channel} . "] " . Strrrp(DoubleQuote($window[$thiswin]->{topic})));
      refresh();
    }
#    AddLine(whichcontrol($self, 2, $tmpto), "`@-`%=`@- `7Topic `8(`3$tmpto`8): `7changed by `3$tmpnick`8: `7@args");
    AddLine(whichcontrol($self, 2, $tmpto), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7Topic `8(`3$tmpto`8): `7changed by `3$tmpnick`8: `7@args");
  }
  else
  {
    shift @args;
    $tmpto = $args[0];
    shift @args;

    $whichwin = whichcontrol($self, 2, $tmpto);

    if (Strrrp("@args") ne $window[$whichwin]{topic})
    {
      $window[$whichwin]->{topic} = Strrrp("@args");
      if ($whichwin eq $thiswin)
      {
        ReTitle("[" . $window[$thiswin]->{channel} . "] " . Strrrp(DoubleQuote($window[$thiswin]->{topic})));
        refresh();
      }
    }
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7Topic `8(`3$tmpto`8): `7@args");
  }
}

sub irc__on_topicinfo {
  my ($self, $event) = @_;

  @args = $event->args;
  $tmpchannel = $args[1];
  $tmpnick = $args[2];
  $tmptime = $args[3];

  AddLine(whichcontrol($self, 2, $tmpchannel), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7Topic `8(`3" . DoubleQuote($tmpchannel) . "`8): `7set by `3" . DoubleQuote($tmpnick) . " `7on `3" . localtime($tmptime) . "`7");
}

sub irc__on_channelcreate {
  my ($self, $event) = @_;

  @args = $event->args;

  $tmpchannel = $args[1];
  $tmptime = $args[2];

  AddLine(whichcontrol($self, 2, $tmpchannel), "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7Channel " . DoubleQuote($tmpchannel) . " was created on " . localtime($tmptime));
}

sub irc__topic {
  my ($self, $to, $data) = @_;

  $self->topic($to, $data);
}

sub irc__on_whoreply {
  my ($self, $event) = @_;

  $tmpchannel = ($event->args)[1];
  $tmpnick = ($event->args)[5];
  $tmphost = ($event->args)[2] . "\@" . ($event->args)[3];
  @args = $event->args;

  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;
  shift @args;

  $tmpname = "@args";

  $whichwin = whichcontrol($self, 2, $tmpchannel);

  $tmpnum = FindUser($whichwin, 1, $tmpnick);
  if ($tmpnum)
  {
    $usr[$whichwin][$tmpnum]{name} = $tmpnick;
    $usr[$whichwin][$tmpnum]{id} = $tmpnick . "!" . $tmphost;
    $usr[$whichwin][$tmpnum]{fullname} = $tmpname;
  }
}

sub irc__invite {
  my ($self, $whichwin2, $to, $chan) = @_;
  my ($tmpchannel);

  if ((substr($to, 0, 1) eq "#" || substr($to, 0, 1) eq "&") && (substr($chan, 0, 1) eq "#" || substr($chan, 0, 1) eq "&"))
  {
    AddLine($whichwin2, "Usage: /INVITE [nick] [channel]", $__irc_mark14);
    exit;
  }
  elsif ((substr($to, 0, 1) eq "#" || substr($to, 0, 1) eq "&") && (substr($chan, 0, 1) ne "#" && substr($chan, 0, 1) eq "&"))
  {
    $tmpchannel = $to; $to = $chan; $chan = $tmpchannel;
  }
  if (! whichcontrol($self, 2, $chan, 1))
  {
    AddLine($whichwin2, "You are not on channel $chan", $__irc_mark14);
  }
  elsif (FindUser($whichwin, 1, $to))
  {
    AddLine($whichwin2, "$to is already on $chan", $__irc_mark14);
  }

  AddLine($whichwin2, "`8>`7>`%> Inviting $to `7to $chan");
  $self->invite($to, $chan);
}

sub irc__on_invite {
  my ($self, $event) = @_;

  @args = $event->args;

  $whichwin = whichcontrol($self, 2, "Server Messages");
  AddLine($whichwin, "Invites You to @args", "`8>`7>`%> `7");

  if ($config{joinoninvite}) # Well, we better open it discretely in a new window then
  {
    irc__join($self, $whichwin, $args[0], 1);
  }
}

sub irc__on_endofnames {
  my ($self, $event) = @_;

  $tmpchannel = ($event->args)[1];

  $self->who($tmpchannel);
}

sub irc__on_names {
  my ($self, $event) = @_;
  my ($srv, $chn);

  my (@irconlist, $ircchannel) = ($event->args);

  ($ircchannel, @irconlist) = splice @irconlist, 2;
  @irconlist = split(/ /, $irconlist[0]);
  $irconusers = @irconlist;

  $whichwin = whichcontrol($self, 2, $ircchannel);
  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $ircchannel);

  $window[$whichwin]{noupdate} = 1;

  for ($ioni = 0; $ioni < $irconusers; $ioni++)
  {
#    AddUser($win, $ioni + 1, $irconlist[$ioni]);
    if (substr($irconlist[$ioni], 0, 1) eq "+")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
        $irc__channel[$srv][$chn]{users}++;
      }
      $tmpnum = FindUser($whichwin, 1, $irconlist[$ioni]);
      $usr[$whichwin]->[$tmpnum]->{voice} = 1;
      if ($usr[$whichwin][$tmpnum]{me})
      {
        $my[$whichwin]{voice} = 1;
        if ($whichwin eq $thiswin) { RedrawChanInfo(); }
      }
      $window[$whichwin]{noupdate}++;
    }
    elsif (substr($irconlist[$ioni], 0, 1) eq "@")
    {
      $irconlist[$ioni] = substr($irconlist[$ioni], 1);
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
        $irc__channel[$srv][$chn]{users}++;
      }
      $tmpnum = FindUser($whichwin, 1, $irconlist[$ioni]);
      $usr[$whichwin]->[$tmpnum]->{op} = 1;
      if ($usr[$whichwin][$tmpnum]{me})
      {
        $my[$whichwin]{op} = 1;
        if ($whichwin eq $thiswin) { RedrawChanInfo(); }
      }
      $window[$whichwin]{noupdate}++;
    }
    else
    {
      if (not FindUser($whichwin, 1, $irconlist[$ioni]))
      {
        AddUser($whichwin, $irconlist[$ioni]);
        $irc__channel[$srv][$chn]{users}++;
      }
      $window[$whichwin]{noupdate}++;
    }
  }

  if ($window[$whichwin]{noupdate} > 1)
  {
    SortUsers($whichwin);
    if ($whichwin eq $thiswin)
    {
      RedrawNicks();
    }
  }
  $window[$whichwin]{noupdate} = "";
}

sub irc__join {
  my ($self, $whichwin, $to, $nonewwin) = @_;
  my ($srv, $chn);

#  $tmpchannels = 0;

  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $to);

  if (substr($to, 0, 1) ne "#" && substr($to, 0, 1) ne "&")
  {
    AddLine(whichcontrol($self, 2, "Server Messages"), "$to is not a channel.", $__irc_mark14);
  }
  else
  {
#    $tmpchannel = $to; foreachcontrol($self, 2, \&irc__inroom);
#    if ($tmpchannels > 0)
    if ($chn && $irc__channel[$srv][$chn]{status} eq 5)
    {
      AddLine(whichcontrol($self, 2, "Server Messages"), "Already in channel $to", $__irc_mark14);
      return;
    }
    elsif ($whichwin && ! $window[$whichwin]->{channel})
    {
      $self->join($to);
      $window[$whichwin]->{channel} = $to;
      if ($whichwin eq $thiswin)
      {
        ReTitle("[" . $window[$thiswin]{channel} . "] Joining...");
      }
    }
    else
    {
      $lastwin = $whichwin;
      if ($whichwin eq $thiswin && ! $nonewwin)
      {
        ClearChatWindow($thiswin);
      }
      if ($chn)
      {
        # ?? :)
#        $window[$whichwin]{control} = $
      }
      else
      {
        $whichwin = newwindow();
        newWindowInit($whichwin, 2);
        $window[$whichwin]{control} = $window[$lastwin]{control};
#        $window[$whichwin]{control} = \$window[whichcontrol($self, 2, "Server Messages")]{control};
#        bless($window[whichcontrol($self, 2, "Server Messages")]{control}, Net::IRC::Connection);
        $window[$whichwin]{sortusers} = 1;
        NewMy($whichwin, $lastwin);
        $window[$whichwin]->{channel} = $to;
      }
      $self->join($to);
      if (! $nonewwin) { $thiswin = $whichwin; }
      if ($whichwin eq $thiswin)
      {
        RedrawNicks();
        ReTitle("[" . $window[$thiswin]{channel} . "] Joining...");
        RedrawChanInfo();
      }
      RedrawActivity();
    }
#    undef $tmpchannels;

    if (! $chn)
    {
      $chn = irc__newChannel($srv);
      $irc__channel[$srv][$chn]{status} = 1; # Connecting/Joining
      $irc__channel[$srv][$chn]{channel} = $to;
      $irc__channel[$srv][$chn]{window} = $whichwin;
    }
  }
}

sub irc__on_join {
  my ($self, $event) = @_;
  my ($srv, $chn);

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $tmpchannel);

  $whichwin = $irc__channel[$srv][$chn]{window};

  if (! $whichwin) # Safe guard! :)  If things don't go as planned, do it the old way
  {
    $whichwin = whichcontrol($self, 2, $tmpchannel);
    AddLine($thiswin, "$tmpchannel failed new method in on_join -- please report", $__irc_mark14);
  }

  if (not FindUser($whichwin, 1, $tmpnick))
  {
    AddUser($whichwin, $tmpnick);
    $irc__channel[$srv][$chn]{users}++;
  }
  $tmpnum = FindUser($whichwin, 1, $tmpnick);
  $usr[$whichwin][$tmpnum]{id} = $tmpnick . "!" . $tmphost;

  if ($tmpnick eq $my[$whichwin]{name})
  {
    $irc__channel[$srv][$chn]{status} = 5; # Established!
    $my[$whichwin]{id} = $tmpnick . "!" . $tmphost;
    if ($whichwin eq $thiswin) { ReTitle("[" . $window[$whichwin]{channel} . "]"); }
    $usr[$whichwin][$tmpnum]{me} = 1;
    $self->mode($tmpchannel);
    $window[$whichwin]{protocol} = 2;
    $window[$whichwin]{control} = $irc__server[$srv]{control};
    $window[$whichwin]{channel} = $tmpchannel;

    if ($whichwin eq $thiswin) { RedrawChanInfo(); } else { RedrawActivity(); }
  }

  if ($window[$whichwin]{pizzahost} && $window[$whichwin]{pizzahost} eq $my[$whichwin]{id})
  {
    my $tmppizzas = "";
    if ($window[$whichwin]{pizzas})
    {
      for ($ap_i = 1; $ap_i <= $window[$whichwin]{pizzas}; $ap_i++)
      {
        $tmppizzas = $tmppizzas . $pizza[$whichwin][$ap_i]{price} . " " . $pizza[$whichwin][$ap_i]{topping};
        if ($ap_i < $window[$whichwin]{pizzas})
        {
          $tmppizzas = $tmppizzas . "|";
        }
      }
      $tmppizzas = " " . $tmppizzas;
    }
    irc__ctcp($window[$whichwin]{control}, $tmpnick, "PIZZA $tmpchannel" . $tmppizzas);
  }

#  AddLine($whichwin, "`@-`%o`@- `!" . DoubleQuote($tmpnick) . " `8[`3" . DoubleQuote($tmphost) . "`8] `7has joined " . DoubleQuote($tmpchannel));
  AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `!" . DoubleQuote($tmpnick) . " `8[`3" . DoubleQuote($tmphost) . "`8] `7has joined " . DoubleQuote($tmpchannel));
#  AddLine("*** $tmpnick ($tmphost) has joined channel $tmpchannel", Lang(24));
}

sub irc__kick {
  my ($self, $to, $data1, $data2) = @_;

  $self->kick($to, $data1, $data2);
}

sub irc__on_kick {
  my ($self, $event) = @_;
  my ($srv, $chn);

  $tmpnick = $event->nick;
  $tmpwho = ($event->to)[0];

  @args = $event->args;
  $tmpchannel = $args[0];
  shift @args;
  $tmpwhy = "@args";

  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $tmpchannel);

  $whichwin = $irc__channel[$srv][$chn]{window};

  if (! $whichwin) # Safe guard! :)  If things don't go as planned, do it the old way
  {
    $whichwin = whichcontrol($self, 2, $tmpchannel);
    AddLine($thiswin, "$tmpchannel failed new method in on_kick -- please report", $__irc_mark14);
  }

  $tmpnum = FindUser($whichwin, 1, $tmpwho);

  if ($tmpwho eq $my[$whichwin]{name})
  {
    if (! $config{killwindowonkick} || $whichwin eq 1 || $config{rejoinonkick})
    {
      DelUser($whichwin);
      NoMorePizzas($whichwin);
      NoMoreMe($whichwin);
      $window[$whichwin]{channel} = "";
      if ($whichwin eq $thiswin)
      {
        RedrawNicks();
        RedrawChanInfo();
      }
#      ReTitle("");
      $window[$whichwin]{topic} = "";

      AddLine($whichwin, "`8>`7>`%> `%You `7have been kicked off `3" . DoubleQuote($tmpchannel) . " `7by `3" . DoubleQuote($tmpnick) . " `8(`7$tmpwhy`8)");
      if ($config{rejoinonkick})
      {
        irc__join($self, $whichwin, $tmpchannel);
      }
      else
      {
        $irc__channel[$srv][$chn]{status} = 4;
      }
    }
    if ($config{killwindowonkick} && $whichwin > 1)
    {
#      ClearChatWindow($whichwin);
      newWindowInit($whichwin);
      if ($whichwin eq $windowcount) { while (! $window[$windowcount]{protocol} && $windowcount > 1) { $windowcount--; } }
      if ($whichwin eq $thiswin)
      {
        while (! $window[$thiswin]{protocol})
        {
          $thiswin--;
          if ($thiswin < 1) { $thiswin = $windowcount; }
        }
        RedrawNicks();
        RedrawLines();
        RedrawChanInfo();
        if ($window[$thiswin]{channel})
        {
          if ($window[$thiswin]{topic}) 
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          else
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
        }
      }
      AddLine(whichcontrol($self, 2, "Server Messages"), "`8>`7>`%> `%You `7have been kicked off `3" . DoubleQuote($window[$thiswin]{channel}) . " `7by `3" . DoubleQuote($tmpnick) . " `8(`7$tmpwhy`8)");
      irc__killChannel($srv, $chn);
    }
  }
  else
  {
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $usr[$thiswin][$tmpnum]{id})
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    AddLine($whichwin, "`8>`7>`%> `7" . DoubleQuote($tmpwho) . " was kicked off `3" . DoubleQuote($window[$whichwin]{channel}) . " `7by `3" . DoubleQuote($tmpnick) . " `8(`7$tmpwhy`8)");
    DelUser($whichwin, $tmpwho);
    $irc__channel[$srv][$chn]{users}--;
  }
}

sub irc__part {
  my ($self, $to, $data) = @_;

  $self->part($to);
}

sub irc__on_part {
  my ($self, $event) = @_;
  my ($srv, $chn);

  $tmpnick = $event->nick;
  $tmphost = $event->userhost;
  $tmpchannel = ($event->to)[0];

  @args = $event->args;

  shift @args;
#  shift @args;

  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $tmpchannel);

  $whichwin = $irc__channel[$srv][$chn]{window};

  if (! $whichwin) # Safe guard! :)  If things don't go as planned, do it the old way
  {
    $whichwin = whichcontrol($self, 2, $tmpchannel);
    AddLine($thiswin, "$tmpchannel failed new method in on_part -- please report", $__irc_mark14);
  }

  if ($my[$whichwin]{id} && $tmpnick . "!" . $tmphost eq $my[$whichwin]{id})
  {
    if ($irc__channel[$srv][$chn]{status} eq 6) # Rejoin for NO REASON!  Gotta love useless features :P
    {
      AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7" . DoubleQuote($tmpnick) . " `8[`7" . DoubleQuote($tmphost) . "`8] `7has left " . DoubleQuote($tmpchannel) . " `8[`7" . DoubleQuote("@args") . "`8]");
      irc__join($self, $whichwin, $tmpchannel, 1);
    }
    elsif ($config{killwindowonpart} && $whichwin > 1)
    {
#      ClearChatWindow($whichwin);
      newWindowInit($whichwin);
      if ($whichwin eq $windowcount) { while (! $window[$windowcount]{protocol} && $windowcount > 1) { $windowcount--; } }
      if ($whichwin eq $thiswin)
      {
        while (! $window[$thiswin]{protocol})
        {
          $thiswin--;
          if ($thiswin < 1) { $thiswin = $windowcount; }
        }
        RedrawNicks();
        RedrawLines();
        RedrawChanInfo();
        RedrawActivity();
        if ($window[$thiswin]{channel})
        {
          if ($window[$thiswin]{topic}) 
          {
            ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
          }
          else
          {
            ReTitle("[" . $window[$thiswin]{channel} . "]");
          }
        }
      }
      irc__killChannel($srv, $chn);
    }
    else
    {
      DelUser($whichwin);
      NoMoreMe($whichwin);
      NoMoreChannel($whichwin);
      if ($whichwin eq $thiswin)
      {
        RedrawNicks();
        RedrawChanInfo();
      }
#      ReTitle("");
      $window[$whichwin]{topic} = "";

      $irc__channel[$srv][$chn]{status} = 4;

      AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7" . DoubleQuote($tmpnick) . " `8[`7" . DoubleQuote($tmphost) . "`8] `7has left " . DoubleQuote($tmpchannel) . " `8[`7" . DoubleQuote("@args") . "`8]");
    }
  }
  else
  {
    DelUser($whichwin, $tmpnick);
    $irc__channel[$srv][$chn]{users}--;
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $tmphost)
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7" . DoubleQuote($tmpnick) . " `8[`7" . DoubleQuote($tmphost) . "`8] `7has left " . DoubleQuote($tmpchannel) . " `8[`7" . DoubleQuote("@args") . "`8]");
  }
}

sub irc__quit {
  my ($self, $data) = @_;

  $self->quit($data);
}

sub irc__do_disconnect {
  my ($whichwin, $self) = @_;
  my ($srv, $chn);

  $srv = irc__whichServer($self);
  if ($window[$whichwin]{channel}) { $chn = irc__whichChannel($srv, $window[$whichwin]{channel}); }

  if ($config{killwindowonquit} && $whichwin > 1)
  {
    if ($chn) { irc__killChannel($srv, $chn); }
#    ClearChatWindow($whichwin);
    newWindowInit($whichwin);
    if ($whichwin eq $windowcount) { while (! $window[$windowcount]{protocol} && $windowcount > 1) { $windowcount--; } }
    RedrawActivity();
  }
  else
  {
    if ($chn)
    {
      if ($config{rejoinondisconnect})
      {
        $irc__channel[$srv][$chn]{status} = 6; # Auto Rejoin
      }
      else
      {
        $irc__channel[$srv][$chn]{status} = 4; # Dead Channel
      }
    }
    DelUser($whichwin);
#    NoMoreMe($whichwin);
#    $window[$whichwin]{control} = "";
    $window[$whichwin]{protocol} = 1;
    if ($window[$whichwin]{channel} && $window[$whichwin]{channel} ne "Server Messages")
    {
      NoMoreChannel($whichwin);
    }
    if ($whichwin eq $thiswin)
    {
      RedrawNicks();
      RedrawChanInfo();
    }
    RedrawActivity();
#    ReTitle("");
    $window[$whichwin]{topic} = "";

    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7SignOff `%" . DoubleQuote($tmpnick) . "`7: `8(`7" . DoubleQuote($tmpreason) . "`8)");
  }
}

sub irc__on_disconnect {
  my ($self, $event) = @_;
  my ($srv);

  $srv = irc__whichServer($self);

  $tmpnick = ($event->args)[0];

  if (index($tmpnick, ":") > -1)
  {
    $tmpnick = substr($tmpnick, index($tmpnick, ":") + 1);
    $tmpnick = substr($tmpnick, index($tmpnick, ":") + 2);
  }

  if (index($tmpnick, "[") > -1)
  {
    $tmpreason = substr($tmpnick, index($tmpnick, "(") + 1, -1);
    $tmpnick = substr($tmpnick, 0, index($tmpnick, "["));
  }
  else
  {
    if (index($tmpnick, "(") > -1)
    {
      $tmpreason = substr($tmpnick, index($tmpnick, "(") + 1, -1);
      $tmpnick = substr($tmpnick, 0, index($tmpnick, "(") - 1);
    }
    else
    {
      $tmpreason = $tmpnick;
      $tmpnick = $my[$whichwin]{name};
    }
  }

  foreachcontrol($self, 2, \&irc__do_disconnect);

  if (! $window[$thiswin]{protocol})
  {
    while (! $window[$thiswin]{protocol})
    {
      $thiswin--;
      if ($thiswin < 1) { $thiswin = $windowcount; }
    }
    RedrawNicks();
    RedrawLines();
    RedrawChanInfo();
    RedrawActivity();
    if ($window[$thiswin]{channel})
    {
      if ($window[$thiswin]{topic}) 
      {
        ReTitle("[" . $window[$thiswin]{channel} . "] " . Strrrp($window[$thiswin]{topic}));
      }
      else
      {
        ReTitle("[" . $window[$thiswin]{channel} . "]");
      }
    }
  }

  if (($config{reconnectondisconnect} && $irc__server[$srv]{status} ne 3) || $irc__server[$srv]{status} eq 6)
  {
    if ($irc__server[$srv]{control} = irc__connect($srv))
    {
#      AddLine($irc__server[$srv]{window}, "Reconnecting", $__irc_mark14);
    }
    else
    {
      AddLine($irc__server[$srv]{window}, "Unable to reconnect to $irc__server[$srv]{ip}:$irc__server[$srv]{port}", $__irc_mark14);
    }
  }
  else
  {
    $irc__server[$srv]{status} = 4;
  }
}

sub irc__do_quit {
  my ($whichwin, $self) = @_;
  my ($srv, $chn);

  my $tmpnum = FindUser($whichwin, 1, $tmpnick);

  $srv = irc__whichServer($self);
  $chn = irc__whichChannel($srv, $window[$whichwin]{channel});

  if (FindUser($whichwin, 1, $tmpnick))
  {
    if ($window[$thiswin]{pizzahost} && $window[$thiswin]{pizzahost} eq $usr[$whichwin][$tmpnum]{id})
    {
      NoMorePizzas($whichwin);
      AddLine($whichwin, Lang(24) . DoubleQuote($usr[$whichwin][$tmpnum]{name}) . Lang(86));
    }
    DelUser($whichwin, $tmpnick);
    $irc__channel[$srv][$chn]{users}--;
    AddLine($whichwin, "`@" . chr(250) . "`%" . chr(237) . "`@" . chr(250) . " `7SignOff `%" . DoubleQuote($tmpnick) . "`7: " . $window[$whichwin]{channel} . " `8(`7" . DoubleQuote("@args") . "`8)");
  }
}

sub irc__on_quit {
  my ($self, $event) = @_;

  $tmpnick = $event->nick;
  $tmphost = $event->host;
#  $tmpchannel = ($event->to)[0];

  @args = $event->args;

#  shift @args;
#  shift @args;

  foreachcontrol($self, 2, \&irc__do_quit);
}
